/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.change.TypeName;
import org.apache.james.jmap.change.TypeName$;
import org.apache.james.jmap.change.TypeState;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.PushState;
import org.apache.james.jmap.core.PushState$;
import org.apache.james.jmap.core.RequestId;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.State$;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.core.WebSocketError;
import org.apache.james.jmap.core.WebSocketInboundMessage;
import org.apache.james.jmap.core.WebSocketPushDisable$;
import org.apache.james.jmap.core.WebSocketPushEnable;
import org.apache.james.jmap.core.WebSocketRequest;
import org.apache.james.jmap.core.WebSocketResponse;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.WebSocketRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]r!B\f\u0019\u0011\u0003\u0019c!B\u0013\u0019\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%\t\u0001\r\u0005\u0007o\u0005\u0001\u000b\u0011B\u0019\u0007\t\u0015B\u0002\u0001\u000f\u0005\t\u000b\u0016\u0011)\u0019!C\u0001\r\"AQ*\u0002B\u0001B\u0003%q\t\u0003\u0005O\u000b\t\u0005\t\u0015!\u0003P\u0011!\u0011VA!A!\u0002\u0013\u0019\u0006\u0002C3\u0006\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011%,!\u0011!Q\u0001\n)D\u0001B]\u0003\u0003\u0002\u0003\u0006Ia\u001d\u0005\u0006[\u0015!\tA\u001e\u0005\u00073\u0015!\t%!\u0004\t\u000f\u0005\u0015R\u0001\"\u0003\u0002(!9\u00111M\u0003\u0005\n\u0005\u0015\u0004bBAJ\u000b\u0011%\u0011Q\u0013\u0005\b\u0003\u001f,A\u0011BAi\u0011\u001d\t\u0019/\u0002C\u0005\u0003KDq!!;\u0006\t\u0013\tY\u000fC\u0004\u0003\n\u0015!IAa\u0003\t\u000f\t\u001dR\u0001\"\u0003\u0003*\u0005yq+\u001a2T_\u000e\\W\r\u001e*pkR,7O\u0003\u0002\u001a5\u00051!o\\;uKNT!a\u0007\u000f\u0002\t)l\u0017\r\u001d\u0006\u0003;y\tQA[1nKNT!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u0001\u0001C\u0001\u0013\u0002\u001b\u0005A\"aD,fEN{7m[3u%>,H/Z:\u0014\u0005\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002G\u00051AjT$H\u000bJ+\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0001\nQa\u001d7gi)L!AN\u001a\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u001a2!B\u001dB!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u00142kK\u000e$\bC\u0001\"D\u001b\u0005Q\u0012B\u0001#\u001b\u0005)QU*\u0011)S_V$Xm]\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u000e\u0002\t!$H\u000f]\u0005\u0003\u0019&\u0013Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u0010kN,'\u000f\u0015:pm&\u001c\u0018n\u001c8feB\u0011\u0001\nU\u0005\u0003#&\u0013\u0001#V:feB\u0013xN^5tS>t\u0017N\\4\u0002\u0011\u00154XM\u001c;CkN\u0004\"\u0001V,\u000e\u0003US!A\u0016\u000f\u0002\r\u00154XM\u001c;t\u0013\tAVK\u0001\u0005Fm\u0016tGOQ;tQ\u0011I!LY2\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016AB5oU\u0016\u001cGOC\u0001`\u0003\u0015Q\u0017M^1y\u0013\t\tGLA\u0003OC6,G-A\u0003wC2,X-I\u0001e\u0003\u0011QU*\u0011)\u0002\u000f)l\u0017\r]!qSB\u0011AeZ\u0005\u0003Qb\u0011qAS'B!\u0006\u0003\u0018.A\fnC&d'm\u001c=DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ssB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0007G\"\fgnZ3\u000b\u0005=T\u0012aA1qS&\u0011\u0011\u000f\u001c\u0002\u0018\u001b\u0006LGNY8y\u0007\"\fgnZ3SKB|7/\u001b;pef\fQ#Z7bS2\u001c\u0005.\u00198hKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002li&\u0011Q\u000f\u001c\u0002\u0016\u000b6\f\u0017\u000e\\\"iC:<WMU3q_NLGo\u001c:z)%9\b\u0010`?\u0000\u0003\u0003\t\u0019\u0001\u0005\u0002%\u000b!)Q)\u0004a\u0001\u000f\"\"\u0001P\u00172{C\u0005Y\u0018\u0001\u0003*G\u00076BdGM\u0019\t\u000b9k\u0001\u0019A(\t\u000bIk\u0001\u0019A*)\tuT&m\u0019\u0005\u0006K6\u0001\rA\u001a\u0005\u0006S6\u0001\rA\u001b\u0005\u0006e6\u0001\ra\u001d\u0015\u0004\u001b\u0005\u001d\u0001cA.\u0002\n%\u0019\u00111\u0002/\u0003\r%s'.Z2u)\t\ty\u0001\u0005\u0004\u0002\u0012\u0005m\u0011qD\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u000511\u000f\u001e:fC6T1!!\u0007>\u0003\u0011)H/\u001b7\n\t\u0005u\u00111\u0003\u0002\u0007'R\u0014X-Y7\u0011\u0007\t\u000b\t#C\u0002\u0002$i\u0011\u0011BS'B!J{W\u000f^3\u0002!!\fg\u000e\u001a7f/\u0016\u00147k\\2lKR\u001cHCBA\u0015\u0003\u0007\nI\u0006\u0005\u0004\u0002,\u0005e\u0012QH\u0007\u0003\u0003[QA!a\f\u00022\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0005\u0003g\t)$\u0001\u0003d_J,'BAA\u001c\u0003\u001d\u0011X-Y2u_JLA!a\u000f\u0002.\t!Qj\u001c8p!\rQ\u0014qH\u0005\u0004\u0003\u0003Z$\u0001\u0002,pS\u0012Dq!!\u0012\u0010\u0001\u0004\t9%A\tiiR\u00048+\u001a:wKJ\u0014V-];fgR\u0004B!!\u0013\u0002V5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0004tKJ4XM\u001d\u0006\u0004\u0015\u0006E#\u0002BA*\u0003k\tQA\\3uifLA!a\u0016\u0002L\t\t\u0002\n\u001e;q'\u0016\u0014h/\u001a:SKF,Xm\u001d;\t\u000f\u0005ms\u00021\u0001\u0002^\u0005\u0011\u0002\u000e\u001e;q'\u0016\u0014h/\u001a:SKN\u0004xN\\:f!\u0011\tI%a\u0018\n\t\u0005\u0005\u00141\n\u0002\u0013\u0011R$\boU3sm\u0016\u0014(+Z:q_:\u001cX-A\riC:$G.Z,fEN{7m[3u\u0007>tg.Z2uS>tG\u0003BA4\u0003\u0007#b!!\u000b\u0002j\u0005e\u0004bBA6!\u0001\u0007\u0011QN\u0001\u0003S:\u0004B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\ny%A\u0005xK\n\u001cxnY6fi&!\u0011qOA9\u0005A9VMY:pG.,G/\u00138c_VtG\rC\u0004\u0002|A\u0001\r!! \u0002\u0007=,H\u000f\u0005\u0003\u0002p\u0005}\u0014\u0002BAA\u0003c\u0012\u0011cV3cg>\u001c7.\u001a;PkR\u0014w.\u001e8e\u0011\u001d\t)\t\u0005a\u0001\u0003\u000f\u000bqa]3tg&|g\u000e\u0005\u0003\u0002\n\u0006=UBAAF\u0015\r\ti\tH\u0001\b[\u0006LGNY8y\u0013\u0011\t\t*a#\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\u0006!\u0002.\u00198eY\u0016\u001cE.[3oi6+7o]1hKN$B!a&\u0002FR!\u0011\u0011TAV!\u0019\tY*!)\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003_\tyJC\u0002+\u0003cIA!a)\u0002\u001e\n)1+T8o_B\u0019\u0001&a*\n\u0007\u0005%\u0016F\u0001\u0003V]&$\bbBAW#\u0001\u0007\u0011qV\u0001\b[\u0016\u001c8/Y4f!\u0011\t\t,a0\u000f\t\u0005M\u00161\u0018\t\u0004\u0003kKSBAA\\\u0015\r\tILI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005u\u0016&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\f\u0019M\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{K\u0003bBAd#\u0001\u0007\u0011\u0011Z\u0001\u000eG2LWM\u001c;D_:$X\r\u001f;\u0011\u0007\u0011\nY-C\u0002\u0002Nb\u0011Qb\u00117jK:$8i\u001c8uKb$\u0018\u0001G:f]\u0012\u0004Vo\u001d5Ti\u0006$X-\u00134SKF,Xm\u001d;fIR1\u0011\u0011TAj\u0003CDq!!6\u0013\u0001\u0004\t9.\u0001\u0006qkNDWI\\1cY\u0016\u0004B!!7\u0002^6\u0011\u00111\u001c\u0006\u0004\u0003gQ\u0012\u0002BAp\u00037\u00141cV3c'>\u001c7.\u001a;QkNDWI\\1cY\u0016Dq!a2\u0013\u0001\u0004\tI-A\u0007tK:$\u0007+^:i'R\fG/\u001a\u000b\u0005\u00033\u000b9\u000fC\u0004\u0002HN\u0001\r!!3\u00021!\fg\u000e\u001a7f\u0011R$\b\u000fS1oIND\u0017m[3FeJ|'\u000f\u0006\u0004\u0002n\u0006=(Q\u0001\t\u0007\u00037\u000b\t+!\u0010\t\u000f\u0005EH\u00031\u0001\u0002t\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0003k\fyP\u0004\u0003\u0002x\u0006mh\u0002BA[\u0003sL\u0011AK\u0005\u0004\u0003{L\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0011\u0019AA\u0005UQJ|w/\u00192mK*\u0019\u0011Q`\u0015\t\u000f\t\u001dA\u00031\u0001\u0002^\u0005A!/Z:q_:\u001cX-A\u0004bg\u0016\u0013(o\u001c:\u0015\t\t5!q\u0003\u000b\u0005\u0005\u001f\u0011)\u0002\u0005\u0003\u0002Z\nE\u0011\u0002\u0002B\n\u00037\u0014abV3c'>\u001c7.\u001a;FeJ|'\u000fC\u0004\u0002rV\u0001\r!a=\t\u000f\teQ\u00031\u0001\u0003\u001c\u0005I!/Z9vKN$\u0018\n\u001a\t\u0006Q\tu!\u0011E\u0005\u0004\u0005?I#AB(qi&|g\u000e\u0005\u0003\u0002Z\n\r\u0012\u0002\u0002B\u0013\u00037\u0014\u0011BU3rk\u0016\u001cH/\u00133\u0002\u001dI,7\u000f]8oI\u0012+G/Y5mgR1\u0011Q\u001eB\u0016\u0005[Aq!a\u0017\u0017\u0001\u0004\ti\u0006C\u0004\u00030Y\u0001\rA!\r\u0002\u000f\u0011,G/Y5mgB!\u0011\u0011\u001cB\u001a\u0013\u0011\u0011)$a7\u0003\u001dA\u0013xN\u00197f[\u0012+G/Y5mg\u0002")
public class WebSocketRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final JMAPApi jmapApi;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final EmailChangeRepository emailChangeRepository;

    public static Logger LOGGER() {
        return WebSocketRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/jmap/ws")).action((httpServerRequest, httpServerResponse) -> this.handleWebSockets(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/jmap/ws")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleWebSockets(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(SMono$.MODULE$.apply((Publisher)httpServerResponse.sendWebsocket((in, out) -> this.handleWebSocketConnection((MailboxSession)mailboxSession, (WebsocketInbound)in, (WebsocketOutbound)out))))).onErrorResume((Function1 & Serializable)throwable -> this.handleHttpHandshakeError((Throwable)throwable, httpServerResponse)).subscribeOn(Schedulers.elastic()).asJava().then();
    }

    private Mono<Void> handleWebSocketConnection(MailboxSession session, WebsocketInbound in, WebsocketOutbound out) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        out.sendString((Publisher)sink.asFlux().map(outboundMessage -> ResponseSerializer$.MODULE$.serialize((OutboundMessage)outboundMessage)).map(json -> Json$.MODULE$.stringify(json)), StandardCharsets.UTF_8).then().subscribeOn(Schedulers.elastic()).subscribe();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux qual$1 = SFlux$.MODULE$.apply((Publisher)in.aggregateFrames().receiveFrames()).map((Function1 & Serializable)frame -> {
            byte[] bytes = new byte[frame.content().readableBytes()];
            frame.content().readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)message -> this.handleClientMessages(context, (String)message);
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> context.clean()).then().asJava().then();
    }

    private SMono<BoxedUnit> handleClientMessages(ClientContext clientContext, String message) {
        return (SMono)ResponseSerializer$.MODULE$.deserializeWebSocketInboundMessage(message).fold((Function1 & Serializable)invalid -> {
            WebSocketError error = this.asError((Option<RequestId>)None$.MODULE$, new IllegalArgumentException(invalid.toString()));
            return SMono$.MODULE$.fromCallable(() -> {
                WebSocketRoutes.$anonfun$handleClientMessages$2(clientContext, error);
                return BoxedUnit.UNIT;
            });
        }, (Function1 & Serializable)x0$1 -> {
            SMono sMono;
            WebSocketInboundMessage webSocketInboundMessage = x0$1;
            if (webSocketInboundMessage instanceof WebSocketRequest) {
                WebSocketRequest webSocketRequest = (WebSocketRequest)webSocketInboundMessage;
                sMono = $this.jmapApi.process(webSocketRequest.requestObject(), clientContext.session()).map((Function1 & Serializable)x$1 -> new WebSocketResponse(webSocketRequest.requestId(), (ResponseObject)x$1)).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)this.asError(webSocketRequest.requestId(), (Throwable)e))).subscribeOn(Schedulers.elastic()).doOnNext((Function1 & Serializable)next -> {
                    WebSocketRoutes.$anonfun$handleClientMessages$6(clientContext, next);
                    return BoxedUnit.UNIT;
                }).then();
            } else if (webSocketInboundMessage instanceof WebSocketPushEnable) {
                WebSocketPushEnable webSocketPushEnable = (WebSocketPushEnable)webSocketInboundMessage;
                sMono = SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener((Set<TypeName>)((Set)webSocketPushEnable.dataTypes().getOrElse((Function0 & Serializable)() -> TypeName$.MODULE$.ALL())), clientContext.outbound()), (RegistrationKey)AccountIdRegistrationKey$.MODULE$.of(clientContext.session().getUser()))).doOnNext((Function1 & Serializable)newRegistration -> {
                    clientContext.withRegistration(newRegistration);
                    return BoxedUnit.UNIT;
                }).then(this.sendPushStateIfRequested(webSocketPushEnable, clientContext));
            } else if (WebSocketPushDisable$.MODULE$.equals(webSocketInboundMessage)) {
                sMono = SMono$.MODULE$.fromCallable(() -> {
                    clientContext.clean();
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)webSocketInboundMessage);
            }
            return sMono;
        });
    }

    private SMono<BoxedUnit> sendPushStateIfRequested(WebSocketPushEnable pushEnable, ClientContext clientContext) {
        return (SMono)pushEnable.pushState().map((Function1 & Serializable)x$2 -> this.sendPushState(clientContext)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
    }

    private SMono<BoxedUnit> sendPushState(ClientContext clientContext) {
        Username username = clientContext.session().getUser();
        org.apache.james.jmap.core.AccountId accountId = (org.apache.james.jmap.core.AccountId)AccountId$.MODULE$.from(username).fold((Function1 & Serializable)failure -> {
            throw new IllegalArgumentException((Throwable)failure);
        }, (Function1 & Serializable)success -> success);
        return SMono$.MODULE$.apply((Publisher)this.mailboxChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).flatMap(mailboxState -> $this.emailChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).map(emailState -> {
            WebSocketRoutes.$anonfun$sendPushState$4(clientContext, accountId, mailboxState, emailState);
            return BoxedUnit.UNIT;
        })));
    }

    private SMono<Void> handleHttpHandshakeError(Throwable throwable, HttpServerResponse response) {
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private WebSocketError asError(Option<RequestId> requestId, Throwable throwable) {
        return new WebSocketError(requestId, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    public static final /* synthetic */ void $anonfun$handleClientMessages$2(ClientContext clientContext$1, WebSocketError error$1) {
        clientContext$1.outbound().emitNext((Object)error$1, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    public static final /* synthetic */ void $anonfun$handleClientMessages$6(ClientContext clientContext$1, OutboundMessage next) {
        clientContext$1.outbound().emitNext((Object)next, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    public static final /* synthetic */ void $anonfun$sendPushState$4(ClientContext clientContext$3, org.apache.james.jmap.core.AccountId accountId$1, State mailboxState$1, State emailState) {
        clientContext$3.outbound().emitNext((Object)new StateChange((Map<org.apache.james.jmap.core.AccountId, TypeState>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)accountId$1), (Object)new TypeState((Map<TypeName, org.apache.james.jmap.core.State>)((Map)MailboxTypeName$.MODULE$.asMap((Option<org.apache.james.jmap.core.State>)new Some((Object)State$.MODULE$.fromJava(mailboxState$1))).$plus$plus(EmailTypeName$.MODULE$.asMap((Option<org.apache.james.jmap.core.State>)new Some((Object)State$.MODULE$.fromJava(emailState)))))))}))), (Option<PushState>)new Some((Object)PushState$.MODULE$.from(mailboxState$1, emailState))), Sinks.EmitFailureHandler.FAIL_FAST);
    }

    @Inject
    public WebSocketRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, JMAPApi jmapApi, MailboxChangeRepository mailboxChangeRepository, EmailChangeRepository emailChangeRepository) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.jmapApi = jmapApi;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.emailChangeRepository = emailChangeRepository;
    }
}

