/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.PingMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.EventSourceOptions;
import org.apache.james.jmap.routes.EventSourceOptions$;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\u0007\u000e\u0001aA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\t[\u0001\u0011\t\u0011)A\u0005O!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015q\u0001\u0001\"\u0011U\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003{\u0002A\u0011BA@\u0005E)e/\u001a8u'>,(oY3S_V$Xm\u001d\u0006\u0003\u001d=\taA]8vi\u0016\u001c(B\u0001\t\u0012\u0003\u0011QW.\u00199\u000b\u0005I\u0019\u0012!\u00026b[\u0016\u001c(B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001aE\u0002\u00013\u0005\u0002\"AG\u0010\u000e\u0003mQ!\u0001H\u000f\u0002\t1\fgn\u001a\u0006\u0002=\u0005!!.\u0019<b\u0013\t\u00013D\u0001\u0004PE*,7\r\u001e\t\u0003E\rj\u0011aD\u0005\u0003I=\u0011!BS'B!J{W\u000f^3t\u00035\tW\u000f\u001e5f]RL7-\u0019;peV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\u001f\u0005!\u0001\u000e\u001e;q\u0013\ta\u0013FA\u0007BkRDWM\u001c;jG\u0006$xN]\u0001\u000fCV$\b.\u001a8uS\u000e\fGo\u001c:!\u0003=)8/\u001a:Qe>4\u0018n]5p]\u0016\u0014\bC\u0001\u00151\u0013\t\t\u0014F\u0001\tVg\u0016\u0014\bK]8wSNLwN\\5oO\u0006AQM^3oi\n+8\u000f\u0005\u00025o5\tQG\u0003\u00027#\u00051QM^3oiNL!\u0001O\u001b\u0003\u0011\u00153XM\u001c;CkNDC\u0001\u0002\u001eC\u0007B\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0007S:TWm\u0019;\u000b\u0003}\nQA[1wCbL!!\u0011\u001f\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0003\u0011\u000bAAS'B!\u00061A(\u001b8jiz\"BaR%N\u001dB\u0011\u0001\nA\u0007\u0002\u001b!)Q%\u0002a\u0001O!\"\u0011J\u000f\"LC\u0005a\u0015\u0001\u0003*G\u00076BdGM\u0019\t\u000b9*\u0001\u0019A\u0018\t\u000bI*\u0001\u0019A\u001a)\t9S$i\u0011\u0015\u0003\u000bE\u0003\"a\u000f*\n\u0005Mc$AB%oU\u0016\u001cG\u000fF\u0001V!\r16,X\u0007\u0002/*\u0011\u0001,W\u0001\u0007gR\u0014X-Y7\u000b\u0005ik\u0012\u0001B;uS2L!\u0001X,\u0003\rM#(/Z1n!\t\u0011c,\u0003\u0002`\u001f\tI!*T!Q%>,H/Z\u0001\nQ\u0006tG\r\\3T'\u0016#2AY8{!\r\u0019'\u000e\\\u0007\u0002I*\u0011QMZ\u0001\naV\u0014G.[:iKJT!a\u001a5\u0002\t\r|'/\u001a\u0006\u0002S\u00069!/Z1di>\u0014\u0018BA6e\u0005\u0011iuN\\8\u0011\u0005ii\u0017B\u00018\u001c\u0005\u00111v.\u001b3\t\u000bA<\u0001\u0019A9\u0002\u000fI,\u0017/^3tiB\u0011!\u000f_\u0007\u0002g*\u0011A/^\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005)2(BA<i\u0003\u0015qW\r\u001e;z\u0013\tI8OA\tIiR\u00048+\u001a:wKJ\u0014V-];fgRDQa_\u0004A\u0002q\f\u0001B]3ta>t7/\u001a\t\u0003evL!A`:\u0003%!#H\u000f]*feZ,'OU3ta>t7/Z\u0001\fe\u0016<\u0017n\u001d;feN\u001bV\t\u0006\u0005\u0002\u0004\u0005m\u0011QDA\u0017!\u0019\t)!!\u0004\u0002\u00125\u0011\u0011q\u0001\u0006\u0004K\u0006%!bAA\u0006M\u0006)1oY1mC&!\u0011qBA\u0004\u0005\u0015\u0019Vj\u001c8p!\u0011\t\u0019\"a\u0006\u000e\u0005\u0005U!BAA\u0006\u0013\u0011\tI\"!\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006w\"\u0001\r\u0001 \u0005\b\u0003?A\u0001\u0019AA\u0011\u0003\u001d\u0019Xm]:j_:\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\t\u0012aB7bS2\u0014w\u000e_\u0005\u0005\u0003W\t)C\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\t\u000f\u0005=\u0002\u00021\u0001\u00022\u00059q\u000e\u001d;j_:\u001c\bc\u0001%\u00024%\u0019\u0011QG\u0007\u0003%\u00153XM\u001c;T_V\u00148-Z(qi&|gn]\u0001\u000bCN\u001c6+R#wK:$H\u0003BA\u001e\u0003#\u0002B!!\u0010\u0002L9!\u0011qHA$!\u0011\t\t%!\u0006\u000e\u0005\u0005\r#bAA#/\u00051AH]8pizJA!!\u0013\u0002\u0016\u00051\u0001K]3eK\u001aLA!!\u0014\u0002P\t11\u000b\u001e:j]\u001eTA!!\u0013\u0002\u0016!9\u00111K\u0005A\u0002\u0005U\u0013aD8vi\n|WO\u001c3NKN\u001c\u0018mZ3\u0011\t\u0005]\u00131L\u0007\u0003\u00033R!aZ\b\n\t\u0005u\u0013\u0011\f\u0002\u0010\u001fV$(m\\;oI6+7o]1hK\u0006\u0011\u0003.\u00198eY\u0016\u001cuN\u001c8fGRLwN\\#ti\u0006\u0014G.[:i[\u0016tG/\u0012:s_J$b!a\u0019\u0002f\u0005m\u0004#BA\u0003\u0003\u001ba\u0007bBA4\u0015\u0001\u0007\u0011\u0011N\u0001\ni\"\u0014xn^1cY\u0016\u0004B!a\u001b\u0002v9!\u0011QNA9\u001d\u0011\t\t%a\u001c\n\u0005\u0005-\u0011\u0002BA:\u0003+\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002x\u0005e$!\u0003+ie><\u0018M\u00197f\u0015\u0011\t\u0019(!\u0006\t\u000bmT\u0001\u0019\u0001?\u0002\u001dI,7\u000f]8oI\u0012+G/Y5mgR1\u00111MAA\u0003\u0007CQa_\u0006A\u0002qDq!!\"\f\u0001\u0004\t9)A\u0004eKR\f\u0017\u000e\\:\u0011\t\u0005]\u0013\u0011R\u0005\u0005\u0003\u0017\u000bIF\u0001\bQe>\u0014G.Z7EKR\f\u0017\u000e\\:")
public class EventSourceRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/eventSource")).action((request, response) -> this.handleSSE(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/eventSource")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleSSE(HttpServerRequest request, HttpServerResponse response) {
        return ((SMono)EventSourceOptions$.MODULE$.forRequest(request).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)options -> SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.registerSSE(response, (MailboxSession)mailboxSession, (EventSourceOptions)options))))).onErrorResume((Function1 & Serializable)throwable -> this.handleConnectionEstablishmentError((Throwable)throwable, response)).subscribeOn(Schedulers.elastic()).asJava().then();
    }

    private SMono<BoxedUnit> registerSSE(HttpServerResponse response, MailboxSession session, EventSourceOptions options) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux<PingMessage> qual$1 = options.pingPolicy().asFlux();
        Function1 & Serializable x$1 = (Function1 & Serializable)ping -> {
            EventSourceRoutes.$anonfun$registerSSE$1(context, ping);
            return BoxedUnit.UNIT;
        };
        Option x$2 = qual$1.subscribe$default$2();
        Option x$3 = qual$1.subscribe$default$3();
        Disposable pingDisposable = qual$1.subscribe((Function1)x$1, x$2, x$3);
        SMono$.MODULE$.apply(this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener(options.types(), context.outbound()), (RegistrationKey)AccountIdRegistrationKey$.MODULE$.of(session.getUser()))).doOnNext((Function1 & Serializable)newRegistration -> {
            context.withRegistration(newRegistration);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.elastic()).subscribe();
        return SMono$.MODULE$.apply((Publisher)response.addHeader((CharSequence)"Connection", (CharSequence)"keep-alive").sse().sendString((Publisher)options.closeAfter().applyOn((SFlux<OutboundMessage>)SFlux$.MODULE$.apply((Publisher)sink.asFlux())).map((Function1 & Serializable)outboundMessage -> this.asSSEEvent((OutboundMessage)outboundMessage)), StandardCharsets.UTF_8).then().doFinally(x$5 -> context.clean()).doFinally(x$6 -> pingDisposable.dispose()).then()).then();
    }

    private String asSSEEvent(OutboundMessage outboundMessage) {
        String string2;
        OutboundMessage outboundMessage2 = outboundMessage;
        if (outboundMessage2 instanceof PingMessage) {
            string2 = "ping";
        } else if (outboundMessage2 instanceof StateChange) {
            string2 = "state";
        } else {
            throw new MatchError((Object)outboundMessage2);
        }
        String event = string2;
        return new StringBuilder(16).append("event: ").append(event).append("\ndata: ").append(Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(outboundMessage))).append("\n\n").toString();
    }

    private SMono<Void> handleConnectionEstablishmentError(Throwable throwable, HttpServerResponse response) {
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse response, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)response.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    public static final /* synthetic */ void $anonfun$registerSSE$1(ClientContext context$1, PingMessage ping) {
        context$1.outbound().emitNext((Object)ping, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    @Inject
    public EventSourceRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
    }
}

