/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableMap;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.GroupRegistration;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.StructuredLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.Sender;

class GroupConsumerRetry {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupConsumerRetry.class);
    private final Sender sender;
    private final RetryExchangeName retryExchangeName;
    private final RetryBackoffConfiguration retryBackoff;
    private final EventDeadLetters eventDeadLetters;
    private final Group group;
    private final EventSerializer eventSerializer;

    GroupConsumerRetry(NamingStrategy namingStrategy, Sender sender, Group group, RetryBackoffConfiguration retryBackoff, EventDeadLetters eventDeadLetters, EventSerializer eventSerializer) {
        this.sender = sender;
        this.retryExchangeName = namingStrategy.retryExchange(group);
        this.retryBackoff = retryBackoff;
        this.eventDeadLetters = eventDeadLetters;
        this.group = group;
        this.eventSerializer = eventSerializer;
    }

    Mono<Void> createRetryExchange(GroupRegistration.WorkQueueName queueName) {
        return Flux.concat((Publisher[])new Publisher[]{this.sender.declareExchange(ExchangeSpecification.exchange((String)this.retryExchangeName.asString()).durable(true).type("direct")), this.sender.bind(BindingSpecification.binding().exchange(this.retryExchangeName.asString()).queue(queueName.asString()).routingKey(""))}).then();
    }

    Mono<Void> handleRetry(Event event, int currentRetryCount, Throwable throwable) {
        this.createStructuredLogger(event).log(logger -> logger.error("Exception happens when handling event after {} retries", (Object)currentRetryCount, (Object)throwable));
        return this.retryOrStoreToDeadLetter(event, currentRetryCount);
    }

    Mono<Void> retryOrStoreToDeadLetter(Event event, int currentRetryCount) {
        if (currentRetryCount >= this.retryBackoff.getMaxRetries()) {
            return this.eventDeadLetters.store(this.group, event).then();
        }
        return this.sendRetryMessage(event, currentRetryCount);
    }

    private Mono<Void> sendRetryMessage(Event event, int currentRetryCount) {
        byte[] eventAsBytes = this.eventSerializer.toJson(event).getBytes(StandardCharsets.UTF_8);
        Mono retryMessage = Mono.just((Object)new OutboundMessage(this.retryExchangeName.asString(), "", new AMQP.BasicProperties.Builder().headers((Map)ImmutableMap.of((Object)"retry-count", (Object)(currentRetryCount + 1))).deliveryMode(MessageProperties.PERSISTENT_TEXT_PLAIN.getDeliveryMode()).priority(MessageProperties.PERSISTENT_TEXT_PLAIN.getPriority()).contentType(MessageProperties.PERSISTENT_TEXT_PLAIN.getContentType()).build(), eventAsBytes));
        return this.sender.send((Publisher)retryMessage).doOnError(throwable -> this.createStructuredLogger(event).log(logger -> logger.error("Exception happens when publishing event to retry exchange, this event will be stored in deadLetter", throwable))).onErrorResume(e -> this.eventDeadLetters.store(this.group, event).then());
    }

    private StructuredLogger createStructuredLogger(Event event) {
        return MDCStructuredLogger.forLogger((Logger)LOGGER).addField("eventId", (Object)event.getEventId()).addField("eventClass", event.getClass()).addField("user", (Object)event.getUsername()).addField("group", (Object)this.group.asString());
    }

    static class RetryExchangeName {
        private final String prefix;
        private final Group group;

        RetryExchangeName(String prefix, Group group) {
            this.prefix = prefix;
            this.group = group;
        }

        String asString() {
            return this.prefix + "-retryExchange-" + this.group.asString();
        }
    }
}

