/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.lang3.StringUtils;

public class DelegatedPropertiesConfiguration
implements Configuration {
    private final String delimiter;
    private final Configuration configuration;

    DelegatedPropertiesConfiguration(String delimiter, Configuration configuration) {
        this.delimiter = delimiter;
        this.configuration = configuration;
    }

    public Configuration subset(String prefix) {
        return this.configuration.subset(prefix);
    }

    public void addProperty(String key, Object value) {
        this.configuration.addProperty(key, value);
    }

    public void setProperty(String key, Object value) {
        this.configuration.setProperty(key, value);
    }

    public void clearProperty(String key) {
        this.configuration.clearProperty(key);
    }

    public void clear() {
        this.configuration.clear();
    }

    public ConfigurationInterpolator getInterpolator() {
        return this.configuration.getInterpolator();
    }

    public void setInterpolator(ConfigurationInterpolator ci) {
        this.configuration.setInterpolator(ci);
    }

    public void installInterpolator(Map<String, ? extends Lookup> prefixLookups, Collection<? extends Lookup> defLookups) {
        this.configuration.installInterpolator(prefixLookups, defLookups);
    }

    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    public int size() {
        return this.configuration.size();
    }

    public boolean containsKey(String key) {
        return this.configuration.containsKey(key);
    }

    public Object getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    public Iterator<String> getKeys(String prefix) {
        return this.configuration.getKeys(prefix);
    }

    public Iterator<String> getKeys() {
        return this.configuration.getKeys();
    }

    public Properties getProperties(String key) {
        return this.configuration.getProperties(key);
    }

    public boolean getBoolean(String key) {
        return this.configuration.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    public byte getByte(String key) {
        return this.configuration.getByte(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.configuration.getByte(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.configuration.getByte(key, defaultValue);
    }

    public double getDouble(String key) {
        return this.configuration.getDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.configuration.getDouble(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.configuration.getDouble(key, defaultValue);
    }

    public float getFloat(String key) {
        return this.configuration.getFloat(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.configuration.getFloat(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.configuration.getFloat(key, defaultValue);
    }

    public int getInt(String key) {
        return this.configuration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.configuration.getInteger(key, defaultValue);
    }

    public long getLong(String key) {
        return this.configuration.getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.configuration.getLong(key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.configuration.getLong(key, defaultValue);
    }

    public short getShort(String key) {
        return this.configuration.getShort(key);
    }

    public short getShort(String key, short defaultValue) {
        return this.configuration.getShort(key, defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.configuration.getShort(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.configuration.getBigDecimal(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.configuration.getBigDecimal(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.configuration.getBigInteger(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.configuration.getBigInteger(key, defaultValue);
    }

    public String getString(String key) {
        return this.configuration.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public String getEncodedString(String key, ConfigurationDecoder decoder) {
        return this.configuration.getEncodedString(key, decoder);
    }

    public String getEncodedString(String key) {
        return this.configuration.getEncodedString(key);
    }

    public String[] getStringArray(String key) {
        return (String[])this.splitAndStripDoubleQuotes(this.configuration.getString(key)).toArray(String[]::new);
    }

    public List<Object> getList(String key) {
        try {
            String rawList = (String)this.configuration.get(String.class, key);
            return (List)this.splitAndStripDoubleQuotes(rawList).collect(Guavate.toImmutableList());
        }
        catch (ConversionException e) {
            return this.configuration.getList(key);
        }
        catch (NoSuchElementException e) {
            return ImmutableList.of();
        }
    }

    public List<Object> getList(String key, List<?> defaultValue) {
        return this.configuration.getList(key, defaultValue);
    }

    public <T> T get(Class<T> cls, String key) {
        return (T)this.configuration.get(cls, key);
    }

    public <T> T get(Class<T> cls, String key, T defaultValue) {
        return (T)this.configuration.get(cls, key, defaultValue);
    }

    public Object getArray(Class<?> cls, String key) {
        return this.configuration.getArray(cls, key);
    }

    @Deprecated
    public Object getArray(Class<?> cls, String key, Object defaultValue) {
        return this.configuration.getArray(cls, key, defaultValue);
    }

    public <T> List<T> getList(Class<T> cls, String key) {
        return this.configuration.getList(cls, key);
    }

    public <T> List<T> getList(Class<T> cls, String key, List<T> defaultValue) {
        return this.configuration.getList(cls, key, defaultValue);
    }

    public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target) {
        return this.configuration.getCollection(cls, key, target);
    }

    public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target, Collection<T> defaultValue) {
        return this.configuration.getCollection(cls, key, target, defaultValue);
    }

    public ImmutableConfiguration immutableSubset(String prefix) {
        return this.configuration.immutableSubset(prefix);
    }

    public Synchronizer getSynchronizer() {
        return this.configuration.getSynchronizer();
    }

    public void setSynchronizer(Synchronizer sync) {
        this.configuration.setSynchronizer(sync);
    }

    public void lock(LockMode mode) {
        this.configuration.lock(mode);
    }

    public void unlock(LockMode mode) {
        this.configuration.unlock(mode);
    }

    private Stream<String> splitAndStripDoubleQuotes(String value) {
        return Optional.ofNullable(value).map(notNullValue -> Stream.of(StringUtils.strip((String)notNullValue, (String)"\"").split(this.delimiter)).map(String::trim)).orElseGet(Stream::empty);
    }
}

