/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import java.time.Instant;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.james.queue.rabbitmq.view.cassandra.DeletedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraMailQueueMailDelete {
    private final DeletedMailsDAO deletedMailsDao;
    private final BrowseStartDAO browseStartDao;
    private final CassandraMailQueueBrowser cassandraMailQueueBrowser;
    private final CassandraMailQueueViewConfiguration configuration;

    @Inject
    CassandraMailQueueMailDelete(DeletedMailsDAO deletedMailsDao, BrowseStartDAO browseStartDao, CassandraMailQueueBrowser cassandraMailQueueBrowser, CassandraMailQueueViewConfiguration configuration) {
        this.deletedMailsDao = deletedMailsDao;
        this.browseStartDao = browseStartDao;
        this.cassandraMailQueueBrowser = cassandraMailQueueBrowser;
        this.configuration = configuration;
    }

    Mono<Void> considerDeleted(EnqueueId enqueueId, MailQueueName mailQueueName) {
        return this.deletedMailsDao.markAsDeleted(mailQueueName, enqueueId).doOnNext(ignored -> this.maybeUpdateBrowseStart(mailQueueName));
    }

    Mono<Boolean> isDeleted(EnqueueId enqueueId, MailQueueName mailQueueName) {
        return this.deletedMailsDao.isDeleted(mailQueueName, enqueueId);
    }

    void updateBrowseStart(MailQueueName mailQueueName) {
        this.findNewBrowseStart(mailQueueName).flatMap(newBrowseStart -> this.updateNewBrowseStart(mailQueueName, (Instant)newBrowseStart)).subscribeOn(Schedulers.elastic()).subscribe();
    }

    private void maybeUpdateBrowseStart(MailQueueName mailQueueName) {
        if (this.shouldUpdateBrowseStart()) {
            this.updateBrowseStart(mailQueueName);
        }
    }

    private Mono<Instant> findNewBrowseStart(MailQueueName mailQueueName) {
        return this.cassandraMailQueueBrowser.browseReferences(mailQueueName).map(enqueuedItem -> enqueuedItem.getSlicingContext().getTimeRangeStart()).next();
    }

    private Mono<Void> updateNewBrowseStart(MailQueueName mailQueueName, Instant newBrowseStartInstant) {
        return this.browseStartDao.updateBrowseStart(mailQueueName, newBrowseStartInstant);
    }

    private boolean shouldUpdateBrowseStart() {
        int threshold = this.configuration.getUpdateBrowseStartPace();
        return Math.abs(ThreadLocalRandom.current().nextInt()) % threshold == 0;
    }
}

