/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.github.steveash.guavate.Guavate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.mailet.filter.ActionApplier;
import org.apache.james.jmap.mailet.filter.RuleMatcher;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class JMAPFiltering
extends GenericMailet {
    private final Logger logger = LoggerFactory.getLogger(JMAPFiltering.class);
    private final FilteringManagement filteringManagement;
    private final UsersRepository usersRepository;
    private final ActionApplier.Factory actionApplierFactory;

    @Inject
    public JMAPFiltering(FilteringManagement filteringManagement, UsersRepository usersRepository, ActionApplier.Factory actionApplierFactory) {
        this.filteringManagement = filteringManagement;
        this.usersRepository = usersRepository;
        this.actionApplierFactory = actionApplierFactory;
    }

    public void service(Mail mail) {
        mail.getRecipients().forEach(recipient -> this.filteringForRecipient(mail, (MailAddress)recipient));
    }

    private void filteringForRecipient(Mail mail, MailAddress recipient) {
        Optional<Username> maybeUser = this.retrieveUser(recipient);
        maybeUser.ifPresent(user -> this.findFirstApplicableRule((Username)user, mail));
    }

    private void findFirstApplicableRule(Username username, Mail mail) {
        List filteringRules = (List)Flux.from((Publisher)this.filteringManagement.listRulesForUser(username)).collect(Guavate.toImmutableList()).block();
        RuleMatcher ruleMatcher = new RuleMatcher(filteringRules);
        Stream<Rule> matchingRules = ruleMatcher.findApplicableRules(mail);
        this.actionApplierFactory.forMail(mail).forUser(username).apply(matchingRules.map(Rule::getAction));
    }

    private Optional<Username> retrieveUser(MailAddress recipient) {
        try {
            return Optional.ofNullable(this.usersRepository.getUsername(recipient));
        }
        catch (UsersRepositoryException e) {
            this.logger.error("cannot retrieve user " + recipient.asString(), (Throwable)e);
            return Optional.empty();
        }
    }
}

