/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.message.view.MessageFastView;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageViewFactory;
import org.apache.james.mailbox.BlobManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageFastViewFactory
implements MessageViewFactory<MessageFastView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFastViewFactory.class);
    private final BlobManager blobManager;
    private final MessageIdManager messageIdManager;
    private final MessageFastViewProjection fastViewProjection;
    private final MessageFullViewFactory messageFullViewFactory;

    @Inject
    @VisibleForTesting
    public MessageFastViewFactory(BlobManager blobManager, MessageIdManager messageIdManager, MessageFastViewProjection fastViewProjection, MessageFullViewFactory messageFullViewFactory) {
        this.blobManager = blobManager;
        this.messageIdManager = messageIdManager;
        this.fastViewProjection = fastViewProjection;
        this.messageFullViewFactory = messageFullViewFactory;
    }

    @Override
    public Flux<MessageFastView> fromMessageIds(List<MessageId> messageIds, MailboxSession mailboxSession) {
        ImmutableSet messageIdSet = ImmutableSet.copyOf(messageIds);
        return Mono.from((Publisher)this.fastViewProjection.retrieve(messageIds)).flatMapMany(fastProjections -> this.gatherMessageViews((Set<MessageId>)messageIdSet, mailboxSession, (Map<MessageId, MessageFastViewPrecomputedProperties>)fastProjections));
    }

    private Flux<MessageFastView> gatherMessageViews(Set<MessageId> messageIds, MailboxSession mailboxSession, Map<MessageId, MessageFastViewPrecomputedProperties> fastProjections) {
        Set<MessageId> withProjectionEntry = fastProjections.keySet();
        Sets.SetView withoutProjectionEntry = Sets.difference(messageIds, withProjectionEntry);
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = MessageViewFactory.Helpers.toMessageViews(this.fetch(withProjectionEntry, FetchGroup.HEADERS, mailboxSession), new FromMessageResultAndPreview(this.blobManager, fastProjections));
        publisherArray[1] = MessageViewFactory.Helpers.toMessageViews(this.fetch((Collection<MessageId>)withoutProjectionEntry, FetchGroup.FULL_CONTENT, mailboxSession), this.messageFullViewFactory::fromMessageResults);
        return Flux.merge((Publisher[])publisherArray);
    }

    private Flux<MessageResult> fetch(Collection<MessageId> messageIds, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        if (messageIds.isEmpty()) {
            return Flux.empty();
        }
        return Flux.from((Publisher)this.messageIdManager.getMessagesReactive(messageIds, fetchGroup, mailboxSession)).onErrorResume(MailboxException.class, ex -> {
            LOGGER.error("cannot read messages {}", (Object)messageIds, (Object)ex);
            return Flux.empty();
        });
    }

    private static class FromMessageResultAndPreview
    implements MessageViewFactory.Helpers.FromMessageResult<MessageFastView> {
        private final BlobManager blobManager;
        private final Map<MessageId, MessageFastViewPrecomputedProperties> fastProjections;

        private FromMessageResultAndPreview(BlobManager blobManager, Map<MessageId, MessageFastViewPrecomputedProperties> fastProjections) {
            this.blobManager = blobManager;
            this.fastProjections = fastProjections;
        }

        @Override
        public Mono<MessageFastView> fromMessageResults(Collection<MessageResult> messageResults) {
            MessageViewFactory.Helpers.assertOneMessageId(messageResults);
            MessageResult firstMessageResult = messageResults.iterator().next();
            Preconditions.checkArgument((boolean)this.fastProjections.containsKey(firstMessageResult.getMessageId()), (Object)"FromMessageResultAndPreview usage requires a precomputed preview");
            return Mono.fromCallable(() -> {
                MessageFastViewPrecomputedProperties messageProjection = this.fastProjections.get(firstMessageResult.getMessageId());
                List<MailboxId> mailboxIds = MessageViewFactory.Helpers.getMailboxIds(messageResults);
                Message mimeMessage = MessageViewFactory.Helpers.parse(firstMessageResult.getFullContent().getInputStream());
                return this.instanciateFastView(messageResults, firstMessageResult, messageProjection, mailboxIds, mimeMessage);
            });
        }

        private MessageFastView instanciateFastView(Collection<MessageResult> messageResults, MessageResult firstMessageResult, MessageFastViewPrecomputedProperties messageProjection, List<MailboxId> mailboxIds, Message mimeMessage) {
            return ((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)((MessageFastView.Builder)MessageFastView.builder().id(firstMessageResult.getMessageId())).mailboxIds(mailboxIds)).blobId(BlobId.of(this.blobManager.toBlobId(firstMessageResult.getMessageId())))).threadId(firstMessageResult.getMessageId().serialize())).keywords(MessageViewFactory.Helpers.getKeywords(messageResults))).size(firstMessageResult.getSize())).inReplyToMessageId(MessageViewFactory.Helpers.getHeaderValue(mimeMessage, "in-reply-to"))).subject(Strings.nullToEmpty((String)mimeMessage.getSubject()).trim())).headers(MessageViewFactory.Helpers.toHeaderMap(mimeMessage.getHeader().getFields()))).from(Emailer.firstFromMailboxList(mimeMessage.getFrom()))).to(Emailer.fromAddressList(mimeMessage.getTo()))).cc(Emailer.fromAddressList(mimeMessage.getCc()))).bcc(Emailer.fromAddressList(mimeMessage.getBcc()))).replyTo(Emailer.fromAddressList(mimeMessage.getReplyTo()))).date(MessageViewFactory.Helpers.getDateFromHeaderOrInternalDateOtherwise(mimeMessage, firstMessageResult))).preview(messageProjection.getPreview())).hasAttachment(messageProjection.hasAttachment())).build();
        }
    }
}

