/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.MessagingException;
import org.apache.james.jmap.draft.exceptions.InvalidOriginMessageForMDNException;
import org.apache.james.jmap.draft.exceptions.MessageNotFoundException;
import org.apache.james.jmap.draft.methods.MessageAppender;
import org.apache.james.jmap.draft.methods.MessageSender;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.JmapMDN;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.field.ParseException;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.server.core.Envelope;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class SendMDNProcessor
implements SetMessagesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMDNProcessor.class);
    private final MetricFactory metricFactory;
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MessageIdManager messageIdManager;
    private final MessageAppender messageAppender;
    private final MessageSender messageSender;

    @Inject
    public SendMDNProcessor(MetricFactory metricFactory, SystemMailboxesProvider systemMailboxesProvider, MessageIdManager messageIdManager, MessageAppender messageAppender, MessageSender messageSender) {
        this.metricFactory = metricFactory;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.messageIdManager = messageIdManager;
        this.messageAppender = messageAppender;
        this.messageSender = messageSender;
    }

    @Override
    public SetMessagesResponse process(SetMessagesRequest request, MailboxSession mailboxSession) {
        return (SetMessagesResponse)this.metricFactory.decorateSupplierWithTimerMetricLogP99("JMAP-SendMDN", () -> this.handleMDNCreation(request, mailboxSession));
    }

    private SetMessagesResponse handleMDNCreation(SetMessagesRequest request, MailboxSession mailboxSession) {
        return request.getSendMDN().stream().map(MDNCreationEntry2 -> this.handleMDNCreation((ValueWithId.MDNCreationEntry)MDNCreationEntry2, mailboxSession)).reduce(SetMessagesResponse.builder(), SetMessagesResponse.Builder::mergeWith).build();
    }

    private SetMessagesResponse.Builder handleMDNCreation(ValueWithId.MDNCreationEntry MDNCreationEntry2, MailboxSession mailboxSession) {
        try {
            MessageId messageId = this.sendMdn(MDNCreationEntry2, mailboxSession);
            return SetMessagesResponse.builder().mdnSent(MDNCreationEntry2.getCreationId(), messageId);
        }
        catch (InvalidOriginMessageForMDNException e) {
            return SetMessagesResponse.builder().mdnNotSent(MDNCreationEntry2.getCreationId(), SetError.builder().description(String.format("Origin messageId '%s' is invalid. A Message Delivery Notification can not be generated for it. Explanation: " + e.getExplanation(), ((JmapMDN)MDNCreationEntry2.getValue()).getMessageId().serialize())).type(SetError.Type.INVALID_ARGUMENTS).build());
        }
        catch (MessageNotFoundException e) {
            return SetMessagesResponse.builder().mdnNotSent(MDNCreationEntry2.getCreationId(), SetError.builder().description(String.format("Message with id %s not found. Thus could not send MDN.", ((JmapMDN)MDNCreationEntry2.getValue()).getMessageId().serialize())).type(SetError.Type.INVALID_ARGUMENTS).build());
        }
        catch (OverQuotaException e) {
            return SetMessagesResponse.builder().mdnNotSent(MDNCreationEntry2.getCreationId(), SetError.builder().description(e.getMessage()).type(SetError.Type.MAX_QUOTA_REACHED).build());
        }
        catch (Exception e) {
            LOGGER.error("Error while sending MDN", (Throwable)e);
            return SetMessagesResponse.builder().mdnNotSent(MDNCreationEntry2.getCreationId(), SetError.builder().description(String.format("Could not send MDN %s", MDNCreationEntry2.getCreationId().getId())).type(SetError.Type.ERROR).build());
        }
    }

    private MessageId sendMdn(ValueWithId.MDNCreationEntry MDNCreationEntry2, MailboxSession mailboxSession) throws MailboxException, IOException, MessagingException, ParseException, MessageNotFoundException, InvalidOriginMessageForMDNException {
        JmapMDN mdn = (JmapMDN)MDNCreationEntry2.getValue();
        Message originalMessage = this.retrieveOriginalMessage(mdn, mailboxSession);
        Message mdnAnswer = mdn.generateMDNMessage(originalMessage, mailboxSession);
        Flags seen = new Flags(Flags.Flag.SEEN);
        MessageFullViewFactory.MetaDataWithContent metaDataWithContent = this.messageAppender.appendMessageInMailbox(mdnAnswer, this.getOutbox(mailboxSession), seen, mailboxSession);
        this.messageSender.sendMessage(metaDataWithContent, Envelope.fromMime4JMessage((Message)mdnAnswer), mailboxSession);
        return metaDataWithContent.getMessageId();
    }

    private Message retrieveOriginalMessage(JmapMDN mdn, MailboxSession mailboxSession) throws MailboxException, IOException, MessageNotFoundException {
        List messages = this.messageIdManager.getMessage(mdn.getMessageId(), FetchGroup.HEADERS, mailboxSession);
        if (messages.size() == 0) {
            throw new MessageNotFoundException();
        }
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        return messageBuilder.parseMessage(((MessageResult)messages.get(0)).getHeaders().getInputStream());
    }

    private MessageManager getOutbox(MailboxSession mailboxSession) throws MailboxException {
        return (MessageManager)Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(Role.OUTBOX, mailboxSession.getUser())).toStream().findAny().orElseThrow(() -> new IllegalStateException("User don't have an Outbox"));
    }
}

