/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.google.common.collect.ImmutableMap;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.task.eventsourcing.distributed.TerminationQueueName;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class TerminationReconnectionHandler
implements SimpleConnectionPool.ReconnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminationReconnectionHandler.class);
    private final TerminationQueueName queueName;

    @Inject
    public TerminationReconnectionHandler(TerminationQueueName queueName) {
        this.queueName = queueName;
    }

    public Publisher<Void> handleReconnection(Connection connection) {
        return Mono.fromRunnable(() -> {
            try (Channel channel = connection.createChannel();){
                channel.queueDeclare(this.queueName.asString(), false, false, true, (Map)ImmutableMap.of());
            }
            catch (Exception e) {
                LOGGER.error("Error recovering connection", (Throwable)e);
            }
        });
    }
}

