/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;

public enum ZipEntryType {
    MAILBOX,
    MAILBOX_ANNOTATION_DIR,
    MAILBOX_ANNOTATION,
    MESSAGE;

    private static final Map<Integer, ZipEntryType> entryByOrdinal;

    public static Optional<ZipEntryType> zipEntryType(int ordinal) {
        return Optional.ofNullable(entryByOrdinal.get(ordinal));
    }

    static {
        Stream<ZipEntryType> valuesAsStream = Arrays.stream(ZipEntryType.values());
        Stream<Integer> indices = IntStream.range(0, ZipEntryType.values().length).boxed();
        entryByOrdinal = (Map)Streams.zip(indices, valuesAsStream, ImmutablePair::of).collect(Guavate.entriesToImmutableMap());
    }
}

