/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.impl.DefineRulesCommand;
import org.apache.james.jmap.api.filtering.impl.DefineRulesCommandHandler;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregate;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class EventSourcingFilteringManagement
implements FilteringManagement {
    private static final ImmutableSet<Subscriber> NO_SUBSCRIBER = ImmutableSet.of();
    private final EventStore eventStore;
    private final EventSourcingSystem eventSourcingSystem;

    @Inject
    public EventSourcingFilteringManagement(EventStore eventStore) {
        this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)ImmutableSet.of((Object)new DefineRulesCommandHandler(eventStore)), NO_SUBSCRIBER, (EventStore)eventStore);
        this.eventStore = eventStore;
    }

    @Override
    public Publisher<Void> defineRulesForUser(Username username, List<Rule> rules) {
        return Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new DefineRulesCommand(username, rules))).then();
    }

    @Override
    public Publisher<Rule> listRulesForUser(Username username) {
        Preconditions.checkNotNull((Object)username);
        FilteringAggregateId aggregateId = new FilteringAggregateId(username);
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).flatMapIterable(history -> FilteringAggregate.load(aggregateId, history).listRules());
    }
}

