/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init.configuration;

import com.datastax.driver.core.PerHostPercentileTracker;
import com.datastax.driver.core.PercentileTracker;
import com.datastax.driver.core.QueryLogger;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.Configuration;

public class QueryLoggerConfiguration {
    private static final long CASSANDRA_HIGHEST_TRACKABLE_LATENCY_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    public static final QueryLoggerConfiguration DEFAULT = QueryLoggerConfiguration.builder().withDynamicThreshold(PerHostPercentileTracker.builder((long)CASSANDRA_HIGHEST_TRACKABLE_LATENCY_MILLIS).build(), 99.0).build();
    private final Optional<Long> constantThreshold;
    private final Optional<PerHostPercentileTracker> percentileTracker;
    private final Optional<Double> slowQueryLatencyThresholdPercentile;
    private final Optional<Integer> maxLoggedParameters;
    private final Optional<Integer> maxParameterValueLength;
    private final Optional<Integer> maxQueryStringLength;

    public static Builder builder() {
        return new Builder();
    }

    public static QueryLoggerConfiguration from(Configuration configuration) {
        Builder builder = QueryLoggerConfiguration.builder();
        Optional<Long> constantThreshold = QueryLoggerConfiguration.getOptionalIntegerFromConf(configuration, "cassandra.query.logger.constant.threshold").map(Long::valueOf);
        constantThreshold.ifPresent(builder::withConstantThreshold);
        QueryLoggerConfiguration.getOptionalIntegerFromConf(configuration, "cassandra.query.logger.max.logged.parameters").ifPresent(builder::withMaxLoggedParameters);
        QueryLoggerConfiguration.getOptionalIntegerFromConf(configuration, "cassandra.query.logger.max.query.string.length").ifPresent(builder::withMaxQueryStringLength);
        QueryLoggerConfiguration.getOptionalIntegerFromConf(configuration, "cassandra.query.logger.max.parameter.value.length").ifPresent(builder::withMaxParameterValueLength);
        Optional<Double> percentileLatencyConf = QueryLoggerConfiguration.getOptionalDoubleFromConf(configuration, "cassandra.query.slow.query.latency.threshold.percentile");
        if (!percentileLatencyConf.isPresent() && !constantThreshold.isPresent()) {
            percentileLatencyConf = Optional.of(99.0);
        }
        percentileLatencyConf.ifPresent(slowQueryLatencyThresholdPercentile -> {
            PerHostPercentileTracker tracker = PerHostPercentileTracker.builder((long)CASSANDRA_HIGHEST_TRACKABLE_LATENCY_MILLIS).build();
            builder.withDynamicThreshold(tracker, (double)slowQueryLatencyThresholdPercentile);
        });
        return builder.build();
    }

    private static Optional<Integer> getOptionalIntegerFromConf(Configuration configuration, String key) {
        return Optional.ofNullable(configuration.getInteger(key, null));
    }

    private static Optional<Double> getOptionalDoubleFromConf(Configuration configuration, String key) {
        return Optional.ofNullable(configuration.getDouble(key, null));
    }

    private QueryLoggerConfiguration(Optional<Long> constantThreshold, Optional<PerHostPercentileTracker> percentileTracker, Optional<Double> slowQueryLatencyThresholdPercentile, Optional<Integer> maxLoggedParameters, Optional<Integer> maxParameterValueLength, Optional<Integer> maxQueryStringLength) {
        this.constantThreshold = constantThreshold;
        this.percentileTracker = percentileTracker;
        this.slowQueryLatencyThresholdPercentile = slowQueryLatencyThresholdPercentile;
        this.maxLoggedParameters = maxLoggedParameters;
        this.maxParameterValueLength = maxParameterValueLength;
        this.maxQueryStringLength = maxQueryStringLength;
    }

    public QueryLogger getQueryLogger() {
        QueryLogger.Builder builder = QueryLogger.builder();
        this.percentileTracker.map(percentileTracker -> this.slowQueryLatencyThresholdPercentile.map(slowQueryLatencyThresholdPercentile -> builder.withDynamicThreshold((PercentileTracker)percentileTracker, slowQueryLatencyThresholdPercentile.doubleValue())));
        this.constantThreshold.ifPresent(arg_0 -> ((QueryLogger.Builder)builder).withConstantThreshold(arg_0));
        this.constantThreshold.ifPresent(arg_0 -> ((QueryLogger.Builder)builder).withConstantThreshold(arg_0));
        this.maxLoggedParameters.ifPresent(arg_0 -> ((QueryLogger.Builder)builder).withMaxLoggedParameters(arg_0));
        this.maxParameterValueLength.ifPresent(arg_0 -> ((QueryLogger.Builder)builder).withMaxParameterValueLength(arg_0));
        this.maxQueryStringLength.ifPresent(arg_0 -> ((QueryLogger.Builder)builder).withMaxQueryStringLength(arg_0));
        return builder.build();
    }

    public static class Builder {
        private Optional<Long> constantThreshold = Optional.empty();
        private Optional<PerHostPercentileTracker> percentileTracker = Optional.empty();
        private Optional<Double> slowQueryLatencyThresholdPercentile = Optional.empty();
        private Optional<Integer> maxLoggedParameters = Optional.empty();
        private Optional<Integer> maxParameterValueLength = Optional.empty();
        private Optional<Integer> maxQueryStringLength = Optional.empty();

        private Builder() {
        }

        public Builder withConstantThreshold(long constantThreshold) {
            this.constantThreshold = Optional.of(constantThreshold);
            return this;
        }

        public Builder withDynamicThreshold(PerHostPercentileTracker percentileTracker, double slowQueryLatencyThresholdPercentile) {
            this.percentileTracker = Optional.of(percentileTracker);
            this.slowQueryLatencyThresholdPercentile = Optional.of(slowQueryLatencyThresholdPercentile);
            return this;
        }

        public Builder withMaxLoggedParameters(int maxLoggedParameters) {
            this.maxLoggedParameters = Optional.of(maxLoggedParameters);
            return this;
        }

        public Builder withMaxParameterValueLength(int maxParameterValueLength) {
            this.maxParameterValueLength = Optional.of(maxParameterValueLength);
            return this;
        }

        public Builder withMaxQueryStringLength(int maxQueryStringLength) {
            this.maxQueryStringLength = Optional.of(maxQueryStringLength);
            return this;
        }

        public QueryLoggerConfiguration build() {
            Preconditions.checkState((!this.constantThreshold.isPresent() || !this.percentileTracker.isPresent() ? 1 : 0) != 0, (Object)"You can not use slowQueryLatencyTheresholdMillis and percentileTracker at the same time");
            return new QueryLoggerConfiguration(this.constantThreshold, this.percentileTracker, this.slowQueryLatencyThresholdPercentile, this.maxLoggedParameters, this.maxParameterValueLength, this.maxQueryStringLength);
        }
    }
}

