/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.Session;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.SessionRoutes$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Uw!\u0002\r\u001a\u0011\u0003!c!\u0002\u0014\u001a\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%I!\r\u0005\u0007{\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fy\n!\u0019!C\u0005c!1q(\u0001Q\u0001\nIBq\u0001Q\u0001C\u0002\u0013%\u0011\t\u0003\u0004I\u0003\u0001\u0006IA\u0011\u0004\u0005Me\u0001\u0011\n\u0003\u0005W\u0013\t\u0015\r\u0011\"\u0001X\u0011!q\u0016B!A!\u0002\u0013A\u0006\u0002C0\n\u0005\u000b\u0007I\u0011\u00011\t\u0011\u0011L!\u0011!Q\u0001\n\u0005DQAL\u0005\u0005\u0002\u0015Dq!_\u0005C\u0002\u0013%!\u0010C\u0004\u0002\u0006%\u0001\u000b\u0011B>\t\u0011\u0005\u001d\u0011B1A\u0005\niDq!!\u0003\nA\u0003%1\u0010\u0003\u0004\u001b\u0013\u0011\u0005\u00131\u0002\u0005\b\u0003GIA\u0011BA\u0013\u0011\u001d\t9'\u0003C\u0001\u0003SBq!a$\n\t\u0013\t\t\nC\u0005\u0002>&\t\n\u0011\"\u0003\u0002@\u0006i1+Z:tS>t'k\\;uKNT!AG\u000e\u0002\rI|W\u000f^3t\u0015\taR$\u0001\u0003k[\u0006\u0004(B\u0001\u0010 \u0003\u0015Q\u0017-\\3t\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001A\u0011Q%A\u0007\u00023\ti1+Z:tS>t'k\\;uKN\u001c\"!\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA%\u0001\u0007K\u001b\u0006\u0003vlU#T'&{e*F\u00013!\t\u0019$H\u0004\u00025qA\u0011QGK\u0007\u0002m)\u0011qgI\u0001\u0007yI|w\u000e\u001e \n\u0005eR\u0013A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u0016\u0002\u001b)k\u0015\tU0T\u000bN\u001b\u0016j\u0014(!\u0003=9V\t\u0014'`\u0017:{uKT0K\u001b\u0006\u0003\u0016\u0001E,F\u00192{6JT(X\u001d~SU*\u0011)!\u0003\u0019aujR$F%V\t!\t\u0005\u0002D\r6\tAI\u0003\u0002FC\u0005)1\u000f\u001c45U&\u0011q\t\u0012\u0002\u0007\u0019><w-\u001a:\u0002\u000f1{uiR#SAM\u0019\u0011B\u0013*\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015\u0001\u00027b]\u001eT\u0011aT\u0001\u0005U\u00064\u0018-\u0003\u0002R\u0019\n1qJ\u00196fGR\u0004\"a\u0015+\u000e\u0003mI!!V\u000e\u0003\u0015)k\u0015\t\u0015*pkR,7/A\u0007bkRDWM\u001c;jG\u0006$xN]\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111lG\u0001\u0005QR$\b/\u0003\u0002^5\ni\u0011)\u001e;iK:$\u0018nY1u_J\fa\"Y;uQ\u0016tG/[2bi>\u0014\b%A\btKN\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005\t\u0007CA\u0013c\u0013\t\u0019\u0017DA\bTKN\u001c\u0018n\u001c8TkB\u0004H.[3s\u0003A\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005F\u0002gOR\u0004\"!J\u0005\t\u000bYs\u0001\u0019\u0001-)\t\u001dL\u0017O\u001d\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\fa!\u001b8kK\u000e$(\"\u00018\u0002\u000b)\fg/\u0019=\n\u0005A\\'!\u0002(b[\u0016$\u0017!\u0002<bYV,\u0017%A:\u0002\u0011I35)\f\u001d7eEBQa\u0018\bA\u0002\u0005D#A\u0004<\u0011\u0005)<\u0018B\u0001=l\u0005\u0019IeN[3di\u0006yq-\u001a8fe\u0006$XmU3tg&|g.F\u0001|!\taxP\u0004\u0002T{&\u0011apG\u0001\n\u00156\u000b\u0005KU8vi\u0016LA!!\u0001\u0002\u0004\t1\u0011i\u0019;j_:T!A`\u000e\u0002!\u001d,g.\u001a:bi\u0016\u001cVm]:j_:\u0004\u0013!\u0005:fI&\u0014Xm\u0019;U_N+7o]5p]\u0006\u0011\"/\u001a3je\u0016\u001cG\u000fV8TKN\u001c\u0018n\u001c8!)\t\ti\u0001\u0005\u0004\u0002\u0010\u0005e\u0011QD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u000511\u000f\u001e:fC6T1!a\u0006O\u0003\u0011)H/\u001b7\n\t\u0005m\u0011\u0011\u0003\u0002\u0007'R\u0014X-Y7\u0011\u0007M\u000by\"C\u0002\u0002\"m\u0011\u0011BS'B!J{W\u000f^3\u0002\u0017M,g\u000e\u001a*fgB|g\u000e\u001a\u000b\u0007\u0003O\t\u0019%!\u0015\u0011\r\u0005%\u0012\u0011HA\u001f\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!\u00039vE2L7\u000f[3s\u0015\rY\u0013\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003d_J,'BAA\u001c\u0003\u001d\u0011X-Y2u_JLA!a\u000f\u0002,\t)1+T8o_B\u00191*a\u0010\n\u0007\u0005\u0005CJ\u0001\u0003W_&$\u0007bBA#)\u0001\u0007\u0011qI\u0001\bg\u0016\u001c8/[8o!\u0011\tI%!\u0014\u000e\u0005\u0005-#bAA\u001a7%!\u0011qJA&\u0005\u001d\u0019Vm]:j_:Dq!a\u0015\u0015\u0001\u0004\t)&\u0001\u0003sKN\u0004\b\u0003BA,\u0003Gj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007m\u000byF\u0003\u0003\u0002b\u0005U\u0012!\u00028fiRL\u0018\u0002BA3\u00033\u0012!\u0003\u0013;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\u0006iQM\u001d:pe\"\u000bg\u000e\u001a7j]\u001e$b!a\u001b\u0002v\u0005-\u0005CBA7\u0003c\ni$\u0004\u0002\u0002p)!\u0011QFA\u0019\u0013\u0011\t\u0019(a\u001c\u0003\t5{gn\u001c\u0005\b\u0003o*\u0002\u0019AA=\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0002|\u0005\u0015e\u0002BA?\u0003\u0003s1!NA@\u0013\u0005Y\u0013bAABU\u00059\u0001/Y2lC\u001e,\u0017\u0002BAD\u0003\u0013\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\r%\u0006C\u0004\u0002\u000eV\u0001\r!!\u0016\u0002\u0011I,7\u000f]8og\u0016\faB]3ta>tG\rR3uC&d7\u000f\u0006\u0005\u0002l\u0005M\u0015qSAQ\u0011\u001d\t)J\u0006a\u0001\u0003+\n!\u0003\u001b;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011\u0014\fA\u0002\u0005m\u0015a\u00023fi\u0006LGn\u001d\t\u0005\u0003\u0013\ni*\u0003\u0003\u0002 \u0006-#A\u0004)s_\ndW-\u001c#fi\u0006LGn\u001d\u0005\n\u0003G3\u0002\u0013!a\u0001\u0003K\u000b!b\u001d;biV\u001c8i\u001c3f!\u0011\t9+!/\u000e\u0005\u0005%&bA.\u0002,*!\u0011QVAX\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\t\t,a-\u0002\u000f!\fg\u000e\u001a7fe*!\u0011\u0011MA[\u0015\t\t9,\u0001\u0002j_&!\u00111XAU\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\u00021I,7\u000f]8oI\u0012+G/Y5mg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002B*\"\u0011QUAbW\t\t)\r\u0005\u0003\u0002H\u0006EWBAAe\u0015\u0011\tY-!4\u0002\u0013Ut7\r[3dW\u0016$'bAAhU\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0017\u0011\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SessionRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final SessionSupplier sessionSupplier;
    private final JMAPRoute.Action generateSession;
    private final JMAPRoute.Action redirectToSession;

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    private JMAPRoute.Action generateSession() {
        return this.generateSession;
    }

    private JMAPRoute.Action redirectToSession() {
        return this.redirectToSession;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(this.generateSession()).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(this.redirectToSession()).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private SMono<Void> sendRespond(Session session, HttpServerResponse resp) {
        return SMono$.MODULE$.fromPublisher((Publisher)resp.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").status(HttpResponseStatus.OK).sendString((Publisher)SMono$.MODULE$.fromCallable(() -> Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(session)))).then());
    }

    public Mono<Void> errorHandling(Throwable throwable, HttpServerResponse response) {
        Mono<Void> mono;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
            HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
            String x$2 = unauthorizedException.getMessage();
            String x$3 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
            mono = this.respondDetails(response, new ProblemDetails(x$3, x$1, x$4, x$2), HttpResponseStatus.UNAUTHORIZED);
        } else {
            SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().error("Unexpected error upon requesting session", throwable2);
            HttpResponseStatus x$5 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$6 = throwable2.getMessage();
            String x$7 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
            mono = this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, x$6), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return mono;
    }

    private Mono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return httpServerResponse.status(statusCode).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then();
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    public static final /* synthetic */ void $anonfun$generateSession$3(SessionRoutes $this, Username x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Username username = (Username)tuple2._1();
        SynchronousSink sink = (SynchronousSink)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)$this.sessionSupplier().generate(username).fold((Function1 & Serializable)x$1 -> {
            sink.error(x$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)session -> {
            sink.next((Object)session);
            return BoxedUnit.UNIT;
        });
    }

    @Inject
    public SessionRoutes(@Named(value="RFC-8621") Authenticator authenticator, SessionSupplier sessionSupplier) {
        this.authenticator = authenticator;
        this.sessionSupplier = sessionSupplier;
        this.generateSession = (request, response) -> SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).map((Function1 & Serializable)x$1 -> x$1.getUser()).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            SessionRoutes.$anonfun$generateSession$3(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)session -> this.sendRespond((Session)session, response)).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.fromPublisher(this.errorHandling((Throwable)throwable, response))).subscribeOn(Schedulers.elastic()).asJava();
        this.redirectToSession = JMAPRoutes.redirectTo((String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION());
    }
}

