/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPatchException;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.IsSubscribedUpdate;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxPatchObject;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.MailboxSetResponse$;
import org.apache.james.jmap.mail.MailboxUpdateResponse;
import org.apache.james.jmap.mail.NameUpdate;
import org.apache.james.jmap.mail.ParentIdUpdate;
import org.apache.james.jmap.mail.ServerSetPropertyException;
import org.apache.james.jmap.mail.UnsupportedPropertyUpdatedException;
import org.apache.james.jmap.mail.ValidatedMailboxPatchObject;
import org.apache.james.jmap.method.LoopInMailboxGraphException;
import org.apache.james.jmap.method.MailboxSetUpdatePerformer$MailboxUpdateResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011=r!B0a\u0011\u0003Yg!B7a\u0011\u0003q\u0007\"B;\u0002\t\u00031haB<\u0002!\u0003\r\n\u0003\u001f\u0004\u0007\u00057\t\u0001I!\b\t\u0015\u0005mAA!f\u0001\n\u0003\u0011y\u0002\u0003\u0006\u0002F\u0011\u0011\t\u0012)A\u0005\u0005CAa!\u001e\u0003\u0005\u0002\tE\u0002\"CAI\t\u0005\u0005I\u0011\u0001B\u001c\u0011%\tY\nBI\u0001\n\u0003\u0011Y\u0004C\u0005\u0002@\u0012\t\t\u0011\"\u0011\u0002B\"I\u00111\u001b\u0003\u0002\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u0003;$\u0011\u0011!C\u0001\u0005\u007fA\u0011\"a;\u0005\u0003\u0003%\t%!<\t\u0013\u0005mH!!A\u0005\u0002\t\r\u0003\"\u0003B\u0004\t\u0005\u0005I\u0011\tB$\u0011%\u0011i\u0001BA\u0001\n\u0003\u0012y\u0001C\u0005\u0003\u0012\u0011\t\t\u0011\"\u0011\u0003\u0014!I!Q\u0003\u0003\u0002\u0002\u0013\u0005#1J\u0004\n\u0005\u001f\n\u0011\u0011!E\u0001\u0005#2\u0011Ba\u0007\u0002\u0003\u0003E\tAa\u0015\t\rU$B\u0011\u0001B6\u0011%\u0011\t\u0002FA\u0001\n\u000b\u0012\u0019\u0002C\u0005\u0003nQ\t\t\u0011\"!\u0003p!I!1\u000f\u000b\u0002\u0002\u0013\u0005%Q\u000f\u0005\n\u0005{\"\u0012\u0011!C\u0005\u0005\u007f2AA_\u0001Aw\"Q\u00111\u0004\u000e\u0003\u0016\u0004%\t!!\b\t\u0015\u0005\u0015#D!E!\u0002\u0013\ty\u0002\u0003\u0006\u0002Hi\u0011)\u001a!C\u0001\u0003\u0013B!\"!\u0015\u001b\u0005#\u0005\u000b\u0011BA&\u0011)\t\u0019F\u0007BK\u0002\u0013\u0005\u0011Q\u000b\u0005\u000b\u0003KR\"\u0011#Q\u0001\n\u0005]\u0003BB;\u001b\t\u0003\t9\u0007C\u0004\u0002ri!\t!a\u001d\t\u000f\u0005\u001d%\u0004\"\u0001\u0002\n\"I\u0011\u0011\u0013\u000e\u0002\u0002\u0013\u0005\u00111\u0013\u0005\n\u00037S\u0012\u0013!C\u0001\u0003;C\u0011\"a-\u001b#\u0003%\t!!.\t\u0013\u0005e&$%A\u0005\u0002\u0005m\u0006\"CA`5\u0005\u0005I\u0011IAa\u0011%\t\u0019NGA\u0001\n\u0003\t)\u000eC\u0005\u0002^j\t\t\u0011\"\u0001\u0002`\"I\u00111\u001e\u000e\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003wT\u0012\u0011!C\u0001\u0003{D\u0011Ba\u0002\u001b\u0003\u0003%\tE!\u0003\t\u0013\t5!$!A\u0005B\t=\u0001\"\u0003B\t5\u0005\u0005I\u0011\tB\n\u0011%\u0011)BGA\u0001\n\u0003\u00129bB\u0005\u0003\b\u0006\t\t\u0011#\u0001\u0003\n\u001aA!0AA\u0001\u0012\u0003\u0011Y\t\u0003\u0004ve\u0011\u0005!1\u0013\u0005\n\u0005#\u0011\u0014\u0011!C#\u0005'A\u0011B!\u001c3\u0003\u0003%\tI!&\t\u0013\tM$'!A\u0005\u0002\nu\u0005\"\u0003B?e\u0005\u0005I\u0011\u0002B@\r\u0019\u0011I+\u0001!\u0003,\"Q!Q\u0016\u001d\u0003\u0016\u0004%\tAa,\t\u0015\t]\u0006H!E!\u0002\u0013\u0011\t\f\u0003\u0004vq\u0011\u0005!\u0011\u0018\u0005\b\u0005\u007fCD\u0011\u0001Ba\u0011\u001d\u0011I\u000e\u000fC\u0001\u00057D\u0011\"!%9\u0003\u0003%\tAa8\t\u0013\u0005m\u0005(%A\u0005\u0002\t\r\b\"CA`q\u0005\u0005I\u0011IAa\u0011%\t\u0019\u000eOA\u0001\n\u0003\t)\u000eC\u0005\u0002^b\n\t\u0011\"\u0001\u0003h\"I\u00111\u001e\u001d\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003wD\u0014\u0011!C\u0001\u0005WD\u0011Ba\u00029\u0003\u0003%\tEa<\t\u0013\t5\u0001(!A\u0005B\t=\u0001\"\u0003B\tq\u0005\u0005I\u0011\tB\n\u0011%\u0011)\u0002OA\u0001\n\u0003\u0012\u0019pB\u0005\u0003x\u0006\t\t\u0011#\u0001\u0003z\u001aI!\u0011V\u0001\u0002\u0002#\u0005!1 \u0005\u0007k*#\tAa@\t\u0013\tE!*!A\u0005F\tM\u0001\"\u0003B7\u0015\u0006\u0005I\u0011QB\u0001\u0011%\u0011\u0019HSA\u0001\n\u0003\u001b)\u0001C\u0005\u0003~)\u000b\t\u0011\"\u0003\u0003\u0000\u0019)Q\u000e\u0019\u0001\u0004\f!Q1Q\u0002)\u0003\u0002\u0003\u0006Iaa\u0004\t\u0015\rm\u0001K!A!\u0002\u0013\u0019i\u0002\u0003\u0006\u0004&A\u0013\t\u0011)A\u0005\u0007OA!b!\fQ\u0005\u0003\u0005\u000b\u0011BB\u0018\u0011\u0019)\b\u000b\"\u0001\u0004>!911\f)\u0005\u0002\ru\u0003bBBV!\u0012%1Q\u0016\u0005\b\u0007\u000b\u0004F\u0011BBd\u0011\u001d\u0019\t\u000e\u0015C\u0005\u0007'Dqa!8Q\t\u0013\u0019y\u000eC\u0004\u0004~B#Iaa@\t\u000f\ru\u0007\u000b\"\u0003\u0005\u0010!9A\u0011\u0004)\u0005\n\u0011m\u0001b\u0002C\u0012!\u0012%AQE\u0001\u001a\u001b\u0006LGNY8y'\u0016$X\u000b\u001d3bi\u0016\u0004VM\u001d4pe6,'O\u0003\u0002bE\u00061Q.\u001a;i_\u0012T!a\u00193\u0002\t)l\u0017\r\u001d\u0006\u0003K\u001a\fQA[1nKNT!a\u001a5\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0017aA8sO\u000e\u0001\u0001C\u00017\u0002\u001b\u0005\u0001'!G'bS2\u0014w\u000e_*fiV\u0003H-\u0019;f!\u0016\u0014hm\u001c:nKJ\u001c\"!A8\u0011\u0005A\u001cX\"A9\u000b\u0003I\fQa]2bY\u0006L!\u0001^9\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1NA\nNC&d'm\u001c=Va\u0012\fG/\u001a*fgVdGo\u0005\u0002\u0004_&\u001a1A\u0007\u0003\u0003)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f\r\u0006LG.\u001e:f'\u0019Qr\u000e @\u0002\u0004A\u0011QpA\u0007\u0002\u0003A\u0011\u0001o`\u0005\u0004\u0003\u0003\t(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u000b\t)B\u0004\u0003\u0002\b\u0005Ea\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!.\u0001\u0004=e>|GOP\u0005\u0002e&\u0019\u00111C9\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\u0019\"]\u0001\n[\u0006LGNY8y\u0013\u0012,\"!a\b\u0011\t\u0005\u0005\u0012q\b\b\u0005\u0003G\tID\u0004\u0003\u0002&\u0005Ub\u0002BA\u0014\u0003gqA!!\u000b\u000229!\u00111FA\u0018\u001d\u0011\tI!!\f\n\u0003%L!a\u001a5\n\u0005\u00154\u0017BA2e\u0013\r\t9DY\u0001\u0005[\u0006LG.\u0003\u0003\u0002<\u0005u\u0012AC'bS2\u0014w\u000e_$fi*\u0019\u0011q\u00072\n\t\u0005\u0005\u00131\t\u0002\u0012+:\u0004\u0018M]:fI6\u000b\u0017\u000e\u001c2pq&#'\u0002BA\u001e\u0003{\t!\"\\1jY\n|\u00070\u00133!\u0003%)\u0007pY3qi&|g.\u0006\u0002\u0002LA!\u0011QAA'\u0013\u0011\ty%!\u0007\u0003\u0013QC'o\\<bE2,\u0017AC3yG\u0016\u0004H/[8oA\u0005)\u0001/\u0019;dQV\u0011\u0011q\u000b\t\u0006a\u0006e\u0013QL\u0005\u0004\u00037\n(AB(qi&|g\u000e\u0005\u0003\u0002`\u0005\u0005TBAA\u001f\u0013\u0011\t\u0019'!\u0010\u00037Y\u000bG.\u001b3bi\u0016$W*Y5mE>D\b+\u0019;dQ>\u0013'.Z2u\u0003\u0019\u0001\u0018\r^2iAQA\u0011\u0011NA6\u0003[\ny\u0007\u0005\u0002~5!9\u00111D\u0011A\u0002\u0005}\u0001bBA$C\u0001\u0007\u00111\n\u0005\b\u0003'\n\u0003\u0019AA,\u0003\u00191\u0017\u000e\u001c;feR!\u0011QOAB!\u0015\u0001\u0018\u0011LA<!\u0011\tI(a \u000e\u0005\u0005m$bAA?E\u0006!1m\u001c:f\u0013\u0011\t\t)a\u001f\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002\u0006\n\u0002\r!a\u001e\u0002)\u0005\u001c7-\u001a9uC\ndW\r\u0015:pa\u0016\u0014H/[3t\u0003E\t7/T1jY\n|\u0007pU3u\u000bJ\u0014xN]\u000b\u0003\u0003\u0017\u0003B!!\u001f\u0002\u000e&!\u0011qRA>\u0005!\u0019V\r^#se>\u0014\u0018\u0001B2paf$\u0002\"!\u001b\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\n\u00037!\u0003\u0013!a\u0001\u0003?A\u0011\"a\u0012%!\u0003\u0005\r!a\u0013\t\u0013\u0005MC\u0005%AA\u0002\u0005]\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003?SC!a\b\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.F\f!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]&\u0006BA&\u0003C\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002>*\"\u0011qKAQ\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0019\t\u0005\u0003\u000b\fy-\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0017\u0001\u00026bm\u0006LA!!5\u0002H\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a6\u0011\u0007A\fI.C\u0002\u0002\\F\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!9\u0002hB\u0019\u0001/a9\n\u0007\u0005\u0015\u0018OA\u0002B]fD\u0011\"!;+\u0003\u0003\u0005\r!a6\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u000f\u0005\u0004\u0002r\u0006]\u0018\u0011]\u0007\u0003\u0003gT1!!>r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\f\u0019P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0000\u0005\u000b\u00012\u0001\u001dB\u0001\u0013\r\u0011\u0019!\u001d\u0002\b\u0005>|G.Z1o\u0011%\tI\u000fLA\u0001\u0002\u0004\t\t/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAb\u0005\u0017A\u0011\"!;.\u0003\u0003\u0005\r!a6\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a6\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a1\u0002\r\u0015\fX/\u00197t)\u0011\tyP!\u0007\t\u0013\u0005%\b'!AA\u0002\u0005\u0005(\u0001F'bS2\u0014w\u000e_+qI\u0006$XmU;dG\u0016\u001c8o\u0005\u0004\u0005_rt\u00181A\u000b\u0003\u0005C\u0001BAa\t\u0003.5\u0011!Q\u0005\u0006\u0005\u0005O\u0011I#A\u0003n_\u0012,GNC\u0002\u0003,\u0011\fq!\\1jY\n|\u00070\u0003\u0003\u00030\t\u0015\"!C'bS2\u0014w\u000e_%e)\u0011\u0011\u0019D!\u000e\u0011\u0005u$\u0001bBA\u000e\u000f\u0001\u0007!\u0011\u0005\u000b\u0005\u0005g\u0011I\u0004C\u0005\u0002\u001c!\u0001\n\u00111\u0001\u0003\"U\u0011!Q\b\u0016\u0005\u0005C\t\t\u000b\u0006\u0003\u0002b\n\u0005\u0003\"CAu\u0019\u0005\u0005\t\u0019AAl)\u0011\tyP!\u0012\t\u0013\u0005%h\"!AA\u0002\u0005\u0005H\u0003BAb\u0005\u0013B\u0011\"!;\u0010\u0003\u0003\u0005\r!a6\u0015\t\u0005}(Q\n\u0005\n\u0003S\u0014\u0012\u0011!a\u0001\u0003C\fA#T1jY\n|\u00070\u00169eCR,7+^2dKN\u001c\bCA?\u0015'\u0015!\"Q\u000bB1!!\u00119F!\u0018\u0003\"\tMRB\u0001B-\u0015\r\u0011Y&]\u0001\beVtG/[7f\u0013\u0011\u0011yF!\u0017\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0003d\t%TB\u0001B3\u0015\u0011\u00119'a3\u0002\u0005%|\u0017\u0002BA\f\u0005K\"\"A!\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\tM\"\u0011\u000f\u0005\b\u000379\u0002\u0019\u0001B\u0011\u0003\u001d)h.\u00199qYf$BAa\u001e\u0003zA)\u0001/!\u0017\u0003\"!I!1\u0010\r\u0002\u0002\u0003\u0007!1G\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BA!\u0011\t)Ma!\n\t\t\u0015\u0015q\u0019\u0002\u0007\u001f\nTWm\u0019;\u0002)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f\r\u0006LG.\u001e:f!\ti(gE\u00033\u0005\u001b\u0013\t\u0007\u0005\u0007\u0003X\t=\u0015qDA&\u0003/\nI'\u0003\u0003\u0003\u0012\ne#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!\u0011\u0012\u000b\t\u0003S\u00129J!'\u0003\u001c\"9\u00111D\u001bA\u0002\u0005}\u0001bBA$k\u0001\u0007\u00111\n\u0005\b\u0003'*\u0004\u0019AA,)\u0011\u0011yJa*\u0011\u000bA\fIF!)\u0011\u0013A\u0014\u0019+a\b\u0002L\u0005]\u0013b\u0001BSc\n1A+\u001e9mKNB\u0011Ba\u001f7\u0003\u0003\u0005\r!!\u001b\u0003)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f%\u0016\u001cX\u000f\u001c;t'\u0015AtN`A\u0002\u0003\u001d\u0011Xm];miN,\"A!-\u0011\u000b\u0005\u0015!1\u0017?\n\t\tU\u0016\u0011\u0004\u0002\u0004'\u0016\f\u0018\u0001\u0003:fgVdGo\u001d\u0011\u0015\t\tm&Q\u0018\t\u0003{bBqA!,<\u0001\u0004\u0011\t,A\u0004va\u0012\fG/\u001a3\u0016\u0005\t\r\u0007\u0003\u0003Bc\u0005\u001b\u0014\tCa5\u000f\t\t\u001d'\u0011\u001a\t\u0004\u0003\u0013\t\u0018b\u0001Bfc\u00061\u0001K]3eK\u001aLAAa4\u0003R\n\u0019Q*\u00199\u000b\u0007\t-\u0017\u000f\u0005\u0003\u0002`\tU\u0017\u0002\u0002Bl\u0003{\u0011Q#T1jY\n|\u00070\u00169eCR,'+Z:q_:\u001cX-\u0001\u0006o_R,\u0006\u000fZ1uK\u0012,\"A!8\u0011\u0011\t\u0015'QZA\u0010\u0003\u0017#BAa/\u0003b\"I!Q\u0016 \u0011\u0002\u0003\u0007!\u0011W\u000b\u0003\u0005KTCA!-\u0002\"R!\u0011\u0011\u001dBu\u0011%\tIOQA\u0001\u0002\u0004\t9\u000e\u0006\u0003\u0002\u0000\n5\b\"CAu\t\u0006\u0005\t\u0019AAq)\u0011\t\u0019M!=\t\u0013\u0005%X)!AA\u0002\u0005]G\u0003BA\u0000\u0005kD\u0011\"!;I\u0003\u0003\u0005\r!!9\u0002)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f%\u0016\u001cX\u000f\u001c;t!\ti(jE\u0003K\u0005{\u0014\t\u0007\u0005\u0005\u0003X\tu#\u0011\u0017B^)\t\u0011I\u0010\u0006\u0003\u0003<\u000e\r\u0001b\u0002BW\u001b\u0002\u0007!\u0011\u0017\u000b\u0005\u0007\u000f\u0019I\u0001E\u0003q\u00033\u0012\t\fC\u0005\u0003|9\u000b\t\u00111\u0001\u0003<N\u0011\u0001k\\\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003BB\t\u0007/i!aa\u0005\u000b\u0007\rU!-\u0001\u0003kg>t\u0017\u0002BB\r\u0007'\u0011\u0011#T1jY\n|\u0007pU3sS\u0006d\u0017N_3s\u00039i\u0017-\u001b7c_bl\u0015M\\1hKJ\u0004Baa\b\u0004\"5\u0011!\u0011F\u0005\u0005\u0007G\u0011IC\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002'M,(m]2sSB$\u0018n\u001c8NC:\fw-\u001a:\u0011\t\r}1\u0011F\u0005\u0005\u0007W\u0011ICA\nTk\n\u001c8M]5qi&|g.T1oC\u001e,'/\u0001\tnC&d'm\u001c=JI\u001a\u000b7\r^8ssB!1\u0011GB\u001c\u001d\u0011\u0011\u0019ca\r\n\t\rU\"QE\u0001\n\u001b\u0006LGNY8y\u0013\u0012LAa!\u000f\u0004<\t9a)Y2u_JL(\u0002BB\u001b\u0005K!\"ba\u0010\u0004B\r\r3QIB$!\ta\u0007\u000bC\u0004\u0004\u000eU\u0003\raa\u0004\t\u000f\rmQ\u000b1\u0001\u0004\u001e!91QE+A\u0002\r\u001d\u0002bBB\u0017+\u0002\u00071q\u0006\u0015\u0004+\u000e-\u0003\u0003BB'\u0007/j!aa\u0014\u000b\t\rE31K\u0001\u0007S:TWm\u0019;\u000b\u0005\rU\u0013!\u00026bm\u0006D\u0018\u0002BB-\u0007\u001f\u0012a!\u00138kK\u000e$\u0018aD;qI\u0006$X-T1jY\n|\u00070Z:\u0015\u0011\r}31PBC\u0007\u001f\u0003ba!\u0019\u0004p\rMTBAB2\u0015\u0011\u0019)ga\u001a\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001:\u0004j)!\u0011QPB6\u0015\t\u0019i'A\u0004sK\u0006\u001cGo\u001c:\n\t\rE41\r\u0002\u0006'6{gn\u001c\t\u0004\u0007kBdbAB<\u00019!\u0011QEB=\u0013\t\t'\rC\u0004\u0004~Y\u0003\raa \u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!1qDBA\u0013\u0011\u0019\u0019I!\u000b\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"91q\u0011,A\u0002\r%\u0015!E7bS2\u0014w\u000e_*fiJ+\u0017/^3tiB!\u0011qLBF\u0013\u0011\u0019i)!\u0010\u0003#5\u000b\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000fC\u0004\u0004\u0012Z\u0003\raa%\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\u0011\r\t\u00157QSBM\u0013\u0011\u00199J!5\u0003\u0007M+G\u000f\u0005\u0003\u0004\u001c\u000e\u0015f\u0002BBO\u0007CsA!!\n\u0004 &\u0019\u0011Q\u00102\n\t\r\r\u00161P\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\r\u001d6\u0011\u0016\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\t\r\r\u00161P\u0001\u000ekB$\u0017\r^3NC&d'm\u001c=\u0015\u0019\r=61WB[\u0007o\u001bYla1\u0011\r\r\u00054qNBY!\r\u0019)h\u0001\u0005\b\u0007{:\u0006\u0019AB@\u0011\u001d\tYb\u0016a\u0001\u0005CAqa!/X\u0001\u0004\ty\"A\tv]B\f'o]3e\u001b\u0006LGNY8y\u0013\u0012Dq!a\u0015X\u0001\u0004\u0019i\f\u0005\u0003\u0002`\r}\u0016\u0002BBa\u0003{\u0011!#T1jY\n|\u0007\u0010U1uG\"|%M[3di\"91\u0011S,A\u0002\rM\u0015AE;qI\u0006$XmU;cg\u000e\u0014\u0018\u000e\u001d;j_:$\u0002ba,\u0004J\u000e-7q\u001a\u0005\b\u00037A\u0006\u0019\u0001B\u0011\u0011\u001d\u0019i\r\u0017a\u0001\u0003;\naB^1mS\u0012\fG/\u001a3QCR\u001c\u0007\u000eC\u0004\u0004~a\u0003\raa \u0002#U\u0004H-\u0019;f\u001b\u0006LGNY8y!\u0006$\b\u000e\u0006\u0006\u00040\u000eU7q[Bm\u00077Dq!a\u0007Z\u0001\u0004\u0011\t\u0003C\u0004\u0004:f\u0003\r!a\b\t\u000f\r5\u0017\f1\u0001\u0002^!91QP-A\u0002\r}\u0014aE1qa2L\b+\u0019:f]RLE-\u00169eCR,G\u0003CBq\u0007[\u001cyoa?\u0011\u000fA\u001c\u0019oa:\u0004h&\u00191Q]9\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002B\u0012\u0007SLAaa;\u0003&\tYQ*Y5mE>D\b+\u0019;i\u0011\u001d\tYB\u0017a\u0001\u0005CAqa!=[\u0001\u0004\u0019\u00190A\nnCf\u0014W\rU1sK:$\u0018\nZ+qI\u0006$X\rE\u0003q\u00033\u001a)\u0010\u0005\u0003\u0002`\r]\u0018\u0002BB}\u0003{\u0011a\u0002U1sK:$\u0018\nZ+qI\u0006$X\rC\u0004\u0004~i\u0003\raa \u0002\u001f\u0005\u0004\b\u000f\\=OC6,W\u000b\u001d3bi\u0016$ba!9\u0005\u0002\u00115\u0001b\u0002C\u00027\u0002\u0007AQA\u0001\u0010[\u0006L(-\u001a(b[\u0016,\u0006\u000fZ1uKB)\u0001/!\u0017\u0005\bA!\u0011q\fC\u0005\u0013\u0011!Y!!\u0010\u0003\u00159\u000bW.Z+qI\u0006$X\rC\u0004\u0004~m\u0003\raa \u0015\u0011\r\u0005H\u0011\u0003C\n\t/Aq!a\u0007]\u0001\u0004\u0011\t\u0003C\u0004\u0005\u0016q\u0003\ra!>\u0002\u001dA\f'/\u001a8u\u0013\u0012,\u0006\u000fZ1uK\"91Q\u0010/A\u0002\r}\u0014aE;qI\u0006$X-T1jY\n|\u0007PU5hQR\u001cH\u0003CBX\t;!y\u0002\"\t\t\u000f\u0005mQ\f1\u0001\u0003\"!91QZ/A\u0002\u0005u\u0003bBB?;\u0002\u00071qP\u0001\u0011SN\f5+_:uK6l\u0015-\u001b7c_b$B!a@\u0005(!9!1\u00060A\u0002\u0011%\u0002\u0003BB\u0010\tWIA\u0001\"\f\u0003*\tqQ*Z:tC\u001e,W*\u00198bO\u0016\u0014\b")
public class MailboxSetUpdatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxUpdateResults> updateMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, Set<Refined<String, string.Uri>> capabilities) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)mailboxSetRequest.update().getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            String string2;
            MailboxPatchObject patch;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    String unparsedMailboxId = (String)((Refined)tuple2._1()).value();
                    patch = (MailboxPatchObject)tuple2._2();
                    if (!(new Refined((Object)unparsedMailboxId) instanceof Refined)) break block2;
                    string2 = unparsedMailboxId;
                    if (patch != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            MailboxPatchObject mailboxPatchObject = patch;
            SMono sMono = ((SMono)MailboxGet$.MODULE$.parse($this.mailboxIdFactory, string2).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(string2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)), (Function1 & Serializable)mailboxId -> this.updateMailbox(mailboxSession, (MailboxId)mailboxId, string2, mailboxPatchObject, capabilities))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(string2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)));
            return sMono;
        };
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetUpdatePerformer$MailboxUpdateResults$.MODULE$);
    }

    private SMono<MailboxUpdateResult> updateMailbox(MailboxSession mailboxSession, MailboxId mailboxId, String unparsedMailboxId, MailboxPatchObject patch, Set<Refined<String, string.Uri>> capabilities) {
        return (SMono)patch.validate(this.mailboxIdFactory, this.serializer, capabilities, mailboxSession).fold((Function1 & Serializable)e -> SMono$.MODULE$.raiseError((Throwable)e), (Function1 & Serializable)validatedPatch -> this.updateMailboxRights(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession).then(this.updateSubscription(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)).then(this.updateMailboxPath(mailboxId, unparsedMailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)));
    }

    private SMono<MailboxUpdateResult> updateSubscription(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        return (SMono)validatedPatch.isSubscribedUpdate().map((Function1 & Serializable)isSubscribedUpdate -> SMono$.MODULE$.fromCallable(() -> {
            MailboxSetUpdatePerformer.$anonfun$updateSubscription$2(this, mailboxId, mailboxSession, isSubscribedUpdate);
            return BoxedUnit.UNIT;
        }).then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(Schedulers.elastic())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId)));
    }

    private SMono<MailboxUpdateResult> updateMailboxPath(MailboxId mailboxId, String unparsedMailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        return validatedPatch.shouldUpdateMailboxPath() ? SMono$.MODULE$.fromCallable(() -> {
            Product product;
            try {
                MailboxPath newPath;
                MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId, mailboxSession);
                if (this.isASystemMailbox(mailbox)) {
                    throw new SystemMailboxChangeException(mailboxId);
                }
                if (validatedPatch.parentIdUpdate().flatMap((Function1 & Serializable)x$3 -> x$3.newId()).contains((Object)mailboxId)) {
                    throw new LoopInMailboxGraphException(mailboxId);
                }
                MailboxPath oldPath = mailbox.getMailboxPath();
                Object object = !oldPath.equals((Object)(newPath = (MailboxPath)this.applyParentIdUpdate(mailboxId, validatedPatch.parentIdUpdate(), mailboxSession).andThen(this.applyNameUpdate(validatedPatch.nameUpdate(), mailboxSession)).apply((Object)oldPath))) ? $this.mailboxManager.renameMailbox(mailboxId, newPath, MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS, mailboxSession) : BoxedUnit.UNIT;
                product = new MailboxUpdateSuccess(mailboxId);
            }
            catch (Exception e) {
                product = new MailboxUpdateFailure(unparsedMailboxId, e, (Option<ValidatedMailboxPatchObject>)new Some((Object)validatedPatch));
            }
            return product;
        }).subscribeOn(Schedulers.elastic()) : SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId));
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, Option<ParentIdUpdate> maybeParentIdUpdate, MailboxSession mailboxSession) {
        return (Function1)maybeParentIdUpdate.map((Function1 & Serializable)parentIdUpdate -> this.applyParentIdUpdate(mailboxId, (ParentIdUpdate)parentIdUpdate, mailboxSession)).getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)x -> x);
    }

    private Function1<MailboxPath, MailboxPath> applyNameUpdate(Option<NameUpdate> maybeNameUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> (MailboxPath)maybeNameUpdate.map((Function1 & Serializable)nameUpdate -> {
            Option originalParentPath = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(originalPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
            return (MailboxPath)originalParentPath.map((Function1 & Serializable)x$4 -> x$4.child(nameUpdate.newName(), mailboxSession.getPathDelimiter())).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)mailboxSession.getUser(), (String)nameUpdate.newName()));
        }).getOrElse((Function0 & Serializable)() -> originalPath);
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, ParentIdUpdate parentIdUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> {
            String currentName = originalPath.getName(mailboxSession.getPathDelimiter());
            return (MailboxPath)parentIdUpdate.newId().map((Function1 & Serializable)id -> {
                Duration x$1;
                SMono qual$1 = SFlux$.MODULE$.fromPublisher((Publisher)$this.mailboxManager.search(MailboxQuery.builder().userAndNamespaceFrom(originalPath).expression((MailboxNameExpression)new PrefixedWildcard(new StringBuilder(0).append(originalPath.getName()).append(mailboxSession.getPathDelimiter()).toString())).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession)).filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)MailboxSetUpdatePerformer.$anonfun$applyParentIdUpdate$6(id, child))).hasElements();
                boolean createsALoop = BoxesRunTime.unboxToBoolean((Object)qual$1.block(x$1 = qual$1.block$default$1()));
                if (createsALoop) {
                    throw new LoopInMailboxGraphException(mailboxId);
                }
                MailboxPath parentPath = $this.mailboxManager.getMailbox(id, mailboxSession).getMailboxPath();
                return parentPath.child(currentName, mailboxSession.getPathDelimiter());
            }).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)originalPath.getUser(), (String)currentName));
        };
    }

    private SMono<MailboxUpdateResult> updateMailboxRights(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        SMono resetOperation = (SMono)validatedPatch.rightsReset().map((Function1 & Serializable)sharedWithResetUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.setRights(mailboxId, sharedWithResetUpdate.rights().toMailboxAcl().asJava(), mailboxSession);
            return BoxedUnit.UNIT;
        }).then()).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validatedPatch.rightsPartialUpdates());
        Function1 & Serializable x$1 = (Function1 & Serializable)partialUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.applyRightsCommand(mailboxId, partialUpdate.asACLCommand(), mailboxSession);
            return BoxedUnit.UNIT;
        });
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SMono partialUpdatesOperation = qual$1.flatMap((Function1)x$1, 5, x$3, x$4).then();
        return SFlux$.MODULE$.merge((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SMono[]{resetOperation, partialUpdatesOperation})), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).then().then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(Schedulers.elastic());
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ void $anonfun$updateSubscription$2(MailboxSetUpdatePerformer $this, MailboxId mailboxId$2, MailboxSession mailboxSession$3, IsSubscribedUpdate isSubscribedUpdate$1) {
        MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId$2, mailboxSession$3);
        boolean isOwner = mailbox.getMailboxPath().belongsTo(mailboxSession$3);
        boolean shouldSubscribe = BoxesRunTime.unboxToBoolean((Object)isSubscribedUpdate$1.isSubscribed().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)((IsSubscribed)x$2).value())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> isOwner));
        if (shouldSubscribe) {
            $this.subscriptionManager.subscribe(mailboxSession$3, mailbox.getMailboxPath().getName());
        } else {
            $this.subscriptionManager.unsubscribe(mailboxSession$3, mailbox.getMailboxPath().getName());
        }
    }

    public static final /* synthetic */ boolean $anonfun$applyParentIdUpdate$6(MailboxId id$1, MailboxMetaData child) {
        return child.getId().equals(id$1);
    }

    @Inject
    public MailboxSetUpdatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxUpdateFailure
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final String mailboxId;
        private final Throwable exception;
        private final Option<ValidatedMailboxPatchObject> patch;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public Option<ValidatedMailboxPatchObject> patch() {
            return this.patch;
        }

        public Option<Properties> filter(Properties acceptableProperties) {
            return new Some(this.patch().map((Function1 & Serializable)x$1 -> x$1.updatedProperties().intersect(acceptableProperties)).getOrElse((Function0 & Serializable)() -> acceptableProperties));
        }

        public SetError asMailboxSetError() {
            SetError setError;
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                setError = SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            } else if (throwable instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)throwable;
                setError = SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            } else if (throwable instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)throwable;
                setError = SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            } else if (throwable instanceof UnsupportedPropertyUpdatedException) {
                UnsupportedPropertyUpdatedException unsupportedPropertyUpdatedException = (UnsupportedPropertyUpdatedException)throwable;
                setError = SetError$.MODULE$.invalidArguments(new StringBuilder(45).append(new Refined((Object)unsupportedPropertyUpdatedException.property())).append(" property do not exist thus cannot be updated").toString(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)unsupportedPropertyUpdatedException.property())}))));
            } else if (throwable instanceof InvalidUpdateException) {
                InvalidUpdateException invalidUpdateException = (InvalidUpdateException)throwable;
                setError = SetError$.MODULE$.invalidArguments(String.valueOf(invalidUpdateException.cause()), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)invalidUpdateException.property())}))));
            } else if (throwable instanceof ServerSetPropertyException) {
                ServerSetPropertyException serverSetPropertyException = (ServerSetPropertyException)throwable;
                setError = SetError$.MODULE$.invalidArguments("Can not modify server-set properties", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)serverSetPropertyException.property())}))));
            } else if (throwable instanceof InvalidPropertyException) {
                InvalidPropertyException invalidPropertyException = (InvalidPropertyException)throwable;
                setError = SetError$.MODULE$.invalidPatch(String.valueOf(invalidPropertyException.cause()));
            } else if (throwable instanceof InvalidPatchException) {
                InvalidPatchException invalidPatchException = (InvalidPatchException)throwable;
                setError = SetError$.MODULE$.invalidPatch(String.valueOf(invalidPatchException.cause()));
            } else if (throwable instanceof SystemMailboxChangeException) {
                setError = SetError$.MODULE$.invalidArguments("Invalid change to a system mailbox", this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            } else if (throwable instanceof LoopInMailboxGraphException) {
                setError = SetError$.MODULE$.invalidArguments("A mailbox parentId property can not be set to itself or one of its child", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            } else if (throwable instanceof InsufficientRightsException) {
                setError = SetError$.MODULE$.invalidArguments("Invalid change to a delegated mailbox", SetError$.MODULE$.invalidArguments$default$2());
            } else if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                setError = SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), (Option<Properties>)None$.MODULE$);
            } else {
                setError = SetError$.MODULE$.serverFail(this.exception().getMessage());
            }
            return setError;
        }

        public MailboxUpdateFailure copy(String mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            return new MailboxUpdateFailure(mailboxId, exception, patch);
        }

        public String copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public Option<ValidatedMailboxPatchObject> copy$default$3() {
            return this.patch();
        }

        public String productPrefix() {
            return "MailboxUpdateFailure";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new Refined((Object)this.mailboxId());
                    break;
                }
                case 1: {
                    object = this.exception();
                    break;
                }
                case 2: {
                    object = this.patch();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateFailure;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxId";
                    break;
                }
                case 1: {
                    string2 = "exception";
                    break;
                }
                case 2: {
                    string2 = "patch";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)x$1;
            Refined refined = new Refined((Object)this.mailboxId());
            Refined refined2 = new Refined((Object)mailboxUpdateFailure.mailboxId());
            if (refined == null) {
                if (refined2 != null) {
                    return false;
                }
            } else if (!refined.equals(refined2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxUpdateFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            Option<ValidatedMailboxPatchObject> option = this.patch();
            Option<ValidatedMailboxPatchObject> option2 = mailboxUpdateFailure.patch();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!mailboxUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateFailure(String mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            this.patch = patch;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxUpdateResult {
    }

    public static class MailboxUpdateResults
    implements Product,
    Serializable {
        private final Seq<MailboxUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxUpdateResult> results() {
            return this.results;
        }

        public Map<MailboxId, MailboxUpdateResponse> updated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateSuccess) {
                    MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)mailboxUpdateResult;
                    none$ = new Some((Object)new Tuple2((Object)mailboxUpdateSuccess.mailboxId(), (Object)MailboxSetResponse$.MODULE$.empty()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Map<Refined<String, boolean.Not<collection.Empty>>, SetError> notUpdated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateFailure) {
                    MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)mailboxUpdateResult;
                    none$ = new Some((Object)new Tuple2((Object)new Refined((Object)mailboxUpdateFailure.mailboxId()), (Object)mailboxUpdateFailure.asMailboxSetError()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxUpdateResults copy(Seq<MailboxUpdateResult> results) {
            return new MailboxUpdateResults(results);
        }

        public Seq<MailboxUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.results();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateResults;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "results";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateResults mailboxUpdateResults = (MailboxUpdateResults)x$1;
            Seq<MailboxUpdateResult> seq = this.results();
            Seq<MailboxUpdateResult> seq2 = mailboxUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxUpdateResults.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateResults(Seq<MailboxUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxUpdateSuccess
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxUpdateSuccess copy(MailboxId mailboxId) {
            return new MailboxUpdateSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.mailboxId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateSuccess;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxId";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxUpdateSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

