/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.memory;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Objects;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;

public class MemoryRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private final List<InMemoryMappingEntry> mappingEntries = new ArrayList<InMemoryMappingEntry>();

    public void addMapping(MappingSource source, Mapping mapping) {
        this.mappingEntries.add(new InMemoryMappingEntry(source, mapping));
    }

    public void removeMapping(MappingSource source, Mapping mapping) {
        this.mappingEntries.remove(new InMemoryMappingEntry(source, mapping));
    }

    public Mappings getStoredMappings(MappingSource mappingSource) {
        return this.retrieveMappings(mappingSource).orElse((Mappings)MappingsImpl.empty());
    }

    protected Mappings mapAddress(String user, Domain domain) {
        return this.retrieveMappings(MappingSource.fromUser((Username)Username.fromLocalPartWithDomain((String)user, (Domain)domain))).or(() -> this.retrieveMappings(MappingSource.fromDomain((Domain)domain))).orElse((Mappings)MappingsImpl.empty());
    }

    public Map<MappingSource, Mappings> getAllMappings() {
        return (Map)Multimaps.index(this.mappingEntries, InMemoryMappingEntry::getSource).asMap().entrySet().stream().map(entry -> Pair.of((Object)((MappingSource)entry.getKey()), (Object)this.toMappings((Collection)entry.getValue()))).collect(Guavate.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    private MappingsImpl toMappings(Collection<InMemoryMappingEntry> inMemoryMappingEntries) {
        return MappingsImpl.fromMappings(inMemoryMappingEntries.stream().map(InMemoryMappingEntry::getMapping));
    }

    private Optional<Mappings> retrieveMappings(MappingSource mappingSource) {
        Stream<Mapping> userEntries = this.mappingEntries.stream().filter(mappingEntry -> mappingEntry.source.equals((Object)mappingSource)).map(InMemoryMappingEntry::getMapping);
        return MappingsImpl.fromMappings(userEntries).toOptional();
    }

    private static class InMemoryMappingEntry {
        private final MappingSource source;
        private final Mapping mapping;

        public InMemoryMappingEntry(MappingSource source, Mapping mapping) {
            this.source = source;
            this.mapping = mapping;
        }

        public MappingSource getSource() {
            return this.source;
        }

        public Mapping getMapping() {
            return this.mapping;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InMemoryMappingEntry that = (InMemoryMappingEntry)o;
            return Objects.equal((Object)this.source, (Object)that.source) && Objects.equal((Object)this.mapping, (Object)that.mapping);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.source, this.mapping});
        }
    }
}

