/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.cassandra.CassandraMappingsSourcesDAO;
import org.apache.james.rrt.cassandra.CassandraRecipientRewriteTableDAO;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;

public class CassandraRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private static final SchemaVersion MAPPINGS_SOURCES_SUPPORTED_VERSION = new SchemaVersion(7);
    private final CassandraRecipientRewriteTableDAO cassandraRecipientRewriteTableDAO;
    private final CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO;
    private final CassandraSchemaVersionManager versionManager;

    @Inject
    CassandraRecipientRewriteTable(CassandraRecipientRewriteTableDAO cassandraRecipientRewriteTableDAO, CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO, CassandraSchemaVersionManager versionManager) {
        this.cassandraRecipientRewriteTableDAO = cassandraRecipientRewriteTableDAO;
        this.cassandraMappingsSourcesDAO = cassandraMappingsSourcesDAO;
        this.versionManager = versionManager;
    }

    public void addMapping(MappingSource source, Mapping mapping) {
        this.cassandraRecipientRewriteTableDAO.addMapping(source, mapping).then(this.cassandraMappingsSourcesDAO.addMapping(mapping, source)).block();
    }

    public void removeMapping(MappingSource source, Mapping mapping) {
        this.cassandraRecipientRewriteTableDAO.removeMapping(source, mapping).then(this.cassandraMappingsSourcesDAO.removeMapping(mapping, source)).block();
    }

    public Mappings getStoredMappings(MappingSource source) {
        return (Mappings)this.cassandraRecipientRewriteTableDAO.retrieveMappings(source).blockOptional().orElse(MappingsImpl.empty());
    }

    public Map<MappingSource, Mappings> getAllMappings() {
        return (Map)this.cassandraRecipientRewriteTableDAO.getAllMappings().collect(Guavate.toImmutableMap(pair -> (MappingSource)pair.getLeft(), pair -> MappingsImpl.fromMappings((Mapping[])new Mapping[]{(Mapping)pair.getRight()}), Mappings::union)).block();
    }

    protected Mappings mapAddress(String user, Domain domain) {
        return (Mappings)this.cassandraRecipientRewriteTableDAO.retrieveMappings(MappingSource.fromUser((String)user, (Domain)domain)).blockOptional().or(() -> this.cassandraRecipientRewriteTableDAO.retrieveMappings(MappingSource.fromDomain((Domain)domain)).blockOptional()).orElse(MappingsImpl.empty());
    }

    public Stream<MappingSource> listSources(Mapping mapping) throws RecipientRewriteTableException {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains(mapping.getType()), (String)"Not supported mapping of type %s", (Object)mapping.getType());
        if (((Boolean)this.versionManager.isBefore(MAPPINGS_SOURCES_SUPPORTED_VERSION).block()).booleanValue()) {
            return super.listSources(mapping);
        }
        return this.cassandraMappingsSourcesDAO.retrieveSources(mapping).toStream();
    }
}

