/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore$;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.util.function.Tuples;
import scala.Function1;
import scala.compat.java8.FunctionConverters.package$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsConsumer$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsFunction$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-w!B\f\u0019\u0011\u0003)c!B\u0014\u0019\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007w\u0005\u0001\u000b\u0011B\u001a\t\u000fq\n!\u0019!C\u0001{!1\u0011)\u0001Q\u0001\nyBqAQ\u0001C\u0002\u0013\u00051\t\u0003\u0004H\u0003\u0001\u0006I\u0001\u0012\u0004\u0005Oa\u0001\u0001\n\u0003\u0005T\u0013\t\u0005\t\u0015!\u0003U\u0011!9\u0016B!A!\u0002\u0013A\u0006\u0002C4\n\u0005\u0003\u0005\u000b\u0011\u00025\t\u000b=JA\u0011A8\t\u000beLA\u0011\t>\t\reLA\u0011IA\u0018\u0011\u0019I\u0018\u0002\"\u0011\u0002P!9\u0011\u0011M\u0005\u0005\n\u0005\r\u0004bBAL\u0013\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003GKA\u0011IAS\u0011\u001d\tY+\u0003C!\u0003[Cq!a,\n\t\u0003\n\t\fC\u0004\u0002>&!\t%a0\u0002-\u0011+G)\u001e9mS\u000e\fG/[8o\u00052|'m\u0015;pe\u0016T!!\u0007\u000e\u0002\u001b\u0011,G-\u001e9mS\u000e\fG/[8o\u0015\tYB$\u0001\u0003cY>\u0014'BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0004I\u0001\u0006U\u0006lWm\u001d\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005\u0019\nQ\"\u0001\r\u0003-\u0011+G)\u001e9mS\u000e\fG/[8o\u00052|'m\u0015;pe\u0016\u001c\"!A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ%\u0001\bE\u000b\u001a\u000bU\u000b\u0014+`\u0005V\u001b5*\u0012+\u0016\u0003M\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\t1\fgn\u001a\u0006\u0002q\u0005!!.\u0019<b\u0013\tQTG\u0001\u0004TiJLgnZ\u0001\u0010\t\u00163\u0015)\u0016'U?\n+6iS#UA\u0005)B*\u0011.Z?J+5kT+S\u0007\u0016{6\tT#B\u001dV\u0003V#\u0001 \u0011\u0005)z\u0014B\u0001!,\u0005\u001d\u0011un\u001c7fC:\fa\u0003T![3~\u0013ViU(V%\u000e+ul\u0011'F\u0003:+\u0006\u000bI\u0001\u000f\r&cUi\u0018+I%\u0016\u001b\u0006j\u0014'E+\u0005!\u0005C\u0001\u0016F\u0013\t15FA\u0002J]R\fqBR%M\u000b~#\u0006JU#T\u0011>cE\tI\n\u0004\u0013%c\u0005C\u0001\u001bK\u0013\tYUG\u0001\u0004PE*,7\r\u001e\t\u0003\u001bFk\u0011A\u0014\u0006\u0003\u001fB\u000b1!\u00199j\u0015\tYb$\u0003\u0002S\u001d\nI!\t\\8c'R|'/Z\u0001\rE2|'m\u0015;pe\u0016$\u0015i\u0014\t\u0003\u001bVK!A\u0016(\u0003\u0019\tcwNY*u_J,G)Q(\u0002#\u0011,g-Y;mi\n+8m[3u\u001d\u0006lW\r\u0005\u0002N3&\u0011!L\u0014\u0002\u000b\u0005V\u001c7.\u001a;OC6,\u0007\u0006B\u0006]I\u0016\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\r%t'.Z2u\u0015\u0005\t\u0017!\u00026bm\u0006D\u0018BA2_\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\u00051\u0017!\u00043fM\u0006,H\u000e\u001e\"vG.,G/A\u0007cY>\u0014\u0017\n\u001a$bGR|'/\u001f\t\u0003S2t!!\u00146\n\u0005-t\u0015A\u0002\"m_\nLE-\u0003\u0002n]\n9a)Y2u_JL(BA6O)\u0011\u0001\u0018O\u001d;\u0011\u0005\u0019J\u0001\"B*\u000e\u0001\u0004!\u0006\"B,\u000e\u0001\u0004A\u0006\u0006\u0002:]I\u0016DQaZ\u0007A\u0002!D#!\u0004<\u0011\u0005u;\u0018B\u0001=_\u0005\u0019IeN[3di\u0006!1/\u0019<f)\u001dY\u0018\u0011BA\u0007\u0003;\u0001B\u0001`@\u0002\u00045\tQP\u0003\u0002\u007fE\u0005y!/Z1di&4Xm\u001d;sK\u0006l7/C\u0002\u0002\u0002u\u0014\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u00075\u000b)!C\u0002\u0002\b9\u0013aA\u00117pE&#\u0007BBA\u0006\u001d\u0001\u0007\u0001,\u0001\u0006ck\u000e\\W\r\u001e(b[\u0016Dq!a\u0004\u000f\u0001\u0004\t\t\"\u0001\u0003eCR\f\u0007#\u0002\u0016\u0002\u0014\u0005]\u0011bAA\u000bW\t)\u0011I\u001d:bsB\u0019!&!\u0007\n\u0007\u0005m1F\u0001\u0003CsR,\u0007bBA\u0010\u001d\u0001\u0007\u0011\u0011E\u0001\u000egR|'/Y4f!>d\u0017nY=\u0011\t\u0005\r\u0012\u0011\u0006\b\u0004\u001b\u0006\u0015\u0012bAA\u0014\u001d\u0006I!\t\\8c'R|'/Z\u0005\u0005\u0003W\tiCA\u0007Ti>\u0014\u0018mZ3Q_2L7-\u001f\u0006\u0004\u0003OqEcB>\u00022\u0005M\u0012Q\n\u0005\u0007\u0003\u0017y\u0001\u0019\u0001-\t\u000f\u0005=q\u00021\u0001\u00026A!\u0011qGA%\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012AA5p\u0015\u0011\ty$!\u0011\u0002\r\r|W.\\8o\u0015\u0011\t\u0019%!\u0012\u0002\r\u001d|wn\u001a7f\u0015\t\t9%A\u0002d_6LA!a\u0013\u0002:\tQ!)\u001f;f'>,(oY3\t\u000f\u0005}q\u00021\u0001\u0002\"Q910!\u0015\u0002T\u0005}\u0003BBA\u0006!\u0001\u0007\u0001\fC\u0004\u0002\u0010A\u0001\r!!\u0016\u0011\t\u0005]\u00131L\u0007\u0003\u00033R1!a\u000f8\u0013\u0011\ti&!\u0017\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003?\u0001\u0002\u0019AA\u0011\u0003U\u0019\u0018M^3B]\u0012<UM\\3sCR,'\t\\8c\u0013\u0012$\u0002\"!\u001a\u0002|\u0005u\u0014Q\u0012\t\u0007\u0003O\n9(a\u0001\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u00071\nyG\u0003\u0003\u0002r\u0005M\u0014\u0001B2pe\u0016T!!!\u001e\u0002\u000fI,\u0017m\u0019;pe&!\u0011\u0011PA5\u0005\u0015\u0019Vj\u001c8p\u0011\u0019\tY!\u0005a\u00011\"9\u0011qP\tA\u0002\u0005\u0005\u0015A\u00055bg\"LgnZ%oaV$8\u000b\u001e:fC6\u0004B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bi$\u0001\u0003iCND\u0017\u0002BAF\u0003\u000b\u0013!\u0003S1tQ&tw-\u00138qkR\u001cFO]3b[\"9\u0011qR\tA\u0002\u0005E\u0015A\u00064jY\u0016\u0014\u0015mY6fI>+H\u000f];u'R\u0014X-Y7\u0011\t\u0005]\u00121S\u0005\u0005\u0003+\u000bID\u0001\fGS2,')Y2lK\u0012|U\u000f\u001e9viN#(/Z1n\u0003%\u0011X-\u00193CsR,7\u000f\u0006\u0004\u0002\u001c\u0006u\u0015q\u0014\t\u0005y~\f\t\u0002\u0003\u0004\u0002\fI\u0001\r\u0001\u0017\u0005\b\u0003C\u0013\u0002\u0019AA\u0002\u0003\u0019\u0011Gn\u001c2JI\u0006!!/Z1e)\u0019\t)&a*\u0002*\"1\u00111B\nA\u0002aCq!!)\u0014\u0001\u0004\t\u0019!\u0001\u000bhKR$UMZ1vYR\u0014UoY6fi:\u000bW.\u001a\u000b\u00021\u0006aA-\u001a7fi\u0016\u0014UoY6fiR!\u00111WA^!\u0011ax0!.\u0011\u0007Q\n9,C\u0002\u0002:V\u0012AAV8jI\"1\u00111B\u000bA\u0002a\u000ba\u0001Z3mKR,GCBAa\u0003\u000f\fI\r\u0005\u0003}\u007f\u0006\r\u0007c\u0001\u001b\u0002F&\u0011\u0001)\u000e\u0005\u0007\u0003\u00171\u0002\u0019\u0001-\t\u000f\u0005\u0005f\u00031\u0001\u0002\u0004\u0001")
public class DeDuplicationBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public static int FILE_THRESHOLD() {
        return DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD();
    }

    public static boolean LAZY_RESOURCE_CLEANUP() {
        return DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP();
    }

    public static String DEFAULT_BUCKET() {
        return DeDuplicationBlobStore$.MODULE$.DEFAULT_BUCKET();
    }

    public Publisher<BlobId> save(BucketName x$1, String x$2, BlobStore.StoragePolicy x$3) {
        return super.save(x$1, x$2, x$3);
    }

    public Publisher<byte[]> readBytes(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readBytes(x$1, x$2, x$3);
    }

    public InputStream read(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.read(x$1, x$2, x$3);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.forPayload(data);
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.forPayload(data);
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        HashingInputStream hashingInputStream = new HashingInputStream(Hashing.sha256(), data);
        Function1 & Serializable sourceSupplier = (Function1 & Serializable)fileBackedOutputStream -> this.saveAndGenerateBlobId(bucketName, hashingInputStream, (FileBackedOutputStream)fileBackedOutputStream).asJava();
        Callable<FileBackedOutputStream> ressourceSupplier = () -> new FileBackedOutputStream(DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD());
        return Mono.using(ressourceSupplier, (Function)RichFunction1AsFunction$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaFunction((Function1)sourceSupplier)), (Consumer)RichFunction1AsConsumer$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaConsumer((Function1 & Serializable)fileBackedOutputStream -> {
            fileBackedOutputStream.reset();
            return BoxedUnit.UNIT;
        })), (boolean)DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP());
    }

    private SMono<BlobId> saveAndGenerateBlobId(BucketName bucketName, HashingInputStream hashingInputStream, FileBackedOutputStream fileBackedOutputStream) {
        return SMono$.MODULE$.fromCallable(() -> {
            IOUtils.copy((InputStream)hashingInputStream, (OutputStream)fileBackedOutputStream);
            return Tuples.of((Object)$this.blobIdFactory.from(hashingInputStream.hash().toString()), (Object)fileBackedOutputStream.asByteSource());
        }).flatMap((Function1 & Serializable)tuple -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, (BlobId)tuple.getT1(), (ByteSource)tuple.getT2())).then(SMono$.MODULE$.just(tuple.getT1())));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Inject
    public DeDuplicationBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

