/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.jmap.draft.model.Filter;
import org.apache.james.jmap.draft.model.FilterCondition;
import org.apache.james.jmap.draft.model.FilterOperator;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.mailbox.model.SearchQuery;

public class FilterToCriteria {
    public Stream<SearchQuery.Criterion> convert(Filter filter) {
        if (filter instanceof FilterCondition) {
            return this.convertCondition((FilterCondition)filter);
        }
        if (filter instanceof FilterOperator) {
            return Stream.of(this.convertOperator((FilterOperator)filter));
        }
        throw new RuntimeException("Unknown filter: " + filter.getClass());
    }

    private Stream<SearchQuery.Criterion> convertCondition(FilterCondition filter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        filter.getText().ifPresent(text -> builder.add((Object)SearchQuery.or((List)ImmutableList.of((Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)text), (Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)text), (Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Cc, (String)text), (Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Bcc, (String)text), (Object)SearchQuery.headerContains((String)"Subject", (String)text), (Object)SearchQuery.attachmentContains((String)text), (Object)SearchQuery.bodyContains((String)text), (Object)SearchQuery.attachmentFileName((String)text)))));
        filter.getFrom().ifPresent(from -> builder.add((Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)from)));
        filter.getTo().ifPresent(to -> builder.add((Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)to)));
        filter.getCc().ifPresent(cc -> builder.add((Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Cc, (String)cc)));
        filter.getBcc().ifPresent(bcc -> builder.add((Object)SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Bcc, (String)bcc)));
        filter.getSubject().ifPresent(subject -> builder.add((Object)SearchQuery.headerContains((String)"Subject", (String)subject)));
        filter.getAttachments().ifPresent(attachments -> builder.add((Object)SearchQuery.attachmentContains((String)attachments)));
        filter.getBody().ifPresent(body -> builder.add((Object)SearchQuery.bodyContains((String)body)));
        filter.getAfter().ifPresent(after -> builder.add((Object)SearchQuery.sentDateAfter((Date)Date.from(after.toInstant()), (SearchQuery.DateResolution)SearchQuery.DateResolution.Second)));
        filter.getBefore().ifPresent(before -> builder.add((Object)SearchQuery.sentDateBefore((Date)Date.from(before.toInstant()), (SearchQuery.DateResolution)SearchQuery.DateResolution.Second)));
        filter.getHeader().ifPresent(header -> builder.add((Object)SearchQuery.headerContains((String)header.getName(), (String)header.getValue().orElse(null))));
        filter.getIsAnswered().ifPresent(isAnswered -> builder.add((Object)SearchQuery.flag((Flags.Flag)Flags.Flag.ANSWERED, (boolean)isAnswered)));
        filter.getIsDraft().ifPresent(isDraft -> builder.add((Object)SearchQuery.flag((Flags.Flag)Flags.Flag.DRAFT, (boolean)isDraft)));
        filter.getIsFlagged().ifPresent(isFlagged -> builder.add((Object)SearchQuery.flag((Flags.Flag)Flags.Flag.FLAGGED, (boolean)isFlagged)));
        filter.getIsUnread().ifPresent(isUnread -> builder.add((Object)SearchQuery.flag((Flags.Flag)Flags.Flag.SEEN, (isUnread == false ? 1 : 0) != 0)));
        filter.getIsForwarded().ifPresent(isForwarded -> builder.add((Object)SearchQuery.flagSet((String)Keyword.FORWARDED.getFlagName(), (boolean)isForwarded)));
        filter.getMaxSize().ifPresent(maxSize -> builder.add((Object)SearchQuery.sizeLessThan((long)maxSize.asLong())));
        filter.getMinSize().ifPresent(minSize -> builder.add((Object)SearchQuery.sizeGreaterThan((long)minSize.asLong())));
        filter.getHasAttachment().ifPresent(hasAttachment -> builder.add((Object)SearchQuery.hasAttachment((boolean)hasAttachment)));
        filter.getHasKeyword().ifPresent(hasKeyword -> this.keywordQuery((String)hasKeyword, true).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)));
        filter.getNotKeyword().ifPresent(notKeyword -> this.keywordQuery((String)notKeyword, false).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)));
        filter.getAttachmentFileName().ifPresent(attachmentFileName -> builder.add((Object)SearchQuery.attachmentFileName((String)attachmentFileName)));
        return builder.build().stream();
    }

    private Optional<SearchQuery.Criterion> keywordQuery(String stringKeyword, boolean isSet) {
        Keyword keyword = Keyword.of(stringKeyword);
        if (keyword.isExposedImapKeyword()) {
            return Optional.of(this.getFlagCriterion(keyword, isSet));
        }
        return Optional.empty();
    }

    private SearchQuery.Criterion getFlagCriterion(Keyword keyword, boolean isSet) {
        return keyword.asSystemFlag().map(flag -> SearchQuery.flagSet((Flags.Flag)flag, (boolean)isSet)).orElse(SearchQuery.flagSet((String)keyword.getFlagName(), (boolean)isSet));
    }

    private SearchQuery.Criterion convertOperator(FilterOperator filter) {
        switch (filter.getOperator()) {
            case AND: {
                return SearchQuery.and(this.convertCriterias(filter));
            }
            case OR: {
                return SearchQuery.or(this.convertCriterias(filter));
            }
            case NOT: {
                return SearchQuery.not(this.convertCriterias(filter));
            }
        }
        throw new RuntimeException("Unknown operator");
    }

    private ImmutableList<SearchQuery.Criterion> convertCriterias(FilterOperator filter) {
        return (ImmutableList)filter.getConditions().stream().flatMap(this::convert).collect(Guavate.toImmutableList());
    }
}

