/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import org.apache.james.jmap.draft.exceptions.JmapFieldNotSupportedException;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.model.MailboxProperty;
import org.apache.james.mailbox.model.MailboxId;

@JsonDeserialize(builder=Builder.class)
public class GetMailboxesRequest
implements JmapRequest {
    private static final String ISSUER = "GetMailboxesRequest";
    private final Optional<String> accountId;
    private final Optional<ImmutableList<MailboxId>> ids;
    private final Optional<ImmutableSet<MailboxProperty>> properties;

    public static Builder builder() {
        return new Builder();
    }

    private GetMailboxesRequest(Optional<String> accountId, Optional<ImmutableList<MailboxId>> ids, Optional<ImmutableSet<MailboxProperty>> properties) {
        this.accountId = accountId;
        this.ids = ids;
        this.properties = properties;
    }

    public Optional<String> getAccountId() {
        return this.accountId;
    }

    public Optional<ImmutableList<MailboxId>> getIds() {
        return this.ids;
    }

    public Optional<ImmutableSet<MailboxProperty>> getProperties() {
        return this.properties;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String accountId;
        private Optional<ImmutableSet<MailboxProperty>> properties;
        private Optional<ImmutableList<MailboxId>> ids = Optional.empty();

        private Builder() {
            this.properties = Optional.empty();
        }

        public Builder accountId(String accountId) {
            if (accountId != null) {
                throw new JmapFieldNotSupportedException(GetMailboxesRequest.ISSUER, "accountId");
            }
            return this;
        }

        public Builder ids(List<MailboxId> ids) {
            if (ids != null) {
                this.ids = Optional.of(ImmutableList.copyOf(ids));
            }
            return this;
        }

        public Builder properties(List<String> properties) {
            this.properties = Optional.of((ImmutableSet)properties.stream().map(MailboxProperty::findProperty).flatMap(Optional::stream).collect(Guavate.toImmutableSet()));
            return this;
        }

        public GetMailboxesRequest build() {
            return new GetMailboxesRequest(Optional.ofNullable(this.accountId), this.ids, this.properties);
        }
    }
}

