/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.vavr.control.Try;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.exceptions.DraftMessageMailboxUpdateException;
import org.apache.james.jmap.draft.exceptions.InvalidOutboxMoveException;
import org.apache.james.jmap.draft.methods.MailboxSendingNotAllowedException;
import org.apache.james.jmap.draft.methods.MessageSender;
import org.apache.james.jmap.draft.methods.ReferenceUpdater;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.methods.UpdateMessagePatchConverter;
import org.apache.james.jmap.draft.methods.ValidationResult;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.jmap.draft.model.UpdateMessagePatch;
import org.apache.james.jmap.draft.utils.KeywordsCombiner;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class SetMessagesUpdateProcessor
implements SetMessagesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMessagesUpdateProcessor.class);
    private final UpdateMessagePatchConverter updatePatchConverter;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MailboxId.Factory mailboxIdFactory;
    private final MetricFactory metricFactory;
    private final MessageSender messageSender;
    private final ReferenceUpdater referenceUpdater;
    private final CanSendFrom canSendFrom;

    @Inject
    @VisibleForTesting
    SetMessagesUpdateProcessor(UpdateMessagePatchConverter updatePatchConverter, MessageIdManager messageIdManager, MailboxManager mailboxManager, SystemMailboxesProvider systemMailboxesProvider, MailboxId.Factory mailboxIdFactory, MessageSender messageSender, MetricFactory metricFactory, ReferenceUpdater referenceUpdater, CanSendFrom canSendFrom) {
        this.updatePatchConverter = updatePatchConverter;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.mailboxIdFactory = mailboxIdFactory;
        this.metricFactory = metricFactory;
        this.messageSender = messageSender;
        this.referenceUpdater = referenceUpdater;
        this.canSendFrom = canSendFrom;
    }

    @Override
    public SetMessagesResponse process(SetMessagesRequest request, MailboxSession mailboxSession) {
        TimeMetric timeMetric = this.metricFactory.timer("JMAP-SetMessagesUpdateProcessor");
        SetMessagesResponse.Builder responseBuilder = SetMessagesResponse.builder();
        Try.ofCallable(() -> this.listMailboxIdsForRole(mailboxSession, Role.OUTBOX)).map(outboxes -> {
            this.prepareResponse(request, mailboxSession, responseBuilder, (Set<MailboxId>)outboxes);
            return null;
        }).onFailure(e -> request.buildUpdatePatches(this.updatePatchConverter).forEach((id, patch) -> this.prepareResponseIfCantReadOutboxes(responseBuilder, (Throwable)e, (MessageId)id, (UpdateMessagePatch)patch)));
        timeMetric.stopAndPublish();
        return responseBuilder.build();
    }

    private void prepareResponseIfCantReadOutboxes(SetMessagesResponse.Builder responseBuilder, Throwable e, MessageId id, UpdateMessagePatch patch) {
        if (patch.isValid()) {
            this.handleMessageUpdateException(id, responseBuilder, e);
        } else {
            this.handleInvalidRequest(responseBuilder, id, patch.getValidationErrors(), patch);
        }
    }

    private void prepareResponse(SetMessagesRequest request, MailboxSession mailboxSession, SetMessagesResponse.Builder responseBuilder, Set<MailboxId> outboxes) {
        Multimap messages;
        Map<MessageId, UpdateMessagePatch> patches = request.buildUpdatePatches(this.updatePatchConverter);
        if (this.isAMassiveFlagUpdate(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)(messages = (Multimap)Flux.from((Publisher)this.messageIdManager.messagesMetadata(patches.keySet(), mailboxSession)).collect(Guavate.toImmutableListMultimap(metaData -> metaData.getComposedMessageId().getMessageId())).block()))) {
            this.applyRangedFlagUpdate(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages, responseBuilder, mailboxSession);
        } else if (this.isAMassiveMove(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages)) {
            this.applyMove(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages, responseBuilder, mailboxSession);
        } else {
            patches.forEach((id, patch) -> {
                if (patch.isValid()) {
                    this.update(outboxes, (MessageId)id, (UpdateMessagePatch)patch, mailboxSession, responseBuilder, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages);
                } else {
                    this.handleInvalidRequest(responseBuilder, (MessageId)id, patch.getValidationErrors(), (UpdateMessagePatch)patch);
                }
            });
        }
    }

    private boolean isAMassiveFlagUpdate(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages) {
        return StreamUtils.isSingleValued(patches.values().stream()) && StreamUtils.isSingleValued(messages.values().stream().map(metaData -> metaData.getComposedMessageId().getMailboxId())) && patches.values().iterator().next().isOnlyAFlagUpdate() && messages.size() > 3;
    }

    private boolean isAMassiveMove(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages) {
        return StreamUtils.isSingleValued(patches.values().stream()) && StreamUtils.isSingleValued(messages.values().stream().map(metaData -> metaData.getComposedMessageId().getMailboxId())) && patches.values().iterator().next().isOnlyAMove() && messages.size() > 3;
    }

    private void applyRangedFlagUpdate(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages, SetMessagesResponse.Builder responseBuilder, MailboxSession mailboxSession) {
        MailboxId mailboxId = ((ComposedMessageIdWithMetaData)messages.values().iterator().next()).getComposedMessageId().getMailboxId();
        UpdateMessagePatch patch = patches.values().iterator().next();
        List uidRanges = MessageRange.toRanges((Collection)((Collection)messages.values().stream().map(metaData -> metaData.getComposedMessageId().getUid()).distinct().collect(Guavate.toImmutableList())));
        if (patch.isValid()) {
            uidRanges.forEach(range -> {
                ImmutableList messageIds = (ImmutableList)messages.entries().stream().filter(entry -> range.includes(((ComposedMessageIdWithMetaData)entry.getValue()).getComposedMessageId().getUid())).map(Map.Entry::getKey).distinct().collect(Guavate.toImmutableList());
                try {
                    this.mailboxManager.getMailbox(mailboxId, mailboxSession).setFlags(patch.applyToState(new Flags()), MessageManager.FlagsUpdateMode.REPLACE, range, mailboxSession);
                    responseBuilder.updated((List<MessageId>)messageIds);
                }
                catch (MailboxException e) {
                    messageIds.forEach(messageId -> this.handleMessageUpdateException((MessageId)messageId, responseBuilder, e));
                }
                catch (IllegalArgumentException e) {
                    ValidationResult invalidPropertyKeywords = ValidationResult.builder().property(MessageProperties.MessageProperty.keywords.asFieldName()).message(e.getMessage()).build();
                    messageIds.forEach(messageId -> this.handleInvalidRequest(responseBuilder, (MessageId)messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyKeywords), patch));
                }
            });
        } else {
            messages.keySet().forEach(messageId -> this.handleInvalidRequest(responseBuilder, (MessageId)messageId, patch.getValidationErrors(), patch));
        }
    }

    private void applyMove(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages, SetMessagesResponse.Builder responseBuilder, MailboxSession mailboxSession) {
        MailboxId mailboxId = ((ComposedMessageIdWithMetaData)messages.values().iterator().next()).getComposedMessageId().getMailboxId();
        UpdateMessagePatch patch = patches.values().iterator().next();
        List uidRanges = MessageRange.toRanges((Collection)((Collection)messages.values().stream().map(metaData -> metaData.getComposedMessageId().getUid()).distinct().collect(Guavate.toImmutableList())));
        if (patch.isValid()) {
            uidRanges.forEach(range -> {
                ImmutableList messageIds = (ImmutableList)messages.entries().stream().filter(entry -> range.includes(((ComposedMessageIdWithMetaData)entry.getValue()).getComposedMessageId().getUid())).map(Map.Entry::getKey).distinct().collect(Guavate.toImmutableList());
                try {
                    MailboxId targetId = this.mailboxIdFactory.fromString(patch.getMailboxIds().get().iterator().next());
                    this.mailboxManager.moveMessages(range, mailboxId, targetId, mailboxSession);
                    responseBuilder.updated((List<MessageId>)messageIds);
                }
                catch (MailboxException e) {
                    messageIds.forEach(messageId -> this.handleMessageUpdateException((MessageId)messageId, responseBuilder, e));
                }
                catch (IllegalArgumentException e) {
                    ValidationResult invalidPropertyKeywords = ValidationResult.builder().property(MessageProperties.MessageProperty.keywords.asFieldName()).message(e.getMessage()).build();
                    messageIds.forEach(messageId -> this.handleInvalidRequest(responseBuilder, (MessageId)messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyKeywords), patch));
                }
            });
        } else {
            messages.keySet().forEach(messageId -> this.handleInvalidRequest(responseBuilder, (MessageId)messageId, patch.getValidationErrors(), patch));
        }
    }

    private void update(Set<MailboxId> outboxes, MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession, SetMessagesResponse.Builder builder, Multimap<MessageId, ComposedMessageIdWithMetaData> metadata) {
        try {
            List messages = (List)Optional.ofNullable(metadata.get((Object)messageId)).map(ImmutableList::copyOf).orElse(ImmutableList.of());
            this.assertValidUpdate(messages, updateMessagePatch, outboxes);
            if (messages.isEmpty()) {
                this.addMessageIdNotFoundToResponse(messageId, builder);
            } else {
                this.setInMailboxes(messageId, updateMessagePatch, mailboxSession);
                Optional updateError = messages.stream().flatMap(message -> this.updateFlags(messageId, updateMessagePatch, mailboxSession, (ComposedMessageIdWithMetaData)message)).findAny();
                if (updateError.isPresent()) {
                    this.handleMessageUpdateException(messageId, builder, (Throwable)updateError.get());
                } else {
                    builder.updated((List<MessageId>)ImmutableList.of((Object)messageId));
                }
                this.sendMessageWhenOutboxInTargetMailboxIds(outboxes, messageId, updateMessagePatch, mailboxSession, builder);
            }
        }
        catch (DraftMessageMailboxUpdateException e) {
            this.handleDraftMessageMailboxUpdateException(messageId, builder, e);
        }
        catch (InvalidOutboxMoveException e) {
            ValidationResult invalidPropertyMailboxIds = ValidationResult.builder().property(MessageProperties.MessageProperty.mailboxIds.asFieldName()).message(e.getMessage()).build();
            this.handleInvalidRequest(builder, messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyMailboxIds), updateMessagePatch);
        }
        catch (OverQuotaException e) {
            builder.notUpdated(messageId, SetError.builder().type(SetError.Type.MAX_QUOTA_REACHED).description(e.getMessage()).build());
        }
        catch (IOException | MessagingException | MailboxException e) {
            this.handleMessageUpdateException(messageId, builder, e);
        }
        catch (IllegalArgumentException e) {
            ValidationResult invalidPropertyKeywords = ValidationResult.builder().property(MessageProperties.MessageProperty.keywords.asFieldName()).message(e.getMessage()).build();
            this.handleInvalidRequest(builder, messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyKeywords), updateMessagePatch);
        }
    }

    private void sendMessageWhenOutboxInTargetMailboxIds(Set<MailboxId> outboxes, MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession, SetMessagesResponse.Builder builder) throws MailboxException, MessagingException, IOException {
        if (this.isTargetingOutbox(outboxes, this.listTargetMailboxIds(updateMessagePatch))) {
            Optional maybeMessageToSend = this.messageIdManager.getMessage(messageId, FetchGroup.FULL_CONTENT, mailboxSession).stream().findFirst();
            if (maybeMessageToSend.isPresent()) {
                MessageResult messageToSend = (MessageResult)maybeMessageToSend.get();
                MailImpl mail = this.buildMailFromMessage(messageToSend);
                Optional<Username> fromUser = mail.getMaybeSender().asOptional().map(Username::fromMailAddress);
                this.assertUserCanSendFrom(mailboxSession.getUser(), fromUser);
                this.messageSender.sendMessage(messageId, (Mail)mail, mailboxSession);
                this.referenceUpdater.updateReferences(messageToSend.getHeaders(), mailboxSession);
            } else {
                this.addMessageIdNotFoundToResponse(messageId, builder);
            }
        }
    }

    @VisibleForTesting
    void assertUserCanSendFrom(Username connectedUser, Optional<Username> fromUser) throws MailboxSendingNotAllowedException {
        if (!fromUser.filter(from -> this.canSendFrom.userCanSendFrom(connectedUser, from)).isPresent()) {
            throw new MailboxSendingNotAllowedException(connectedUser, fromUser);
        }
        LOGGER.debug("{} is allowed to send a mail using {} identity", (Object)connectedUser.asString(), fromUser);
    }

    private void assertValidUpdate(List<ComposedMessageIdWithMetaData> messagesToBeUpdated, UpdateMessagePatch updateMessagePatch, Set<MailboxId> outboxMailboxes) {
        ImmutableList previousMailboxes = (ImmutableList)messagesToBeUpdated.stream().map(metaData -> metaData.getComposedMessageId().getMailboxId()).collect(Guavate.toImmutableList());
        List<MailboxId> targetMailboxes = this.getTargetedMailboxes((ImmutableList<MailboxId>)previousMailboxes, updateMessagePatch);
        boolean isDraft = messagesToBeUpdated.stream().map(ComposedMessageIdWithMetaData::getFlags).map(Keywords.lenientFactory()::fromFlags).reduce(new KeywordsCombiner()).orElse(Keywords.DEFAULT_VALUE).contains(Keyword.DRAFT);
        MessageMoves messageMoves = MessageMoves.builder().previousMailboxIds((Iterable)previousMailboxes).targetMailboxIds(targetMailboxes).build();
        boolean targetContainsOutbox = messageMoves.addedMailboxIds().stream().anyMatch(outboxMailboxes::contains);
        boolean targetIsOnlyOutbox = targetMailboxes.stream().allMatch(outboxMailboxes::contains);
        this.assertOutboxMoveTargetsOnlyOutBox(targetContainsOutbox, targetIsOnlyOutbox);
        this.assertOutboxMoveOriginallyHasDraftKeywordSet(targetContainsOutbox, isDraft);
    }

    private void assertOutboxMoveTargetsOnlyOutBox(boolean targetContainsOutbox, boolean targetIsOnlyOutbox) {
        if (targetContainsOutbox && !targetIsOnlyOutbox) {
            throw new InvalidOutboxMoveException("When moving a message to Outbox, only Outboxes mailboxes should be targeted.");
        }
    }

    private void assertOutboxMoveOriginallyHasDraftKeywordSet(boolean targetIsOutbox, boolean isDraft) {
        if (targetIsOutbox && !isDraft) {
            throw new InvalidOutboxMoveException("Only message with `$Draft` keyword can be moved to Outbox");
        }
    }

    private List<MailboxId> getTargetedMailboxes(ImmutableList<MailboxId> previousMailboxes, UpdateMessagePatch updateMessagePatch) {
        return (List)updateMessagePatch.getMailboxIds().map(ids -> (ImmutableList)ids.stream().map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(Guavate.toImmutableList())).orElse(previousMailboxes);
    }

    private MailImpl buildMailFromMessage(MessageResult message) throws MessagingException, IOException, MailboxException {
        return MailImpl.fromMimeMessage((String)message.getMessageId().serialize(), (MimeMessage)new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), message.getFullContent().getInputStream()));
    }

    private Set<MailboxId> listTargetMailboxIds(UpdateMessagePatch updateMessagePatch) {
        return (Set)updateMessagePatch.getMailboxIds().stream().flatMap(Collection::stream).map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(Guavate.toImmutableSet());
    }

    private boolean isTargetingOutbox(Set<MailboxId> outboxes, Set<MailboxId> targetMailboxIds) throws MailboxException {
        return targetMailboxIds.stream().anyMatch(outboxes::contains);
    }

    private Set<MailboxId> listMailboxIdsForRole(MailboxSession session, Role role) throws MailboxException {
        return (Set)Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(role, session.getUser())).toStream().map(MessageManager::getId).collect(Guavate.toImmutableSet());
    }

    private Stream<MailboxException> updateFlags(MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession, ComposedMessageIdWithMetaData message) {
        try {
            if (!updateMessagePatch.isFlagsIdentity()) {
                this.messageIdManager.setFlags(updateMessagePatch.applyToState(message.getFlags()), MessageManager.FlagsUpdateMode.REPLACE, messageId, (List)ImmutableList.of((Object)message.getComposedMessageId().getMailboxId()), mailboxSession);
            }
            return Stream.of(new MailboxException[0]);
        }
        catch (MailboxException e) {
            return Stream.of(e);
        }
    }

    private void setInMailboxes(MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession) throws MailboxException {
        Optional<List<String>> serializedMailboxIds = updateMessagePatch.getMailboxIds();
        if (serializedMailboxIds.isPresent()) {
            List mailboxIds = (List)serializedMailboxIds.get().stream().map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(Guavate.toImmutableList());
            this.messageIdManager.setInMailboxes(messageId, (Collection)mailboxIds, mailboxSession);
        }
    }

    private void addMessageIdNotFoundToResponse(MessageId messageId, SetMessagesResponse.Builder builder) {
        builder.notUpdated((Map<MessageId, SetError>)ImmutableMap.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.NOT_FOUND).properties((Set<MessageProperties.MessageProperty>)ImmutableSet.of((Object)MessageProperties.MessageProperty.id)).description("message not found").build()));
    }

    private SetMessagesResponse.Builder handleDraftMessageMailboxUpdateException(MessageId messageId, SetMessagesResponse.Builder builder, DraftMessageMailboxUpdateException e) {
        return builder.notUpdated((Map<MessageId, SetError>)ImmutableMap.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).properties(MessageProperties.MessageProperty.mailboxIds).description(e.getMessage()).build()));
    }

    private SetMessagesResponse.Builder handleMessageUpdateException(MessageId messageId, SetMessagesResponse.Builder builder, Throwable e) {
        LOGGER.error("An error occurred when updating a message", e);
        return builder.notUpdated((Map<MessageId, SetError>)ImmutableMap.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.ERROR).description("An error occurred when updating a message").build()));
    }

    private void handleInvalidRequest(SetMessagesResponse.Builder responseBuilder, MessageId messageId, ImmutableList<ValidationResult> validationErrors, UpdateMessagePatch patch) {
        LOGGER.warn("Invalid update request with patch {} for message #{}: {}", new Object[]{patch, messageId, validationErrors});
        String formattedValidationErrorMessage = validationErrors.stream().map(err -> err.getProperty() + ": " + err.getErrorMessage()).collect(Collectors.joining(", "));
        Set<MessageProperties.MessageProperty> properties = validationErrors.stream().flatMap(err -> MessageProperties.MessageProperty.find(err.getProperty())).collect(Collectors.toSet());
        responseBuilder.notUpdated((Map<MessageId, SetError>)ImmutableMap.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(properties).description(formattedValidationErrorMessage).build()));
    }
}

