/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class SetMessagesMethod
implements Method {
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("setMessages");
    private static final Method.Response.Name RESPONSE_NAME = Method.Response.name("messagesSet");
    private final Set<SetMessagesProcessor> messagesProcessors;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    SetMessagesMethod(Set<SetMessagesProcessor> messagesProcessors, MetricFactory metricFactory) {
        this.messagesProcessors = messagesProcessors;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return SetMessagesRequest.class;
    }

    @Override
    public Stream<JmapResponse> processToStream(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkArgument((boolean)(request instanceof SetMessagesRequest));
        SetMessagesRequest setMessagesRequest = (SetMessagesRequest)request;
        return (Stream)MDCBuilder.create().addContext("action", (Object)"SET_MESSAGES").addContext("accountId", setMessagesRequest.getAccountId()).addContext("create", setMessagesRequest.getCreate()).addContext("destroy", setMessagesRequest.getDestroy()).addContext("ifInState", setMessagesRequest.getIfInState()).wrapArround(() -> (Stream)this.metricFactory.decorateSupplierWithTimerMetricLogP99("JMAP-" + METHOD_NAME.getName(), () -> Stream.of(JmapResponse.builder().methodCallId(methodCallId).response(this.setMessagesResponse(setMessagesRequest, mailboxSession)).responseName(RESPONSE_NAME).build()))).get();
    }

    private SetMessagesResponse setMessagesResponse(SetMessagesRequest request, MailboxSession mailboxSession) {
        return this.messagesProcessors.stream().map(processor -> processor.process(request, mailboxSession)).reduce(SetMessagesResponse.builder(), (builder, resp) -> resp.mergeInto((SetMessagesResponse.Builder)builder), (builder1, builder2) -> builder2.build().mergeInto((SetMessagesResponse.Builder)builder1)).build();
    }
}

