/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jline.builtins.Builtins;
import org.jline.builtins.Completers;
import org.jline.builtins.ConsoleEngine;
import org.jline.builtins.ConsoleEngineImpl;
import org.jline.builtins.JlineCommandRegistry;
import org.jline.builtins.Options;
import org.jline.builtins.Styles;
import org.jline.builtins.SystemRegistry;
import org.jline.builtins.Widgets;
import org.jline.console.ArgDesc;
import org.jline.console.CmdDesc;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.console.ConfigurationPath;
import org.jline.keymap.KeyMap;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.reader.impl.completer.SystemCompleter;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;
import org.jline.utils.StyleResolver;

public class SystemRegistryImpl
implements SystemRegistry {
    private static final Class<?>[] BUILTIN_REGISTERIES = new Class[]{Builtins.class, ConsoleEngineImpl.class};
    private CommandRegistry[] commandRegistries;
    private Integer consoleId;
    private Parser parser;
    private ConfigurationPath configPath;
    private Map<String, CommandRegistry> subcommands = new HashMap<String, CommandRegistry>();
    private Map<Pipe, String> pipeName = new HashMap<Pipe, String>();
    private final Map<String, CommandMethods> commandExecute = new HashMap<String, CommandMethods>();
    private Map<String, List<String>> commandInfos = new HashMap<String, List<String>>();
    private Exception exception;
    private CommandOutputStream outputStream;
    private ScriptStore scriptStore = new ScriptStore();
    private NamesAndValues names = new NamesAndValues();
    private Supplier<Path> workDir;
    private SystemCompleter customSystemCompleter = new SystemCompleter();
    private AggregateCompleter customAggregateCompleter = new AggregateCompleter(new ArrayList<Completer>());

    public SystemRegistryImpl(Parser parser, Terminal terminal, Supplier<Path> workDir, ConfigurationPath configPath) {
        this.parser = parser;
        this.workDir = workDir;
        this.configPath = configPath;
        this.outputStream = new CommandOutputStream(terminal);
        this.pipeName.put(Pipe.FLIP, "|;");
        this.pipeName.put(Pipe.NAMED, "|");
        this.pipeName.put(Pipe.AND, "&&");
        this.pipeName.put(Pipe.OR, "||");
        this.commandExecute.put("exit", new CommandMethods(this::exit, this::exitCompleter));
        this.commandExecute.put("help", new CommandMethods(this::help, this::helpCompleter));
    }

    public void rename(Pipe pipe, String name) {
        if (name.matches("/w+") || this.pipeName.containsValue(name)) {
            throw new IllegalArgumentException();
        }
        this.pipeName.put(pipe, name);
    }

    @Override
    public Collection<String> getPipeNames() {
        return this.pipeName.values();
    }

    @Override
    public void setCommandRegistries(CommandRegistry ... commandRegistries) {
        this.commandRegistries = commandRegistries;
        for (int i = 0; i < commandRegistries.length; ++i) {
            if (commandRegistries[i] instanceof ConsoleEngine) {
                if (this.consoleId != null) {
                    throw new IllegalArgumentException();
                }
                this.consoleId = i;
                ((ConsoleEngine)commandRegistries[i]).setSystemRegistry(this);
                this.scriptStore = new ScriptStore((ConsoleEngine)commandRegistries[i]);
                this.names = new NamesAndValues(this.configPath);
                continue;
            }
            if (!(commandRegistries[i] instanceof SystemRegistry)) continue;
            throw new IllegalArgumentException();
        }
        SystemRegistry.add(this);
    }

    @Override
    public void initialize(File script) {
        if (this.consoleId != null) {
            try {
                this.consoleEngine().execute(script);
            }
            catch (Exception e) {
                this.trace(e);
            }
        }
    }

    @Override
    public Set<String> commandNames() {
        HashSet<String> out = new HashSet<String>();
        for (CommandRegistry r : this.commandRegistries) {
            out.addAll(r.commandNames());
        }
        out.addAll(this.localCommandNames());
        return out;
    }

    private Set<String> localCommandNames() {
        return this.commandExecute.keySet();
    }

    @Override
    public Map<String, String> commandAliases() {
        HashMap<String, String> out = new HashMap<String, String>();
        for (CommandRegistry r : this.commandRegistries) {
            out.putAll(r.commandAliases());
        }
        return out;
    }

    @Override
    public Object consoleOption(String name) {
        Object out = null;
        if (this.consoleId != null) {
            out = this.consoleEngine().consoleOption(name, null);
        }
        return out;
    }

    @Override
    public void register(String command, CommandRegistry subcommandRegistry) {
        this.subcommands.put(command, subcommandRegistry);
        this.commandExecute.put(command, new CommandMethods(this::subcommand, this::emptyCompleter));
    }

    private List<String> localCommandInfo(String command) {
        try {
            if (this.subcommands.containsKey(command)) {
                this.registryHelp(this.subcommands.get(command));
            } else {
                this.localExecute(command, new String[]{"--help"});
            }
        }
        catch (Options.HelpException e) {
            this.exception = null;
            return JlineCommandRegistry.compileCommandInfo(e.getMessage());
        }
        catch (Exception e) {
            this.trace(e);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> commandInfo(String command) {
        int id = this.registryId(command);
        List<Object> out = new ArrayList();
        if (id > -1) {
            if (!this.commandInfos.containsKey(command)) {
                this.commandInfos.put(command, this.commandRegistries[id].commandInfo(command));
            }
            out = this.commandInfos.get(command);
        } else if (this.scriptStore.hasScript(command)) {
            out = this.consoleEngine().commandInfo(command);
        } else if (this.isLocalCommand(command)) {
            out = this.localCommandInfo(command);
        }
        return out;
    }

    @Override
    public boolean hasCommand(String command) {
        return this.registryId(command) > -1 || this.isLocalCommand(command);
    }

    private boolean isLocalCommand(String command) {
        return this.commandExecute.containsKey(command);
    }

    private boolean isCommandOrScript(String command) {
        if (this.hasCommand(command)) {
            return true;
        }
        return this.scriptStore.hasScript(command);
    }

    public void addCompleter(Completer completer) {
        if (completer instanceof SystemCompleter) {
            SystemCompleter sc = (SystemCompleter)completer;
            if (sc.isCompiled()) {
                this.customAggregateCompleter.getCompleters().add(sc);
            } else {
                this.customSystemCompleter.add(sc);
            }
        } else {
            this.customAggregateCompleter.getCompleters().add(completer);
        }
    }

    @Override
    public SystemCompleter compileCompleters() {
        throw new IllegalStateException("Use method completer() to retrieve Completer!");
    }

    private SystemCompleter _compileCompleters() {
        SystemCompleter out = CommandRegistry.aggregateCompleters(this.commandRegistries);
        SystemCompleter local = new SystemCompleter();
        for (String command : this.commandExecute.keySet()) {
            if (this.subcommands.containsKey(command)) {
                for (Map.Entry<String, List<Completer>> entry : this.subcommands.get(command).compileCompleters().getCompleters().entrySet()) {
                    for (Completer cc : entry.getValue()) {
                        if (!(cc instanceof ArgumentCompleter)) {
                            throw new IllegalArgumentException();
                        }
                        List<Completer> cmps = ((ArgumentCompleter)cc).getCompleters();
                        cmps.add(0, NullCompleter.INSTANCE);
                        cmps.set(1, new StringsCompleter(entry.getKey()));
                        Completer last = cmps.get(cmps.size() - 1);
                        if (last instanceof Completers.OptionCompleter) {
                            ((Completers.OptionCompleter)last).setStartPos(cmps.size() - 1);
                            cmps.set(cmps.size() - 1, last);
                        }
                        local.add(command, (Completer)new ArgumentCompleter(cmps));
                    }
                }
                continue;
            }
            local.add(command, this.commandExecute.get(command).compileCompleter().apply(command));
        }
        local.add(this.customSystemCompleter);
        out.add(local);
        out.compile();
        return out;
    }

    @Override
    public Completer completer() {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(this._compileCompleters());
        completers.add(this.customAggregateCompleter);
        if (this.consoleId != null) {
            completers.addAll(this.consoleEngine().scriptCompleters());
            completers.add(new PipelineCompleter().doCompleter());
        }
        return new AggregateCompleter(completers);
    }

    private CmdDesc localCommandDescription(String command) {
        if (!this.isLocalCommand(command)) {
            throw new IllegalArgumentException();
        }
        try {
            this.localExecute(command, new String[]{"--help"});
        }
        catch (Options.HelpException e) {
            this.exception = null;
            return JlineCommandRegistry.compileCommandDescription(e.getMessage());
        }
        catch (Exception e) {
            this.trace(e);
        }
        return null;
    }

    @Override
    public CmdDesc commandDescription(String command) {
        return this.commandDescription(Arrays.asList(command));
    }

    @Override
    public CmdDesc commandDescription(List<String> args) {
        CmdDesc out = new CmdDesc(false);
        String command = args.get(0);
        int id = this.registryId(command);
        if (id > -1) {
            out = this.commandRegistries[id].commandDescription(args);
        } else if (this.scriptStore.hasScript(command)) {
            out = this.consoleEngine().commandDescription(command);
        } else if (this.isLocalCommand(command)) {
            out = this.localCommandDescription(command);
        }
        return out;
    }

    private CmdDesc commandDescription(CommandRegistry subreg) {
        ArrayList<AttributedString> main = new ArrayList<AttributedString>();
        HashMap<String, List<AttributedString>> options = new HashMap<String, List<AttributedString>>();
        StyleResolver helpStyle = Styles.helpStyle();
        for (String sc : new TreeSet<String>(subreg.commandNames())) {
            Iterator<String> iterator = subreg.commandInfo(sc).iterator();
            if (!iterator.hasNext()) continue;
            String info = iterator.next();
            main.add(Options.HelpException.highlightSyntax(sc + " -  " + info, helpStyle, true));
        }
        return new CmdDesc(main, ArgDesc.doArgNames(Arrays.asList("")), options);
    }

    @Override
    public CmdDesc commandDescription(Widgets.CmdLine line) {
        Object out = null;
        switch (line.getDescriptionType()) {
            case COMMAND: {
                String cmd = this.parser.getCommand(line.getArgs().get(0));
                if (!this.isCommandOrScript(cmd) || this.names.hasPipes(line.getArgs())) break;
                List<String> args = line.getArgs();
                if (this.subcommands.containsKey(cmd)) {
                    String c;
                    String string = c = args.size() > 1 ? args.get(1) : null;
                    out = c == null || this.subcommands.get(cmd).hasCommand(c) ? (c != null && c.equals("help") ? null : (c != null ? this.subcommands.get(cmd).commandDescription(c) : this.commandDescription(this.subcommands.get(cmd)))) : this.commandDescription(this.subcommands.get(cmd));
                    if (out == null) break;
                    ((CmdDesc)out).setSubcommand(true);
                    break;
                }
                args.set(0, cmd);
                out = this.commandDescription(args);
                break;
            }
        }
        return out;
    }

    @Override
    public Object invoke(String command, Object ... args) throws Exception {
        Object[] objectArray;
        Object out = null;
        command = ConsoleEngine.plainCommand(command);
        if (args == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = args;
        }
        args = objectArray;
        int id = this.registryId(command);
        if (id > -1) {
            out = this.commandRegistries[id].invoke(this.commandSession(), command, args);
        } else if (this.isLocalCommand(command)) {
            out = this.localExecute(command, args);
        } else if (this.consoleId != null) {
            out = this.consoleEngine().invoke(this.commandSession(), command, args);
        }
        return out;
    }

    @Override
    public Object execute(String command, String[] args) throws Exception {
        Object out = null;
        int id = this.registryId(command);
        if (id > -1) {
            out = this.commandRegistries[id].execute(this.commandSession(), command, args);
        } else if (this.isLocalCommand(command)) {
            out = this.localExecute(command, args);
        }
        return out;
    }

    public Object localExecute(String command, Object[] args) throws Exception {
        if (!this.isLocalCommand(command)) {
            throw new IllegalArgumentException();
        }
        Object out = this.commandExecute.get(command).executeFunction().apply(new CommandInput(command, args, this.commandSession()));
        if (this.exception != null) {
            throw this.exception;
        }
        return out;
    }

    @Override
    public Terminal terminal() {
        return this.commandSession().terminal();
    }

    private CommandRegistry.CommandSession commandSession() {
        return this.outputStream.getCommandSession();
    }

    private boolean isCommandAlias(String command) {
        if (this.consoleId == null || !this.parser.validCommandName(command) || !this.consoleEngine().hasAlias(command)) {
            return false;
        }
        String value = this.consoleEngine().getAlias(command).split("\\s+")[0];
        return !this.names.isPipe(value);
    }

    private String replaceCommandAlias(String variable, String command, String rawLine) {
        return variable == null ? rawLine.replaceFirst(command + "(\\b|$)", this.consoleEngine().getAlias(command)) : rawLine.replaceFirst("=" + command + "(\\b|$)", "=" + this.consoleEngine().getAlias(command));
    }

    private List<CommandData> compileCommandLine(String commandLine) {
        Map<Object, Object> customPipes;
        ArrayList<CommandData> out = new ArrayList<CommandData>();
        ArgsParser ap = new ArgsParser(this.parser);
        ap.parse(commandLine);
        List<String> ws = ap.args();
        Map<Object, Object> map = customPipes = this.consoleId != null ? this.consoleEngine().getPipes() : new HashMap();
        if (this.consoleId != null && ws.contains(this.pipeName.get((Object)Pipe.NAMED))) {
            StringBuilder sb = new StringBuilder();
            boolean trace = false;
            for (int i = 0; i < ws.size(); ++i) {
                if (ws.get(i).equals(this.pipeName.get((Object)Pipe.NAMED))) {
                    if (i + 1 < ws.size() && this.consoleEngine().hasAlias(ws.get(i + 1))) {
                        trace = true;
                        ArrayList<String> args = new ArrayList<String>();
                        String pipeAlias = this.consoleEngine().getAlias(ws.get(++i));
                        while (i < ws.size() - 1 && !this.names.isPipe(ws.get(i + 1), customPipes.keySet())) {
                            args.add(ws.get(++i));
                        }
                        for (int j = 0; j < args.size(); ++j) {
                            pipeAlias = pipeAlias.replaceAll("\\s\\$" + j + "\\b", " " + (String)args.get(j));
                            pipeAlias = pipeAlias.replaceAll("\\$\\{" + j + "(|:-.*)\\}", (String)args.get(j));
                        }
                        pipeAlias = pipeAlias.replaceAll("\\$\\{@\\}", this.consoleEngine().expandToList(args));
                        pipeAlias = pipeAlias.replaceAll("\\$@", this.consoleEngine().expandToList(args));
                        pipeAlias = pipeAlias.replaceAll("\\s+\\$\\d\\b", "");
                        pipeAlias = pipeAlias.replaceAll("\\s+\\$\\{\\d+\\}", "");
                        pipeAlias = pipeAlias.replaceAll("\\$\\{\\d+\\}", "");
                        Matcher matcher = Pattern.compile("\\$\\{\\d+:-(.*?)\\}").matcher(pipeAlias);
                        if (matcher.find()) {
                            pipeAlias = matcher.replaceAll("$1");
                        }
                        sb.append(pipeAlias);
                    } else {
                        sb.append(ws.get(i));
                    }
                } else {
                    sb.append(ws.get(i));
                }
                sb.append(" ");
            }
            ap.parse(sb.toString());
            if (trace) {
                this.consoleEngine().trace(ap.line());
            }
        }
        List<String> words = ap.args();
        String nextRawLine = ap.line();
        int first = 0;
        int last = words.size();
        ArrayList<String> pipes = new ArrayList<String>();
        String pipeSource = null;
        String rawLine = null;
        String pipeResult = null;
        if (!this.names.hasPipes(words)) {
            if (this.isCommandAlias(ap.command())) {
                nextRawLine = this.replaceCommandAlias(ap.variable(), ap.command(), nextRawLine);
            }
            out.add(new CommandData(ap, false, nextRawLine, ap.variable(), null, false, ""));
        } else {
            do {
                String subLine;
                String rawCommand = this.parser.getCommand(words.get(first));
                String command = ConsoleEngine.plainCommand(rawCommand);
                String variable = this.parser.getVariable(words.get(first));
                if (this.isCommandAlias(command)) {
                    ap.parse(this.replaceCommandAlias(variable, command, nextRawLine));
                    rawCommand = ap.rawCommand();
                    command = ap.command();
                    words = ap.args();
                    first = 0;
                }
                if (this.scriptStore.isConsoleScript(command) && !rawCommand.startsWith(":")) {
                    throw new IllegalArgumentException("Commands must be used in pipes with colon prefix!");
                }
                last = words.size();
                File file = null;
                boolean append = false;
                boolean pipeStart = false;
                boolean skipPipe = false;
                ArrayList<String> _words = new ArrayList<String>();
                for (int i = first; i < last; ++i) {
                    if (words.get(i).equals(">") || words.get(i).equals(">>")) {
                        pipes.add(words.get(i));
                        append = words.get(i).equals(">>");
                        if (i + 1 >= last) {
                            throw new IllegalArgumentException();
                        }
                        file = this.redirectFile(words.get(i + 1));
                        last = i + 1;
                        break;
                    }
                    if (words.get(i).equals(this.pipeName.get((Object)Pipe.FLIP))) {
                        if (variable != null || file != null || pipeResult != null || this.consoleId == null) {
                            throw new IllegalArgumentException();
                        }
                        pipes.add(words.get(i));
                        last = i;
                        variable = "_pipe" + (pipes.size() - 1);
                        break;
                    }
                    if (words.get(i).equals(this.pipeName.get((Object)Pipe.NAMED)) || words.get(i).matches("^.*[^a-zA-Z0-9 ].*$") && customPipes.containsKey(words.get(i))) {
                        String pipe = words.get(i);
                        if (pipe.equals(this.pipeName.get((Object)Pipe.NAMED))) {
                            if (i + 1 >= last) {
                                throw new IllegalArgumentException("Pipe is NULL!");
                            }
                            pipe = words.get(i + 1);
                            if (!pipe.matches("\\w+") || !customPipes.containsKey(pipe)) {
                                throw new IllegalArgumentException("Unknown or illegal pipe name: " + pipe);
                            }
                        }
                        pipes.add(pipe);
                        last = i;
                        if (pipeSource != null) break;
                        pipeSource = "_pipe" + (pipes.size() - 1);
                        pipeResult = variable;
                        variable = pipeSource;
                        pipeStart = true;
                        break;
                    }
                    if (words.get(i).equals(this.pipeName.get((Object)Pipe.OR)) || words.get(i).equals(this.pipeName.get((Object)Pipe.AND))) {
                        if (variable != null || pipeSource != null) {
                            pipes.add(words.get(i));
                        } else if (pipes.size() > 0 && (((String)pipes.get(pipes.size() - 1)).equals(">") || ((String)pipes.get(pipes.size() - 1)).equals(">>"))) {
                            pipes.remove(pipes.size() - 1);
                            ((CommandData)out.get(out.size() - 1)).setPipe(words.get(i));
                            skipPipe = true;
                        } else {
                            pipes.add(words.get(i));
                            pipeSource = "_pipe" + (pipes.size() - 1);
                            pipeResult = variable;
                            variable = pipeSource;
                            pipeStart = true;
                        }
                        last = i;
                        break;
                    }
                    _words.add(words.get(i));
                }
                if (last == words.size()) {
                    pipes.add("END_PIPE");
                } else if (skipPipe) {
                    first = last + 1;
                    continue;
                }
                String string = subLine = last < words.size() || first > 0 ? _words.stream().collect(Collectors.joining(" ")) : ap.line();
                if (last + 1 < words.size()) {
                    nextRawLine = words.subList(last + 1, words.size()).stream().collect(Collectors.joining(" "));
                }
                boolean done = true;
                boolean statement = false;
                ArrayList<String> arglist = new ArrayList<String>();
                if (_words.size() > 0) {
                    arglist.addAll(_words.subList(1, _words.size()));
                }
                if (rawLine != null || pipes.size() > 1 && customPipes.containsKey(pipes.get(pipes.size() - 2))) {
                    done = false;
                    if (rawLine == null) {
                        rawLine = pipeSource;
                    }
                    if (customPipes.containsKey(pipes.get(pipes.size() - 2))) {
                        List fixes = (List)customPipes.get(pipes.get(pipes.size() - 2));
                        if (((String)pipes.get(pipes.size() - 2)).matches("\\w+")) {
                            int idx = subLine.indexOf(" ");
                            subLine = idx > 0 ? subLine.substring(idx + 1) : "";
                        }
                        rawLine = rawLine + (String)fixes.get(0) + (this.consoleId != null ? this.consoleEngine().expandCommandLine(subLine) : subLine) + (String)fixes.get(1);
                        statement = true;
                    }
                    if (((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.FLIP)) || ((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.AND)) || ((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.OR))) {
                        done = true;
                        pipeSource = null;
                        if (variable != null) {
                            rawLine = variable + " = " + rawLine;
                        }
                    }
                    if (last + 1 >= words.size() || file != null) {
                        done = true;
                        pipeSource = null;
                        if (pipeResult != null) {
                            rawLine = pipeResult + " = " + rawLine;
                        }
                    }
                } else if (((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.FLIP)) || pipeStart) {
                    if (pipeStart && pipeResult != null) {
                        subLine = subLine.substring(subLine.indexOf("=") + 1);
                    }
                    rawLine = this.flipArgument(command, subLine, pipes, arglist);
                    rawLine = variable + "=" + rawLine;
                } else {
                    rawLine = this.flipArgument(command, subLine, pipes, arglist);
                }
                if (done) {
                    out.add(new CommandData(ap, statement, rawLine, variable, file, append, (String)pipes.get(pipes.size() - 1)));
                    if (((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.AND)) || ((String)pipes.get(pipes.size() - 1)).equals(this.pipeName.get((Object)Pipe.OR))) {
                        pipeSource = null;
                        pipeResult = null;
                    }
                    rawLine = null;
                }
                first = last + 1;
            } while (first < words.size());
        }
        return out;
    }

    private File redirectFile(String name) {
        File out = null;
        out = name.equals("null") ? (OSUtils.IS_WINDOWS ? new File("NUL") : new File("/dev/null")) : new File(name);
        return out;
    }

    private String flipArgument(String command, String subLine, List<String> pipes, List<String> arglist) {
        String out = null;
        if (pipes.size() > 1 && pipes.get(pipes.size() - 2).equals(this.pipeName.get((Object)Pipe.FLIP))) {
            String s = this.isCommandOrScript(command) ? "$" : "";
            out = subLine + " " + s + "_pipe" + (pipes.size() - 2);
            if (!command.isEmpty()) {
                arglist.add(s + "_pipe" + (pipes.size() - 2));
            }
        } else {
            out = subLine;
        }
        return out;
    }

    private Object execute(String command, String rawLine, String[] args) throws Exception {
        if (!this.parser.validCommandName(command)) {
            throw new UnknownCommandException();
        }
        Object out = null;
        if (this.isLocalCommand(command)) {
            out = this.localExecute(command, this.consoleId != null ? this.consoleEngine().expandParameters(args) : args);
        } else {
            int id = this.registryId(command);
            if (id > -1) {
                Object[] _args = this.consoleId != null ? this.consoleEngine().expandParameters(args) : (Object[])args;
                out = this.commandRegistries[id].invoke(this.outputStream.getCommandSession(), command, _args);
            } else if (this.scriptStore.hasScript(command)) {
                out = this.consoleEngine().execute(command, rawLine, args);
            } else {
                throw new UnknownCommandException();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object execute(String line) throws Exception {
        if (line.isEmpty() || line.trim().startsWith("#")) {
            return null;
        }
        long start = new Date().getTime();
        Object out = null;
        boolean statement = false;
        boolean postProcessed = false;
        int errorCount = 0;
        this.scriptStore.refresh();
        List<CommandData> cmds = this.compileCommandLine(line);
        for (int i = 0; i < cmds.size(); ++i) {
            CommandData cmd = cmds.get(i);
            if (cmd.file() != null && this.scriptStore.isConsoleScript(cmd.command())) {
                throw new IllegalArgumentException("Console script output cannot be redirected!");
            }
            try {
                this.outputStream.closeAndReset();
                if (this.consoleId != null && !this.consoleEngine().isExecuting()) {
                    this.trace(cmd);
                }
                this.exception = null;
                statement = false;
                postProcessed = false;
                if (cmd.variable() != null || cmd.file() != null) {
                    if (cmd.file() != null) {
                        this.outputStream.redirect(cmd.file(), cmd.append());
                    } else if (this.consoleId != null) {
                        this.outputStream.redirect();
                    }
                    this.outputStream.open();
                }
                boolean consoleScript = false;
                try {
                    out = this.execute(cmd.command(), cmd.rawLine(), cmd.args());
                }
                catch (UnknownCommandException e) {
                    consoleScript = true;
                }
                if (this.consoleId != null) {
                    if (consoleScript) {
                        boolean bl = statement = cmd.command().isEmpty() || !this.scriptStore.hasScript(cmd.command());
                        if (statement && this.outputStream.isByteStream()) {
                            this.outputStream.closeAndReset();
                        }
                        out = this.consoleEngine().execute(cmd.command(), cmd.rawLine(), cmd.args());
                    }
                    if (cmd.pipe().equals(this.pipeName.get((Object)Pipe.OR)) || cmd.pipe().equals(this.pipeName.get((Object)Pipe.AND))) {
                        boolean success;
                        ConsoleEngine.ExecutionResult er = this.postProcess(cmd, statement, out);
                        postProcessed = true;
                        this.consoleEngine().println(er.result());
                        out = null;
                        boolean bl = success = er.status() == 0;
                        if (cmd.pipe().equals(this.pipeName.get((Object)Pipe.OR)) && success || cmd.pipe().equals(this.pipeName.get((Object)Pipe.AND)) && !success) {
                            if (postProcessed || this.consoleId == null) break;
                            out = this.postProcess(cmd, statement, out).result();
                            break;
                        }
                    }
                }
                if (postProcessed || this.consoleId == null) continue;
                out = this.postProcess(cmd, statement, out).result();
                continue;
            }
            catch (Options.HelpException e) {
                this.trace(e);
                if (postProcessed || this.consoleId == null) continue;
                out = this.postProcess(cmd, statement, out).result();
                continue;
            }
            catch (Exception e2) {
                ++errorCount;
                if (!cmd.pipe().equals(this.pipeName.get((Object)Pipe.OR))) {
                    throw e2;
                }
                this.trace(e2);
                postProcessed = true;
                if (postProcessed || this.consoleId == null) continue;
                out = this.postProcess(cmd, statement, out).result();
                continue;
                {
                    catch (Throwable throwable) {
                        if (!postProcessed && this.consoleId != null) {
                            out = this.postProcess(cmd, statement, out).result();
                        }
                        throw throwable;
                    }
                }
            }
        }
        if (errorCount == 0) {
            this.names.extractNames(line);
        }
        Log.debug("execute: ", new Date().getTime() - start, " msec");
        return out;
    }

    private ConsoleEngine.ExecutionResult postProcess(CommandData cmd, boolean statement, Object result) {
        ConsoleEngine.ExecutionResult out = new ConsoleEngine.ExecutionResult(result != null ? 0 : 1, result);
        if (cmd.file() != null) {
            int status = 1;
            if (cmd.file().exists()) {
                long delta = new Date().getTime() - cmd.file().lastModified();
                status = delta < 100L ? 0 : 1;
            }
            out = new ConsoleEngine.ExecutionResult(status, result);
        } else if (!statement) {
            this.outputStream.flush();
            this.outputStream.close();
            out = this.consoleEngine().postProcess(cmd.rawLine(), result, this.outputStream.getOutput());
            this.outputStream.reset();
        } else if (cmd.variable() != null) {
            out = this.consoleEngine().hasVariable(cmd.variable()) ? this.consoleEngine().postProcess(this.consoleEngine().getVariable(cmd.variable())) : this.consoleEngine().postProcess(result);
            if (!cmd.variable().startsWith("_")) {
                out = new ConsoleEngine.ExecutionResult(out.status(), null);
            }
        } else {
            out = this.consoleEngine().postProcess(result);
        }
        return out;
    }

    @Override
    public void cleanUp() {
        if (this.outputStream.isRedirecting()) {
            this.outputStream.closeAndReset();
        }
        if (this.consoleId != null) {
            this.consoleEngine().purge();
        }
    }

    private void trace(CommandData commandData) {
        if (this.consoleId != null) {
            this.consoleEngine().trace(commandData);
        } else {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.append(commandData.rawLine(), AttributedStyle.DEFAULT.foreground(3)).println(this.terminal());
        }
    }

    @Override
    public void trace(Exception exception) {
        if (this.outputStream.isRedirecting()) {
            this.outputStream.closeAndReset();
        }
        if (this.consoleId != null) {
            this.consoleEngine().putVariable("exception", exception);
            this.consoleEngine().trace(exception);
        } else {
            this.trace(false, exception);
        }
    }

    @Override
    public void trace(boolean stack, Exception exception) {
        if (exception instanceof Options.HelpException) {
            Options.HelpException.highlight(exception.getMessage(), Styles.helpStyle()).print(this.terminal());
        } else if (stack) {
            exception.printStackTrace();
        } else {
            String message = exception.getMessage();
            AttributedStringBuilder asb = new AttributedStringBuilder();
            if (message != null) {
                String m = exception.getClass().getSimpleName() + ": " + message;
                asb.append(m, AttributedStyle.DEFAULT.foreground(1));
            } else {
                asb.append("Caught exception: ", AttributedStyle.DEFAULT.foreground(1));
                asb.append(exception.getClass().getCanonicalName(), AttributedStyle.DEFAULT.foreground(1));
            }
            asb.toAttributedString().println(this.terminal());
            Log.debug("Stack: ", exception);
        }
    }

    @Override
    public void close() {
        this.names.save();
    }

    private ConsoleEngine consoleEngine() {
        return this.consoleId != null ? (ConsoleEngine)this.commandRegistries[this.consoleId] : null;
    }

    private boolean isBuiltinRegistry(CommandRegistry registry) {
        for (Class<?> c : BUILTIN_REGISTERIES) {
            if (c != registry.getClass()) continue;
            return true;
        }
        return false;
    }

    private void printHeader(String header) {
        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(2);
        asb.append("\t");
        asb.append(header, Options.HelpException.defaultStyle().resolve(".ti"));
        asb.append(":");
        asb.toAttributedString().println(this.terminal());
    }

    private void printCommandInfo(String command, String info, int max) {
        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(Arrays.asList(4, max + 4));
        asb.append("\t");
        asb.append(command, Options.HelpException.defaultStyle().resolve(".co"));
        asb.append("\t");
        asb.append(info);
        asb.setLength(this.terminal().getWidth());
        asb.toAttributedString().println(this.terminal());
    }

    private void printCommands(Collection<String> commands, int max) {
        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(Arrays.asList(4, max + 4));
        int col = 0;
        asb.append("\t");
        col += 4;
        boolean done = false;
        for (String c : commands) {
            asb.append(c, Options.HelpException.defaultStyle().resolve(".co"));
            asb.append("\t");
            if ((col += max) + max > this.terminal().getWidth()) {
                asb.toAttributedString().println(this.terminal());
                asb = new AttributedStringBuilder().tabs(Arrays.asList(4, max + 4));
                col = 0;
                asb.append("\t");
                col += 4;
                done = true;
                continue;
            }
            done = false;
        }
        if (!done) {
            asb.toAttributedString().println(this.terminal());
        }
        this.terminal().flush();
    }

    private String doCommandInfo(List<String> info) {
        return info.size() > 0 ? info.get(0) : " ";
    }

    private boolean isInTopics(List<String> args, String name) {
        return args.isEmpty() || args.contains(name);
    }

    private Options parseOptions(String[] usage, Object[] args) throws Options.HelpException {
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        return opt;
    }

    private Object help(CommandInput input) {
        String[] usage = new String[]{"help -  command help", "Usage: help [TOPIC...]", "  -? --help                       Displays command help"};
        try {
            Options opt = this.parseOptions(usage, input.args());
            boolean doTopic = false;
            if (!opt.args().isEmpty() && opt.args().size() == 1) {
                try {
                    String[] args = new String[]{"--help"};
                    String command = opt.args().get(0);
                    this.execute(command, command + " " + args[0], args);
                }
                catch (UnknownCommandException e) {
                    doTopic = true;
                }
                catch (Exception e) {
                    this.exception = e;
                }
            } else {
                doTopic = true;
            }
            if (doTopic) {
                this.helpTopic(opt.args());
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        return null;
    }

    private void helpTopic(List<String> topics) {
        Set<String> commands = this.commandNames();
        commands.addAll(this.scriptStore.getScripts());
        boolean withInfo = commands.size() < this.terminal().getHeight() || !topics.isEmpty();
        int max = Collections.max(commands, Comparator.comparing(String::length)).length() + 1;
        TreeMap<String, String> builtinCommands = new TreeMap<String, String>();
        TreeMap<String, String> systemCommands = new TreeMap<String, String>();
        for (CommandRegistry commandRegistry : this.commandRegistries) {
            if (!this.isBuiltinRegistry(commandRegistry)) continue;
            for (String c : commandRegistry.commandNames()) {
                builtinCommands.put(c, this.doCommandInfo(this.commandInfo(c)));
            }
        }
        for (String string : this.localCommandNames()) {
            systemCommands.put(string, this.doCommandInfo(this.commandInfo(string)));
            this.exception = null;
        }
        if (this.isInTopics(topics, "System")) {
            this.printHeader("System");
            if (withInfo) {
                for (Map.Entry entry : systemCommands.entrySet()) {
                    this.printCommandInfo((String)entry.getKey(), (String)entry.getValue(), max);
                }
            } else {
                this.printCommands(systemCommands.keySet(), max);
            }
        }
        if (this.isInTopics(topics, "Builtins")) {
            this.printHeader("Builtins");
            if (withInfo) {
                for (Map.Entry entry : builtinCommands.entrySet()) {
                    this.printCommandInfo((String)entry.getKey(), (String)entry.getValue(), max);
                }
            } else {
                this.printCommands(builtinCommands.keySet(), max);
            }
        }
        for (CommandRegistry commandRegistry : this.commandRegistries) {
            if (this.isBuiltinRegistry(commandRegistry) || !this.isInTopics(topics, commandRegistry.name())) continue;
            TreeSet<String> cmds = new TreeSet<String>(commandRegistry.commandNames());
            this.printHeader(commandRegistry.name());
            if (withInfo) {
                for (String c : cmds) {
                    this.printCommandInfo(c, this.doCommandInfo(this.commandInfo(c)), max);
                }
                continue;
            }
            this.printCommands(cmds, max);
        }
        if (this.consoleId != null && this.isInTopics(topics, "Scripts")) {
            this.printHeader("Scripts");
            if (withInfo) {
                for (String string : this.scriptStore.getScripts()) {
                    this.printCommandInfo(string, this.doCommandInfo(this.commandInfo(string)), max);
                }
            } else {
                this.printCommands(this.scriptStore.getScripts(), max);
            }
        }
        this.terminal().flush();
    }

    private Object exit(CommandInput input) {
        String[] usage = new String[]{"exit -  exit from app/script", "Usage: exit [OBJECT]", "  -? --help                       Displays command help"};
        try {
            Options opt = this.parseOptions(usage, input.args());
            if (!opt.args().isEmpty() && this.consoleId != null) {
                try {
                    Object[] ret = this.consoleEngine().expandParameters(opt.args().toArray(new String[0]));
                    this.consoleEngine().putVariable("_return", ret.length == 1 ? ret[0] : ret);
                }
                catch (Exception e) {
                    this.trace(e);
                }
            }
            this.exception = new EndOfFileException();
        }
        catch (Exception e) {
            this.exception = e;
        }
        return null;
    }

    private void registryHelp(CommandRegistry registry) throws Exception {
        ArrayList<Integer> tabs = new ArrayList<Integer>();
        tabs.add(0);
        tabs.add(9);
        int max = registry.commandNames().stream().map(String::length).max(Integer::compareTo).get();
        tabs.add(10 + max);
        AttributedStringBuilder sb = new AttributedStringBuilder().tabs(tabs);
        sb.append(" -  ");
        sb.append(registry.name());
        sb.append(" registry");
        sb.append("\n");
        boolean first = true;
        for (String c : new TreeSet<String>(registry.commandNames())) {
            if (first) {
                sb.append("Summary:");
                first = false;
            }
            sb.append("\t");
            sb.append(c);
            sb.append("\t");
            sb.append(registry.commandInfo(c).get(0));
            sb.append("\n");
        }
        throw new Options.HelpException(sb.toString());
    }

    private Object subcommand(CommandInput input) {
        Object out = null;
        try {
            if (input.args().length > 0 && this.subcommands.get(input.command()).hasCommand(input.args()[0])) {
                out = this.subcommands.get(input.command()).invoke(input.session(), input.args()[0], input.xargs().length > 1 ? Arrays.copyOfRange(input.xargs(), 1, input.xargs().length) : new Object[]{});
            } else {
                this.registryHelp(this.subcommands.get(input.command()));
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        return out;
    }

    private List<Completers.OptDesc> commandOptions(String command) {
        try {
            this.localExecute(command, new String[]{"--help"});
        }
        catch (Options.HelpException e) {
            this.exception = null;
            return JlineCommandRegistry.compileCommandOptions(e.getMessage());
        }
        catch (Exception e) {
            this.trace(e);
        }
        return null;
    }

    private List<String> registryNames() {
        ArrayList<String> out = new ArrayList<String>();
        out.add("System");
        out.add("Builtins");
        if (this.consoleId != null) {
            out.add("Scripts");
        }
        for (CommandRegistry r : this.commandRegistries) {
            if (this.isBuiltinRegistry(r)) continue;
            out.add(r.name());
        }
        out.addAll(this.commandNames());
        out.addAll(this.scriptStore.getScripts());
        return out;
    }

    private List<Completer> emptyCompleter(String command) {
        return new ArrayList<Completer>();
    }

    private List<Completer> helpCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        ArrayList<Completer> params = new ArrayList<Completer>();
        params.add(new StringsCompleter(this::registryNames));
        params.add(NullCompleter.INSTANCE);
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter(params, this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> exitCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)));
        return completers;
    }

    private int registryId(String command) {
        for (int i = 0; i < this.commandRegistries.length; ++i) {
            if (!this.commandRegistries[i].hasCommand(command)) continue;
            return i;
        }
        return -1;
    }

    private class NamesAndValues {
        private final String[] delims = new String[]{"&", "\\|", "\\{", "\\}", "\\[", "\\]", "\\(", "\\)", "\\+", "-", "\\*", "=", ">", "<", "~", "!", ":", ",", ";"};
        private Path fileNames;
        private Map<String, List<String>> names = new HashMap<String, List<String>>();
        private List<String> namedPipes;

        public NamesAndValues() {
        }

        public NamesAndValues(ConfigurationPath configPath) {
            this.names.put("fields", new ArrayList());
            this.names.put("values", new ArrayList());
            this.names.put("quoted", new ArrayList());
            this.names.put("options", new ArrayList());
            if (configPath != null) {
                try {
                    this.fileNames = configPath.getUserConfig("pipeline-names.json", true);
                    Map temp = (Map)SystemRegistryImpl.this.consoleEngine().slurp(this.fileNames);
                    for (Map.Entry entry : temp.entrySet()) {
                        this.names.get(entry.getKey()).addAll((Collection)entry.getValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean isPipe(String arg) {
            Map<Object, Object> customPipes = SystemRegistryImpl.this.consoleId != null ? SystemRegistryImpl.this.consoleEngine().getPipes() : new HashMap();
            return this.isPipe(arg, customPipes.keySet());
        }

        public boolean hasPipes(Collection<String> args) {
            Map<Object, Object> customPipes = SystemRegistryImpl.this.consoleId != null ? SystemRegistryImpl.this.consoleEngine().getPipes() : new HashMap();
            for (String a : args) {
                if (!this.isPipe(a, customPipes.keySet()) && !a.contains(">") && !a.contains(">>")) continue;
                return true;
            }
            return false;
        }

        private boolean isPipe(String arg, Set<String> pipes) {
            return SystemRegistryImpl.this.pipeName.containsValue(arg) || pipes.contains(arg);
        }

        public void extractNames(String line) {
            if (SystemRegistryImpl.this.parser.getCommand(line).equals("pipe")) {
                return;
            }
            ArgsParser ap = new ArgsParser(SystemRegistryImpl.this.parser);
            ap.parse(line);
            List<String> args = ap.args();
            int pipeId = 0;
            for (String a : args) {
                if (this.isPipe(a)) break;
                ++pipeId;
            }
            if (pipeId < args.size()) {
                StringBuilder sb = new StringBuilder();
                int redirectPipe = -1;
                for (int i = pipeId + 1; i < args.size(); ++i) {
                    String[] arg = args.get(i);
                    if (!(this.isPipe((String)arg) || this.namedPipes().contains(arg) || arg.matches("\\d+") || redirectPipe == i - 1)) {
                        if (arg.equals(">") || arg.equals(">>")) {
                            redirectPipe = i;
                            continue;
                        }
                        if (arg.matches("\\w+(\\(\\)){0,1}")) {
                            this.addValues((String)arg);
                            continue;
                        }
                        if (arg.matches("--\\w+(=.*|)$") && arg.length() > 4) {
                            int idx = arg.indexOf(61);
                            if (idx > 0) {
                                if (idx > 4) {
                                    this.addOptions(arg.substring(2, idx));
                                }
                                sb.append(arg.substring(idx + 1));
                                sb.append(" ");
                                continue;
                            }
                            if (idx != -1) continue;
                            this.addOptions(arg.substring(2));
                            continue;
                        }
                        sb.append((String)arg);
                        sb.append(" ");
                        continue;
                    }
                    redirectPipe = -1;
                }
                if (sb.length() > 0) {
                    String[] words;
                    String rest = sb.toString();
                    for (String d : this.delims) {
                        rest = rest.replaceAll(d, " ");
                    }
                    for (String w : words = rest.split("\\s+")) {
                        if (w.length() < 3 || w.matches("\\d+")) continue;
                        if (this.isQuoted(w)) {
                            this.addQuoted(w.substring(1, w.length() - 1));
                            continue;
                        }
                        if (w.contains(".")) {
                            for (String f : w.split("\\.")) {
                                if (f.matches("\\d+") || !f.matches("\\w+")) continue;
                                this.addFields(f);
                            }
                            continue;
                        }
                        if (!w.matches("\\w+")) continue;
                        this.addValues(w);
                    }
                }
            }
            this.namedPipes = null;
        }

        public String encloseBy(String param) {
            boolean quoted;
            boolean bl = quoted = param.length() > 0 && (param.startsWith("\"") || param.startsWith("'") || param.startsWith("/"));
            if (quoted && param.length() > 1) {
                quoted = !param.endsWith(Character.toString(param.charAt(0)));
            }
            return quoted ? Character.toString(param.charAt(0)) : "";
        }

        private boolean isQuoted(String word) {
            return word.length() > 1 && (word.startsWith("\"") && word.endsWith("\"") || word.startsWith("'") && word.endsWith("'") || word.startsWith("/") && word.endsWith("/"));
        }

        public int indexOfLastDelim(String word) {
            int out = -1;
            for (String d : this.delims) {
                int x = word.lastIndexOf(d.replace("\\", ""));
                if (x <= out) continue;
                out = x;
            }
            return out;
        }

        private void addFields(String field) {
            this.add("fields", field);
        }

        private void addValues(String arg) {
            this.add("values", arg);
        }

        private void addQuoted(String arg) {
            this.add("quoted", arg);
        }

        private void addOptions(String arg) {
            this.add("options", arg);
        }

        private void add(String where, String value) {
            if (value.length() < 3) {
                return;
            }
            this.names.get(where).remove(value);
            this.names.get(where).add(0, value);
        }

        public List<String> namedPipes() {
            if (this.namedPipes == null) {
                this.namedPipes = SystemRegistryImpl.this.consoleId != null ? SystemRegistryImpl.this.consoleEngine().getNamedPipes() : new ArrayList();
            }
            return this.namedPipes;
        }

        public List<String> values() {
            return this.names.get("values");
        }

        public List<String> fields() {
            return this.names.get("fields");
        }

        public List<String> quoted() {
            return this.names.get("quoted");
        }

        public List<String> options() {
            return this.names.get("options");
        }

        private Set<String> fieldsAndValues() {
            HashSet<String> out = new HashSet<String>();
            out.addAll(this.fields());
            out.addAll(this.values());
            return out;
        }

        private void truncate(String where, int maxSize) {
            if (this.names.get(where).size() > maxSize) {
                this.names.put(where, this.names.get(where).subList(0, maxSize));
            }
        }

        public void save() {
            if (SystemRegistryImpl.this.consoleEngine() != null && this.fileNames != null) {
                int maxSize = SystemRegistryImpl.this.consoleEngine().consoleOption("maxValueNames", 100);
                this.truncate("fields", maxSize);
                this.truncate("values", maxSize);
                this.truncate("quoted", maxSize);
                this.truncate("options", maxSize);
                SystemRegistryImpl.this.consoleEngine().persist(this.fileNames, this.names);
            }
        }
    }

    private class PipelineCompleter
    implements Completer {
        public Completer doCompleter() {
            ArgumentCompleter out = new ArgumentCompleter(this);
            out.setStrict(false);
            return out;
        }

        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            assert (commandLine != null);
            assert (candidates != null);
            if (commandLine.wordIndex() < 2 || !SystemRegistryImpl.this.names.hasPipes(commandLine.words())) {
                return;
            }
            String pWord = commandLine.words().get(commandLine.wordIndex() - 1);
            if (pWord.equals(SystemRegistryImpl.this.pipeName.get((Object)Pipe.NAMED))) {
                for (String name : SystemRegistryImpl.this.names.namedPipes()) {
                    candidates.add(new Candidate(name, name, null, null, null, null, true));
                }
            } else if (pWord.equals(">") || pWord.equals(">>")) {
                Completers.FilesCompleter c = new Completers.FilesCompleter(SystemRegistryImpl.this.workDir);
                c.complete(reader, commandLine, candidates);
            } else {
                String buffer;
                String param = buffer = commandLine.word().substring(0, commandLine.wordCursor());
                String curBuf = "";
                int lastDelim = SystemRegistryImpl.this.names.indexOfLastDelim(buffer);
                if (lastDelim > -1) {
                    param = buffer.substring(lastDelim + 1);
                    curBuf = buffer.substring(0, lastDelim + 1);
                }
                if (curBuf.startsWith("--") && !curBuf.contains("=")) {
                    this.doCandidates(candidates, SystemRegistryImpl.this.names.options(), curBuf, "", param);
                } else if (param.length() == 0) {
                    this.doCandidates(candidates, SystemRegistryImpl.this.names.fieldsAndValues(), curBuf, "", "");
                } else if (param.contains(".")) {
                    int point = buffer.lastIndexOf(".");
                    param = buffer.substring(point + 1);
                    curBuf = buffer.substring(0, point + 1);
                    this.doCandidates(candidates, SystemRegistryImpl.this.names.fields(), curBuf, "", param);
                } else if (SystemRegistryImpl.this.names.encloseBy(param).length() == 1) {
                    String postFix = SystemRegistryImpl.this.names.encloseBy(param);
                    param = buffer.substring(++lastDelim + 1);
                    curBuf = buffer.substring(0, lastDelim + 1);
                    this.doCandidates(candidates, SystemRegistryImpl.this.names.quoted(), curBuf, postFix, param);
                } else {
                    this.doCandidates(candidates, SystemRegistryImpl.this.names.fieldsAndValues(), curBuf, "", param);
                }
            }
        }

        private void doCandidates(List<Candidate> candidates, Collection<String> fields, String curBuf, String postFix, String hint) {
            if (fields == null) {
                return;
            }
            for (String s : fields) {
                if (s == null || !s.startsWith(hint)) continue;
                candidates.add(new Candidate(AttributedString.stripAnsi(curBuf + s + postFix), s, null, null, null, null, false));
            }
        }
    }

    private static class UnknownCommandException
    extends Exception {
        private UnknownCommandException() {
        }
    }

    private static class ScriptStore {
        ConsoleEngine engine;
        Map<String, Boolean> scripts = new HashMap<String, Boolean>();

        public ScriptStore() {
        }

        public ScriptStore(ConsoleEngine engine) {
            this.engine = engine;
        }

        public void refresh() {
            if (this.engine != null) {
                this.scripts = this.engine.scripts();
            }
        }

        public boolean hasScript(String name) {
            return this.scripts.containsKey(name);
        }

        public boolean isConsoleScript(String name) {
            return this.scripts.getOrDefault(name, false);
        }

        public Set<String> getScripts() {
            return this.scripts.keySet();
        }
    }

    protected static class CommandData {
        private String rawLine;
        private String command;
        private String[] args;
        private File file;
        private boolean append;
        private String variable;
        private String pipe;

        public CommandData(ArgsParser parser, boolean statement, String rawLine, String variable, File file, boolean append, String pipe) {
            this.rawLine = rawLine;
            this.variable = variable;
            this.file = file;
            this.append = append;
            this.pipe = pipe;
            this.args = new String[0];
            this.command = "";
            if (!statement) {
                parser.parse(rawLine);
                this.command = parser.command();
                if (parser.args().size() > 1) {
                    this.args = new String[parser.args().size() - 1];
                    for (int i = 1; i < parser.args().size(); ++i) {
                        this.args[i - 1] = parser.unquote(parser.args().get(i));
                    }
                }
            }
        }

        public void setPipe(String pipe) {
            this.pipe = pipe;
        }

        public File file() {
            return this.file;
        }

        public boolean append() {
            return this.append;
        }

        public String variable() {
            return this.variable;
        }

        public String command() {
            return this.command;
        }

        public String[] args() {
            return this.args;
        }

        public String rawLine() {
            return this.rawLine;
        }

        public String pipe() {
            return this.pipe;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("rawLine:").append(this.rawLine);
            sb.append(", ");
            sb.append("command:").append(this.command);
            sb.append(", ");
            sb.append("args:").append(Arrays.asList(this.args));
            sb.append(", ");
            sb.append("variable:").append(this.variable);
            sb.append(", ");
            sb.append("file:").append(this.file);
            sb.append(", ");
            sb.append("append:").append(this.append);
            sb.append(", ");
            sb.append("pipe:").append(this.pipe);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class ArgsParser {
        private int round = 0;
        private int curly = 0;
        private int square = 0;
        private boolean quoted;
        private boolean doubleQuoted;
        private String line;
        private String command;
        private String variable;
        private List<String> args;
        private Parser parser;

        public ArgsParser(Parser parser) {
            this.parser = parser;
        }

        private void reset() {
            this.round = 0;
            this.curly = 0;
            this.square = 0;
            this.quoted = false;
            this.doubleQuoted = false;
        }

        private void next(String arg) {
            char prevChar = ' ';
            for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                if (!this.parser.isEscapeChar(prevChar)) {
                    if (!this.quoted && !this.doubleQuoted) {
                        if (c == '(') {
                            ++this.round;
                        } else if (c == ')') {
                            --this.round;
                        } else if (c == '{') {
                            ++this.curly;
                        } else if (c == '}') {
                            --this.curly;
                        } else if (c == '[') {
                            ++this.square;
                        } else if (c == ']') {
                            --this.square;
                        } else if (c == '\"') {
                            this.doubleQuoted = true;
                        } else if (c == '\'') {
                            this.quoted = true;
                        }
                    } else if (this.quoted && c == '\'') {
                        this.quoted = false;
                    } else if (this.doubleQuoted && c == '\"') {
                        this.doubleQuoted = false;
                    }
                }
                prevChar = c;
            }
        }

        private boolean isEnclosed() {
            return this.round == 0 && this.curly == 0 && this.square == 0 && !this.quoted && !this.doubleQuoted;
        }

        private void enclosedArgs(List<String> words) {
            this.args = new ArrayList<String>();
            this.reset();
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (String a : words) {
                this.next(a);
                if (!first) {
                    sb.append(" ");
                }
                if (this.isEnclosed()) {
                    sb.append(a);
                    this.args.add(sb.toString());
                    sb = new StringBuilder();
                    first = true;
                    continue;
                }
                sb.append(a);
                first = false;
            }
            if (!first) {
                this.args.add(sb.toString());
            }
        }

        public void parse(String line) {
            this.line = line;
            ParsedLine pl = this.parser.parse(line, 0, Parser.ParseContext.SPLIT_LINE);
            this.enclosedArgs(pl.words());
            this.command = this.parser.getCommand(this.args.get(0));
            if (!this.parser.validCommandName(this.command)) {
                this.command = "";
            }
            this.variable = this.parser.getVariable(this.args.get(0));
        }

        public String line() {
            return this.line;
        }

        public String command() {
            return ConsoleEngine.plainCommand(this.command);
        }

        public String rawCommand() {
            return this.command;
        }

        public String variable() {
            return this.variable;
        }

        public List<String> args() {
            return this.args;
        }

        private int closingQuote(String arg) {
            int out = -1;
            char prevChar = ' ';
            for (int i = 1; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                if (!this.parser.isEscapeChar(prevChar) && c == arg.charAt(0)) {
                    out = i;
                    break;
                }
                prevChar = c;
            }
            return out;
        }

        private String unquote(String arg) {
            if ((arg.length() > 1 && arg.startsWith("\"") && arg.endsWith("\"") || arg.startsWith("'") && arg.endsWith("'")) && this.closingQuote(arg) == arg.length() - 1) {
                return arg.substring(1, arg.length() - 1);
            }
            return arg;
        }
    }

    private static class CommandOutputStream {
        private PrintStream origOut = System.out;
        private PrintStream origErr = System.err;
        private Terminal origTerminal;
        private ByteArrayOutputStream byteOutputStream;
        private FileOutputStream fileOutputStream;
        private PrintStream out;
        private InputStream in;
        private Terminal terminal;
        private String output;
        private CommandRegistry.CommandSession commandSession;
        private boolean redirecting = false;

        public CommandOutputStream(Terminal terminal) {
            this.origTerminal = terminal;
            this.terminal = terminal;
            PrintStream ps = new PrintStream(terminal.output());
            this.commandSession = new CommandRegistry.CommandSession(terminal, terminal.input(), ps, ps);
        }

        public void redirect() throws IOException {
            this.byteOutputStream = new ByteArrayOutputStream();
        }

        public void redirect(File file, boolean append) throws IOException {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    new File(file.getParent()).mkdirs();
                    file.createNewFile();
                }
            }
            this.fileOutputStream = new FileOutputStream(file, append);
        }

        public void open() throws IOException {
            if (this.redirecting || this.byteOutputStream == null && this.fileOutputStream == null) {
                return;
            }
            OutputStream outputStream = this.byteOutputStream != null ? this.byteOutputStream : this.fileOutputStream;
            this.out = new PrintStream(outputStream);
            System.setOut(this.out);
            System.setErr(this.out);
            String input = KeyMap.ctrl('X') + "q";
            this.in = new ByteArrayInputStream(input.getBytes());
            Attributes attrs = new Attributes();
            if (OSUtils.IS_WINDOWS) {
                attrs.setInputFlag(Attributes.InputFlag.IGNCR, true);
            }
            this.terminal = TerminalBuilder.builder().streams(this.in, outputStream).attributes(attrs).jna(false).jansi(false).type("dumb").build();
            this.commandSession = new CommandRegistry.CommandSession(this.terminal, this.terminal.input(), this.out, this.out);
            this.redirecting = true;
        }

        public void flush() {
            if (this.out == null) {
                return;
            }
            try {
                this.out.flush();
                if (this.byteOutputStream != null) {
                    this.byteOutputStream.flush();
                    this.output = this.byteOutputStream.toString();
                } else if (this.fileOutputStream != null) {
                    this.fileOutputStream.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void close() {
            if (this.out == null) {
                return;
            }
            try {
                this.in.close();
                this.flush();
                if (this.byteOutputStream != null) {
                    this.byteOutputStream.close();
                    this.byteOutputStream = null;
                } else if (this.fileOutputStream != null) {
                    this.fileOutputStream.close();
                    this.fileOutputStream = null;
                }
                this.out.close();
                this.out = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public CommandRegistry.CommandSession getCommandSession() {
            return this.commandSession;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean isRedirecting() {
            return this.redirecting;
        }

        public boolean isByteStream() {
            return this.redirecting && this.byteOutputStream != null;
        }

        public void reset() {
            if (this.redirecting) {
                this.out = null;
                this.byteOutputStream = null;
                this.fileOutputStream = null;
                this.output = null;
                System.setOut(this.origOut);
                System.setErr(this.origErr);
                this.terminal = null;
                this.terminal = this.origTerminal;
                PrintStream ps = new PrintStream(this.terminal.output());
                this.commandSession = new CommandRegistry.CommandSession(this.terminal, this.terminal.input(), ps, ps);
                this.redirecting = false;
            }
        }

        public void closeAndReset() {
            this.close();
            this.reset();
        }
    }

    public static enum Pipe {
        FLIP,
        NAMED,
        AND,
        OR;

    }
}

