/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTask;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTaskRunner;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.MailboxMergingRequest;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"Mailbox merging route for fixing Ghost mailbox bug described in MAILBOX-322"})
@Path(value=":cassandra/mailbox/merging")
@Produces(value={"application/json"})
public class CassandraMailboxMergingRoutes
implements Routes {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMailboxMergingRoutes.class);
    public static final String BASE = "/cassandra/mailbox/merging";
    private final MailboxMergingTaskRunner mailboxMergingTaskRunner;
    private final CassandraId.Factory mailboxIdFactory;
    private final JsonExtractor<MailboxMergingRequest> jsonExtractor;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    private final CassandraMailboxCounterDAO counterDAO;

    @Inject
    public CassandraMailboxMergingRoutes(MailboxMergingTaskRunner mailboxMergingTaskRunner, CassandraId.Factory mailboxIdFactory, TaskManager taskManager, JsonTransformer jsonTransformer, CassandraMailboxCounterDAO counterDAO) {
        this.mailboxMergingTaskRunner = mailboxMergingTaskRunner;
        this.mailboxIdFactory = mailboxIdFactory;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
        this.counterDAO = counterDAO;
        this.jsonExtractor = new JsonExtractor(MailboxMergingRequest.class, new Module[0]);
    }

    public String getBasePath() {
        return BASE;
    }

    public void define(Service service) {
        TaskFromRequest taskFromRequest = this::mergeMailboxes;
        service.post(BASE, taskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    @POST
    @ApiOperation(value="Triggers the merge of 2 mailboxes. Old mailbox Id will no more be accessible, rights and messages will be merged.")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, paramType="body", dataTypeClass=MailboxMergingRequest.class, example="{\"oldMailboxId\":\"4555-656-4554\",\"oldMailboxId\":\"9693-665-2500\"}", value="The mailboxes to merge together.")})
    @ApiResponses(value={@ApiResponse(code=201, message="The taskId of the given scheduled task", response=TaskIdDto.class, responseHeaders={@ResponseHeader(name="Location", description="URL of the resource associated with the scheduled task")}), @ApiResponse(code=400, message="Error with supplied data (JSON parsing or invalid mailbox ids)")})
    public Task mergeMailboxes(Request request) throws JsonExtractException {
        LOGGER.debug("Cassandra upgrade launched");
        MailboxMergingRequest mailboxMergingRequest = (MailboxMergingRequest)this.jsonExtractor.parse(request.body());
        CassandraId originId = this.mailboxIdFactory.fromString(mailboxMergingRequest.getMergeOrigin());
        CassandraId destinationId = this.mailboxIdFactory.fromString(mailboxMergingRequest.getMergeDestination());
        long totalMessagesToMove = (Long)this.counterDAO.countMessagesInMailbox(originId).defaultIfEmpty((Object)0L).block();
        return new MailboxMergingTask(this.mailboxMergingTaskRunner, totalMessagesToMove, originId, destinationId);
    }
}

