/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.utils.ClassName;

public class ExtensionConfiguration {
    public static final ExtensionConfiguration DEFAULT = new ExtensionConfiguration((List<ClassName>)ImmutableList.of());
    private final List<ClassName> additionalGuiceModulesForExtensions;

    public static ExtensionConfiguration from(Configuration configuration) {
        List list = Optional.ofNullable(configuration.getStringArray("guice.extension.module")).map(Arrays::asList).orElse((List)ImmutableList.of());
        return new ExtensionConfiguration((List)list.stream().map(ClassName::new).collect(Guavate.toImmutableList()));
    }

    public ExtensionConfiguration(List<ClassName> additionalGuiceModulesForExtensions) {
        this.additionalGuiceModulesForExtensions = additionalGuiceModulesForExtensions;
    }

    public List<ClassName> getAdditionalGuiceModulesForExtensions() {
        return this.additionalGuiceModulesForExtensions;
    }
}

