/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryCountDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryKeysDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoAPI;
import org.apache.james.util.ReactorUtils;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailRepository
implements MailRepository {
    private final MailRepositoryUrl url;
    private final CassandraMailRepositoryKeysDAO keysDAO;
    private final CassandraMailRepositoryCountDAO countDAO;
    private final CassandraMailRepositoryMailDaoAPI mailDAO;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;

    @Inject
    CassandraMailRepository(MailRepositoryUrl url, CassandraMailRepositoryKeysDAO keysDAO, CassandraMailRepositoryCountDAO countDAO, CassandraMailRepositoryMailDaoAPI mailDAO, MimeMessageStore.Factory mimeMessageStoreFactory) {
        this.url = url;
        this.keysDAO = keysDAO;
        this.countDAO = countDAO;
        this.mailDAO = mailDAO;
        this.mimeMessageStore = mimeMessageStoreFactory.mimeMessageStore();
    }

    public MailKey store(Mail mail) throws MessagingException {
        MailKey mailKey = MailKey.forMail((Mail)mail);
        return (MailKey)this.mimeMessageStore.save((Object)mail.getMessage()).flatMap(parts -> this.mailDAO.store(this.url, mail, parts.getHeaderBlobId(), parts.getBodyBlobId())).then(this.keysDAO.store(this.url, mailKey)).flatMap(this::increaseSizeIfStored).thenReturn((Object)mailKey).block();
    }

    private Mono<Void> increaseSizeIfStored(Boolean isStored) {
        if (isStored.booleanValue()) {
            return this.countDAO.increment(this.url);
        }
        return Mono.empty();
    }

    public Iterator<MailKey> list() {
        return this.keysDAO.list(this.url).toIterable().iterator();
    }

    public Mail retrieve(MailKey key) {
        return this.mailDAO.read(this.url, key).handle(ReactorUtils.publishIfPresent()).flatMap(this::toMail).blockOptional().orElse(null);
    }

    private Mono<Mail> toMail(CassandraMailRepositoryMailDaoAPI.MailDTO mailDTO) {
        MimeMessagePartsId parts = this.blobIds(mailDTO);
        return this.mimeMessageStore.read((Object)parts).map(mimeMessage -> mailDTO.getMailBuilder().mimeMessage(mimeMessage).build());
    }

    private MimeMessagePartsId blobIds(CassandraMailRepositoryMailDaoAPI.MailDTO mailDTO) {
        return MimeMessagePartsId.builder().headerBlobId(mailDTO.getHeaderBlobId()).bodyBlobId(mailDTO.getBodyBlobId()).build();
    }

    public void remove(Mail mail) {
        this.removeAsync(MailKey.forMail((Mail)mail)).block();
    }

    public void remove(Collection<Mail> toRemove) {
        Flux.fromIterable(toRemove).map(MailKey::forMail).flatMap(this::removeAsync, 16).then().block();
    }

    public void remove(MailKey key) {
        this.removeAsync(key).block();
    }

    private Mono<Void> removeAsync(MailKey key) {
        return this.mailDAO.read(this.url, key).flatMap(maybeMailDTO -> this.keysDAO.remove(this.url, key).flatMap(this::decreaseSizeIfDeleted).then(this.mailDAO.remove(this.url, key)).then(this.deleteBlobs((Optional<CassandraMailRepositoryMailDaoAPI.MailDTO>)maybeMailDTO)));
    }

    private Mono<Void> deleteBlobs(Optional<CassandraMailRepositoryMailDaoAPI.MailDTO> maybeMailDTO) {
        return Mono.justOrEmpty(maybeMailDTO).flatMap(mailDTO -> Mono.from((Publisher)this.mimeMessageStore.delete((Object)this.blobIds((CassandraMailRepositoryMailDaoAPI.MailDTO)mailDTO))));
    }

    private Mono<Void> decreaseSizeIfDeleted(Boolean isDeleted) {
        if (isDeleted.booleanValue()) {
            return this.countDAO.decrement(this.url);
        }
        return Mono.empty();
    }

    public long size() {
        return (Long)this.countDAO.getCount(this.url).block();
    }

    public void removeAll() {
        this.keysDAO.list(this.url).flatMap(this::removeAsync, 16).then().block();
    }
}

