/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.SetAnnotationRequest;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;

public class SetAnnotationCommandParser
extends AbstractImapCommandParser {
    public SetAnnotationCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.SETANNOTATION_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        ImmutableList.Builder listMailboxAnnotations = ImmutableList.builder();
        if (request.nextWordChar() == '(') {
            request.consumeChar('(');
            do {
                listMailboxAnnotations.add((Object)this.readNextAnnotation(request));
            } while (request.nextWordChar() != ')');
            request.consumeChar(')');
        }
        request.eol();
        return new SetAnnotationRequest(tag, mailboxName, (List<MailboxAnnotation>)listMailboxAnnotations.build());
    }

    private MailboxAnnotation readNextAnnotation(ImapRequestLineReader request) throws DecodingException {
        try {
            String key = request.atom();
            String value = request.nstring();
            return Optional.ofNullable(value).map(this.transforMailboxAnnotation(key)).orElse(MailboxAnnotation.nil((MailboxAnnotationKey)this.createAnnotationKey(key)));
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "The key is not valid: " + e.getMessage());
        }
    }

    private Function<String, MailboxAnnotation> transforMailboxAnnotation(String key) {
        return value -> MailboxAnnotation.newInstance((MailboxAnnotationKey)this.createAnnotationKey(key), (String)value);
    }

    private MailboxAnnotationKey createAnnotationKey(String key) {
        return new MailboxAnnotationKey(key);
    }
}

