/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.webadmin.mdc.LoggingRequestFilter;
import org.apache.james.webadmin.mdc.RequestId;
import org.apache.james.webadmin.mdc.RequestLogger;
import org.slf4j.Logger;
import spark.Request;

public class UserCreationRequestLogger
implements RequestLogger {
    public boolean applies(Request request) {
        return request.pathInfo().startsWith("/users") && request.requestMethod().equals("PUT");
    }

    public void log(Request request, RequestId requestId) {
        MDCStructuredLogger.forLogger((Logger)LoggingRequestFilter.LOGGER).addField("requestId", (Object)requestId.asString()).addField("ip", (Object)request.ip()).addField("endpoint", (Object)request.url()).addField("method", (Object)request.requestMethod()).addField("LOGIN", request.attribute("LOGIN")).addField("queryParameters", (Object)ImmutableSet.copyOf((Collection)request.queryParams())).log(logger -> logger.info("WebAdmin request received: user creation request"));
    }
}

