/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraQuotaModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("currentQuota").comment("Holds per quota-root current values. Quota-roots defines groups of mailboxes which shares quotas limitations.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)statement.addPartitionKey("quotaRoot", DataType.text()).addColumn("messageCount", DataType.counter())).addColumn("storage", DataType.counter())).table("maxQuota").comment("Holds per quota-root limitations. Limitations can concern the number of messages in a quota-root or the total size of a quota-root.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)statement.addPartitionKey("quotaRoot", DataType.text()).addColumn("maxMessageCount", DataType.bigint())).addColumn("maxStorage", DataType.bigint())).table("domainMaxQuota").comment("Holds per domain limitations. Limitations can concern the number of messages in a quota-root or the total size of a quota-root.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)statement.addPartitionKey("domain", DataType.text()).addColumn("maxMessageCount", DataType.bigint())).addColumn("maxStorage", DataType.bigint())).table("defaultMaxQuota").comment("Holds defaults limitations definition.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)statement.addPartitionKey("type", DataType.text()).addColumn("value", DataType.bigint())).build();
}

