/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.github.steveash.guavate.Guavate;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class CassandraUidProvider
implements UidProvider {
    private static final String CONDITION = "Condition";
    private final CassandraAsyncExecutor executor;
    private final long maxUidRetries;
    private final PreparedStatement insertStatement;
    private final PreparedStatement updateStatement;
    private final PreparedStatement selectStatement;
    private final ConsistencyLevel consistencyLevel;

    @Inject
    public CassandraUidProvider(Session session, CassandraConfiguration cassandraConfiguration, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.consistencyLevel = consistenciesConfiguration.getLightweightTransaction();
        this.maxUidRetries = cassandraConfiguration.getUidMaxRetry();
        this.selectStatement = this.prepareSelect(session);
        this.updateStatement = this.prepareUpdate(session);
        this.insertStatement = this.prepareInsert(session);
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"nextUid"}).from("messageCounter").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"messageCounter").onlyIf(QueryBuilder.eq((String)"nextUid", (Object)QueryBuilder.bindMarker((String)CONDITION))).with(QueryBuilder.set((String)"nextUid", (Object)QueryBuilder.bindMarker((String)"nextUid"))).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"messageCounter").value("nextUid", (Object)QueryBuilder.bindMarker((String)"nextUid")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).ifNotExists());
    }

    public MessageUid nextUid(Mailbox mailbox) throws MailboxException {
        return this.nextUid(mailbox.getMailboxId());
    }

    public MessageUid nextUid(MailboxId mailboxId) throws MailboxException {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return (MessageUid)this.nextUids(cassandraId).blockOptional().orElseThrow(() -> new MailboxException("Error during Uid update"));
    }

    public Mono<MessageUid> nextUids(CassandraId cassandraId) {
        Mono updateUid = this.findHighestUid(cassandraId).flatMap(messageUid -> this.tryUpdateUid(cassandraId, (MessageUid)messageUid));
        Duration firstBackoff = Duration.ofMillis(10L);
        return updateUid.switchIfEmpty(this.tryInsert(cassandraId)).switchIfEmpty(updateUid).single().retryWhen((Retry)Retry.backoff((long)this.maxUidRetries, (Duration)firstBackoff).scheduler(Schedulers.elastic()));
    }

    public Mono<List<MessageUid>> nextUids(CassandraId cassandraId, int count) {
        Mono updateUid = this.findHighestUid(cassandraId).flatMap(messageUid -> this.tryUpdateUid(cassandraId, (MessageUid)messageUid, count).map(highest -> this.range((MessageUid)messageUid, (MessageUid)highest)));
        Duration firstBackoff = Duration.ofMillis(10L);
        return updateUid.switchIfEmpty(this.tryInsert(cassandraId, count).map(highest -> this.range(MessageUid.MIN_VALUE, (MessageUid)highest))).switchIfEmpty(updateUid).single().retryWhen((Retry)Retry.backoff((long)this.maxUidRetries, (Duration)firstBackoff).scheduler(Schedulers.elastic()));
    }

    private List<MessageUid> range(MessageUid lowerExclusive, MessageUid higherInclusive) {
        return (List)LongStream.range(lowerExclusive.asLong() + 1L, higherInclusive.asLong() + 1L).mapToObj(MessageUid::of).collect(Guavate.toImmutableList());
    }

    public Optional<MessageUid> lastUid(Mailbox mailbox) {
        return this.findHighestUid((CassandraId)mailbox.getMailboxId()).blockOptional();
    }

    private Mono<MessageUid> findHighestUid(CassandraId mailboxId) {
        return this.executor.executeSingleRow(this.selectStatement.bind().setUUID("mailboxId", mailboxId.asUuid()).setConsistencyLevel(this.consistencyLevel)).map(row -> MessageUid.of((long)row.getLong("nextUid")));
    }

    private Mono<MessageUid> tryUpdateUid(CassandraId mailboxId, MessageUid uid) {
        return this.tryUpdateUid(mailboxId, uid, 1);
    }

    private Mono<MessageUid> tryUpdateUid(CassandraId mailboxId, MessageUid uid, int count) {
        MessageUid nextUid = uid.next(count);
        return this.executor.executeReturnApplied((Statement)this.updateStatement.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong(CONDITION, uid.asLong()).setLong("nextUid", nextUid.asLong())).map(success -> this.successToUid(nextUid, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Mono<MessageUid> tryInsert(CassandraId mailboxId) {
        return this.executor.executeReturnApplied((Statement)this.insertStatement.bind().setLong("nextUid", MessageUid.MIN_VALUE.asLong()).setUUID("mailboxId", mailboxId.asUuid())).map(success -> this.successToUid(MessageUid.MIN_VALUE, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Mono<MessageUid> tryInsert(CassandraId mailboxId, int count) {
        return this.executor.executeReturnApplied((Statement)this.insertStatement.bind().setLong("nextUid", MessageUid.MIN_VALUE.next(count).asLong()).setUUID("mailboxId", mailboxId.asUuid())).map(success -> this.successToUid(MessageUid.MIN_VALUE.next(count), (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Optional<MessageUid> successToUid(MessageUid uid, Boolean success) {
        if (success.booleanValue()) {
            return Optional.of(uid);
        }
        return Optional.empty();
    }
}

