/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.AttachmentLoader;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraIndexTableHandler;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.MailboxDeleteDuringUpdateException;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class CassandraMessageIdMapper
implements MessageIdMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMessageIdMapper.class);
    private static final int MAX_RETRY = 5;
    private static final Duration MIN_RETRY_BACKOFF = Duration.ofMillis(10L);
    private static final Duration MAX_RETRY_BACKOFF = Duration.ofMillis(1000L);
    private final MailboxMapper mailboxMapper;
    private final CassandraMailboxDAO mailboxDAO;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMessageDAO messageDAO;
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraIndexTableHandler indexTableHandler;
    private final ModSeqProvider modSeqProvider;
    private final AttachmentLoader attachmentLoader;
    private final CassandraConfiguration cassandraConfiguration;

    public CassandraMessageIdMapper(MailboxMapper mailboxMapper, CassandraMailboxDAO mailboxDAO, CassandraAttachmentMapper attachmentMapper, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO, CassandraMessageDAO messageDAO, CassandraMessageDAOV3 messageDAOV3, CassandraIndexTableHandler indexTableHandler, ModSeqProvider modSeqProvider, CassandraConfiguration cassandraConfiguration) {
        this.mailboxMapper = mailboxMapper;
        this.mailboxDAO = mailboxDAO;
        this.imapUidDAO = imapUidDAO;
        this.messageIdDAO = messageIdDAO;
        this.messageDAO = messageDAO;
        this.messageDAOV3 = messageDAOV3;
        this.indexTableHandler = indexTableHandler;
        this.modSeqProvider = modSeqProvider;
        this.attachmentLoader = new AttachmentLoader(attachmentMapper);
        this.cassandraConfiguration = cassandraConfiguration;
    }

    public List<MailboxMessage> find(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return (List)this.findReactive(messageIds, fetchType).collectList().block();
    }

    public Flux<MailboxMessage> findReactive(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return Flux.fromIterable(messageIds).flatMap(messageId -> this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.empty(), this.chooseReadConsistency()), this.cassandraConfiguration.getMessageReadChunkSize()).flatMap(composedMessageId -> this.messageDAOV3.retrieveMessage((ComposedMessageIdWithMetaData)composedMessageId, fetchType).switchIfEmpty(this.messageDAO.retrieveMessage((ComposedMessageIdWithMetaData)composedMessageId, fetchType)).map(messageRepresentation -> Pair.of((Object)composedMessageId, (Object)messageRepresentation)), this.cassandraConfiguration.getMessageReadChunkSize()).flatMap(messageRepresentation -> this.attachmentLoader.addAttachmentToMessage((Pair<ComposedMessageIdWithMetaData, MessageRepresentation>)messageRepresentation, fetchType), this.cassandraConfiguration.getMessageReadChunkSize()).groupBy(MailboxMessage::getMailboxId).flatMap(this::keepMessageIfMailboxExists, 16);
    }

    public Publisher<ComposedMessageIdWithMetaData> findMetadata(MessageId messageId) {
        return this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.empty(), this.chooseReadConsistency());
    }

    private Flux<MailboxMessage> keepMessageIfMailboxExists(GroupedFlux<MailboxId, MailboxMessage> groupedFlux) {
        CassandraId cassandraId = (CassandraId)groupedFlux.key();
        return this.mailboxDAO.retrieveMailbox(cassandraId).flatMapMany(any -> groupedFlux).switchIfEmpty((Publisher)groupedFlux.map(message -> {
            LOGGER.info("Mailbox {} have been deleted but message {} is still attached to it.", (Object)cassandraId.serialize(), (Object)message.getMessageId().serialize());
            return message;
        }).then(Mono.empty()));
    }

    public List<MailboxId> findMailboxes(MessageId messageId) {
        return (List)this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.empty(), this.chooseReadConsistency()).map(ComposedMessageIdWithMetaData::getComposedMessageId).map(ComposedMessageId::getMailboxId).collectList().block();
    }

    public CassandraMessageIdToImapUidDAO.ReadConsistency chooseReadConsistency() {
        if (this.cassandraConfiguration.isMessageReadStrongConsistency()) {
            return CassandraMessageIdToImapUidDAO.ReadConsistency.STRONG;
        }
        return CassandraMessageIdToImapUidDAO.ReadConsistency.WEAK;
    }

    public void save(MailboxMessage mailboxMessage) throws MailboxException {
        CassandraId mailboxId = (CassandraId)mailboxMessage.getMailboxId();
        MailboxReactorUtils.block((Mono)this.mailboxMapper.findMailboxById((MailboxId)mailboxId).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException((MailboxId)mailboxId))).then(this.messageDAOV3.save(mailboxMessage)).thenEmpty(this.saveMessageMetadata(mailboxMessage, mailboxId)));
    }

    public void copyInMailbox(MailboxMessage mailboxMessage, Mailbox mailbox) throws MailboxException {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        MailboxReactorUtils.block(this.saveMessageMetadata(mailboxMessage, mailboxId));
    }

    private Mono<Void> saveMessageMetadata(MailboxMessage mailboxMessage, CassandraId mailboxId) {
        ComposedMessageIdWithMetaData composedMessageIdWithMetaData = this.createMetadataFor(mailboxMessage);
        return this.imapUidDAO.insert(composedMessageIdWithMetaData).thenEmpty((Publisher)Flux.merge((Publisher[])new Publisher[]{this.messageIdDAO.insert(composedMessageIdWithMetaData).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_RETRY_BACKOFF).maxBackoff(MAX_RETRY_BACKOFF)), this.indexTableHandler.updateIndexOnAdd(mailboxMessage, mailboxId)}).then());
    }

    private ComposedMessageIdWithMetaData createMetadataFor(MailboxMessage mailboxMessage) {
        ComposedMessageId composedMessageId = new ComposedMessageId(mailboxMessage.getMailboxId(), mailboxMessage.getMessageId(), mailboxMessage.getUid());
        return ComposedMessageIdWithMetaData.builder().composedMessageId(composedMessageId).flags(mailboxMessage.createFlags()).modSeq(mailboxMessage.getModSeq()).build();
    }

    public void delete(MessageId messageId, Collection<MailboxId> mailboxIds) {
        this.deleteReactive(messageId, mailboxIds).block();
    }

    public Mono<Void> deleteReactive(MessageId messageId, Collection<MailboxId> mailboxIds) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        return Flux.fromStream(mailboxIds.stream()).flatMap(mailboxId -> this.retrieveAndDeleteIndices(cassandraMessageId, Optional.of((CassandraId)mailboxId)), 16).then();
    }

    public void delete(Multimap<MessageId, MailboxId> ids) {
        Flux.fromIterable(ids.asMap().entrySet()).publishOn(Schedulers.elastic()).flatMap(entry -> this.deleteReactive((MessageId)entry.getKey(), (Collection)entry.getValue()), this.cassandraConfiguration.getExpungeChunkSize(), 16).then().block();
    }

    private Mono<Void> retrieveAndDeleteIndices(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return this.imapUidDAO.retrieve(messageId, mailboxId, CassandraMessageIdToImapUidDAO.ReadConsistency.STRONG).flatMap(this::deleteIds, 16).then();
    }

    public void delete(MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        this.retrieveAndDeleteIndices(cassandraMessageId, Optional.empty()).block();
    }

    private Mono<Void> deleteIds(ComposedMessageIdWithMetaData metaData) {
        CassandraMessageId messageId = (CassandraMessageId)metaData.getComposedMessageId().getMessageId();
        CassandraId mailboxId = (CassandraId)metaData.getComposedMessageId().getMailboxId();
        return Flux.merge((Publisher[])new Publisher[]{this.imapUidDAO.delete(messageId, mailboxId), this.messageIdDAO.delete(mailboxId, metaData.getComposedMessageId().getUid())}).then(this.indexTableHandler.updateIndexOnDelete(metaData, mailboxId));
    }

    public Multimap<MailboxId, UpdatedFlags> setFlags(MessageId messageId, List<MailboxId> mailboxIds, Flags newState, MessageManager.FlagsUpdateMode updateMode) throws MailboxException {
        return (Multimap)Flux.fromIterable(mailboxIds).distinct().map(mailboxId -> (CassandraId)mailboxId).concatMap(mailboxId -> this.flagsUpdateWithRetry(newState, updateMode, (MailboxId)mailboxId, messageId)).flatMap(this::updateCounts, 16).collect(Guavate.toImmutableListMultimap(Pair::getLeft, Pair::getRight)).block();
    }

    private Flux<Pair<MailboxId, UpdatedFlags>> flagsUpdateWithRetry(Flags newState, MessageManager.FlagsUpdateMode updateMode, MailboxId mailboxId, MessageId messageId) {
        return Mono.defer(() -> this.updateFlags(mailboxId, messageId, newState, updateMode)).retry((long)this.cassandraConfiguration.getFlagsUpdateMessageIdMaxRetry()).onErrorResume(MailboxDeleteDuringUpdateException.class, e -> {
            LOGGER.info("Mailbox {} was deleted during flag update", (Object)mailboxId);
            return Mono.empty();
        }).flux().flatMapIterable(Function.identity()).map(pair -> this.buildUpdatedFlags((ComposedMessageIdWithMetaData)pair.getRight(), (Flags)pair.getLeft()));
    }

    private Pair<MailboxId, UpdatedFlags> buildUpdatedFlags(ComposedMessageIdWithMetaData composedMessageIdWithMetaData, Flags oldFlags) {
        return Pair.of((Object)composedMessageIdWithMetaData.getComposedMessageId().getMailboxId(), (Object)UpdatedFlags.builder().uid(composedMessageIdWithMetaData.getComposedMessageId().getUid()).messageId(composedMessageIdWithMetaData.getComposedMessageId().getMessageId()).modSeq(composedMessageIdWithMetaData.getModSeq()).oldFlags(oldFlags).newFlags(composedMessageIdWithMetaData.getFlags()).build());
    }

    private Mono<Pair<MailboxId, UpdatedFlags>> updateCounts(Pair<MailboxId, UpdatedFlags> pair) {
        CassandraId cassandraId = (CassandraId)pair.getLeft();
        return this.indexTableHandler.updateIndexOnFlagsUpdate(cassandraId, (UpdatedFlags)pair.getRight()).thenReturn(pair);
    }

    private Mono<List<Pair<Flags, ComposedMessageIdWithMetaData>>> updateFlags(MailboxId mailboxId, MessageId messageId, Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.of(cassandraId), CassandraMessageIdToImapUidDAO.ReadConsistency.STRONG).flatMap(oldComposedId -> this.updateFlags(newState, updateMode, cassandraId, (ComposedMessageIdWithMetaData)oldComposedId), 16).switchIfEmpty((Publisher)Mono.error(MailboxDeleteDuringUpdateException::new)).collectList();
    }

    private Mono<Pair<Flags, ComposedMessageIdWithMetaData>> updateFlags(Flags newState, MessageManager.FlagsUpdateMode updateMode, CassandraId cassandraId, ComposedMessageIdWithMetaData oldComposedId) {
        Flags newFlags = new FlagsUpdateCalculator(newState, updateMode).buildNewFlags(oldComposedId.getFlags());
        if (this.identicalFlags(oldComposedId, newFlags)) {
            return Mono.just((Object)Pair.of((Object)oldComposedId.getFlags(), (Object)oldComposedId));
        }
        return Mono.fromCallable(() -> new ComposedMessageIdWithMetaData(oldComposedId.getComposedMessageId(), newFlags, this.modSeqProvider.nextModSeq((MailboxId)cassandraId))).flatMap(newComposedId -> this.updateFlags(oldComposedId, (ComposedMessageIdWithMetaData)newComposedId));
    }

    private boolean identicalFlags(ComposedMessageIdWithMetaData oldComposedId, Flags newFlags) {
        return oldComposedId.getFlags().equals((Object)newFlags);
    }

    private Mono<Pair<Flags, ComposedMessageIdWithMetaData>> updateFlags(ComposedMessageIdWithMetaData oldComposedId, ComposedMessageIdWithMetaData newComposedId) {
        return this.imapUidDAO.updateMetadata(newComposedId, oldComposedId.getModSeq()).filter(FunctionalUtils.identityPredicate()).flatMap(any -> this.messageIdDAO.updateMetadata(newComposedId).thenReturn((Object)Pair.of((Object)oldComposedId.getFlags(), (Object)newComposedId))).single();
    }
}

