/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParameterMappingStrategyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterMappingStrategyHelper.class);

    private ParameterMappingStrategyHelper() {
    }

    public static ParameterMappingStrategy createParameterMappingStrategy(CamelContext camelContext) {
        ParameterMappingStrategy answer;
        Registry registry = camelContext.getRegistry();
        Set set = registry.findByType(ParameterMappingStrategy.class);
        if (set.size() == 1) {
            answer = (ParameterMappingStrategy)set.iterator().next();
        } else if (set.size() > 1) {
            LOG.warn("Found {} beans of type {} in registry. Only one custom instance is supported. Will use DefaultParameterMappingStrategy.", (Object)set.size(), (Object)ParameterMappingStrategy.class.getName());
            answer = DefaultParameterMappingStrategy.INSTANCE;
        } else {
            answer = DefaultParameterMappingStrategy.INSTANCE;
        }
        return answer;
    }
}

