/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.store.LazyMimeDescriptor;
import org.apache.james.mailbox.store.MimeDescriptorImpl;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.streaming.InputStreamContent;
import org.apache.james.mime4j.MimeException;

public class MessageResultImpl
implements MessageResult {
    private static final String TAB = " ";
    private final Map<MimePath, PartContent> partsByPath = new HashMap<MimePath, PartContent>();
    private final MailboxMessage message;
    private final HeadersImpl headers;
    private MimeDescriptor mimeDescriptor;
    private Content fullContent;
    private Content bodyContent;

    public MessageResultImpl(MailboxMessage message) {
        this.message = message;
        this.headers = new HeadersImpl(message);
    }

    public MessageMetaData messageMetaData() {
        return this.message.metaData();
    }

    public MailboxId getMailboxId() {
        return this.message.getMailboxId();
    }

    public MessageUid getUid() {
        return this.messageMetaData().getUid();
    }

    public MessageId getMessageId() {
        return this.messageMetaData().getMessageId();
    }

    public Date getInternalDate() {
        return this.messageMetaData().getInternalDate();
    }

    public Flags getFlags() {
        return this.messageMetaData().getFlags();
    }

    public ModSeq getModSeq() {
        return this.messageMetaData().getModSeq();
    }

    public long getSize() {
        return this.messageMetaData().getSize();
    }

    public int compareTo(MessageResult that) {
        return this.getUid().compareTo(that.getUid());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUid()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MessageResultImpl) {
            MessageResultImpl that = (MessageResultImpl)obj;
            return this.headers.equals(that.headers) && this.message.equals(that.message);
        }
        return false;
    }

    public final Content getFullContent() throws IOException {
        if (this.fullContent == null) {
            this.fullContent = new InputStreamContent(this.message, InputStreamContent.Type.Full);
        }
        return this.fullContent;
    }

    public final Content getBody() throws IOException {
        if (this.bodyContent == null) {
            this.bodyContent = new InputStreamContent(this.message, InputStreamContent.Type.Body);
        }
        return this.bodyContent;
    }

    public String toString() {
        return "MessageResultImpl ( uid = " + this.getUid() + " flags = " + this.getFlags() + " size = " + this.getSize() + " internalDate = " + this.getInternalDate() + ")";
    }

    public Content getBody(MimePath path) {
        PartContent partContent = this.getPartContent(path);
        return partContent.getBody();
    }

    public Content getMimeBody(MimePath path) {
        PartContent partContent = this.getPartContent(path);
        return partContent.getMimeBody();
    }

    public Content getFullContent(MimePath path) {
        PartContent partContent = this.getPartContent(path);
        return partContent.getFull();
    }

    public Iterator<Header> iterateHeaders(MimePath path) {
        PartContent partContent = this.getPartContent(path);
        return partContent.getHeaders();
    }

    public Iterator<Header> iterateMimeHeaders(MimePath path) {
        PartContent partContent = this.getPartContent(path);
        return partContent.getMimeHeaders();
    }

    void setBodyContent(MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setBody(content);
    }

    void setMimeBodyContent(MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeBody(content);
    }

    void setFullContent(MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setFull(content);
    }

    void setHeaders(MimePath path, Iterator<Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setHeaders(headers);
    }

    void setMimeHeaders(MimePath path, Iterator<Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeHeaders(headers);
    }

    private PartContent getPartContent(MimePath path) {
        return this.partsByPath.computeIfAbsent(path, any -> new PartContent());
    }

    public MimeDescriptor getMimeDescriptor() throws MailboxException {
        if (this.mimeDescriptor == null) {
            try {
                this.mimeDescriptor = this.isComposite(this.message.getMediaType()) ? MimeDescriptorImpl.build(this.getFullContent().getInputStream()) : new LazyMimeDescriptor(this, this.message);
            }
            catch (IOException | MimeException e) {
                throw new MailboxException("Unable to create the MimeDescriptor", e);
            }
        }
        return this.mimeDescriptor;
    }

    private boolean isComposite(String mediaType) {
        return "message".equalsIgnoreCase(mediaType) || "multipart".equalsIgnoreCase(mediaType);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public List<MessageAttachmentMetadata> getLoadedAttachments() {
        return this.message.getAttachments();
    }

    private static final class HeadersImpl
    implements Headers {
        private final MailboxMessage msg;
        private List<Header> headers;

        private HeadersImpl(MailboxMessage msg) {
            this.msg = msg;
        }

        public int hashCode() {
            return 741 + this.msg.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof HeadersImpl) {
                return this.msg.equals(((HeadersImpl)obj).msg);
            }
            return false;
        }

        public InputStream getInputStream() throws IOException {
            return this.msg.getHeaderContent();
        }

        public long size() {
            return this.msg.getHeaderOctets();
        }

        public Iterator<Header> headers() throws MailboxException {
            if (this.headers == null) {
                try {
                    this.headers = ResultUtils.createHeaders(this.msg);
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to parse headers", (Throwable)e);
                }
            }
            return this.headers.iterator();
        }
    }

    private static final class PartContent {
        private Content body;
        private Content mimeBody;
        private Content full;
        private Iterator<Header> headers;
        private Iterator<Header> mimeHeaders;

        private PartContent() {
        }

        public Content getBody() {
            return this.body;
        }

        public void setBody(Content body) {
            this.body = body;
        }

        Content getMimeBody() {
            return this.mimeBody;
        }

        void setMimeBody(Content mimeBody) {
            this.mimeBody = mimeBody;
        }

        public Content getFull() {
            return this.full;
        }

        public void setFull(Content full) {
            this.full = full;
        }

        public Iterator<Header> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Iterator<Header> headers) {
            this.headers = headers;
        }

        Iterator<Header> getMimeHeaders() {
            return this.mimeHeaders;
        }

        void setMimeHeaders(Iterator<Header> mimeHeaders) {
            this.mimeHeaders = mimeHeaders;
        }
    }
}

