/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.file;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailrepository.api.Initializable;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.file.Lock;
import org.apache.james.mailrepository.file.MimeMessageStreamRepositorySource;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.FilePersistentObjectRepository;
import org.apache.james.repository.file.FilePersistentStreamRepository;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMailRepository
implements MailRepository,
Configurable,
Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMailRepository.class);
    private FilePersistentStreamRepository streamRepository;
    private FilePersistentObjectRepository objectRepository;
    private String destination;
    private Set<String> keys;
    private final Object lock = new Object();
    private boolean fifo;
    private boolean cacheKeys;
    private FileSystem fileSystem;
    private final Lock accessControlLock = new Lock();

    private boolean unlock(MailKey key) {
        return this.accessControlLock.unlock(key);
    }

    private boolean lock(MailKey key) {
        return this.accessControlLock.lock(key);
    }

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.destination = config.getString("[@destinationURL]");
        LOGGER.debug("FileMailRepository.destinationURL: {}", (Object)this.destination);
        this.fifo = config.getBoolean("[@FIFO]", false);
        this.cacheKeys = config.getBoolean("[@CACHEKEYS]", true);
    }

    @PostConstruct
    public void init() throws Exception {
        try {
            BaseHierarchicalConfiguration reposConfiguration = new BaseHierarchicalConfiguration();
            reposConfiguration.addProperty("[@destinationURL]", (Object)this.destination);
            this.objectRepository = new FilePersistentObjectRepository();
            this.objectRepository.setFileSystem(this.fileSystem);
            this.objectRepository.configure((HierarchicalConfiguration)reposConfiguration);
            this.objectRepository.init();
            this.streamRepository = new FilePersistentStreamRepository();
            this.streamRepository.setFileSystem(this.fileSystem);
            this.streamRepository.configure((HierarchicalConfiguration)reposConfiguration);
            this.streamRepository.init();
            if (this.cacheKeys) {
                this.keys = Collections.synchronizedSet(new HashSet());
            }
            HashSet streamKeys = this.streamRepository.list().collect(Collectors.toCollection(HashSet::new));
            HashSet objectKeys = this.objectRepository.list().collect(Collectors.toCollection(HashSet::new));
            Collection strandedStreams = (Collection)streamKeys.clone();
            strandedStreams.removeAll(objectKeys);
            for (Object strandedStream : strandedStreams) {
                MailKey key = new MailKey((String)strandedStream);
                this.remove(key);
            }
            Collection strandedObjects = (Collection)objectKeys.clone();
            strandedObjects.removeAll(streamKeys);
            for (Object strandedObject : strandedObjects) {
                MailKey key = new MailKey((String)strandedObject);
                this.remove(key);
            }
            if (this.keys != null) {
                this.keys.clear();
                this.objectRepository.list().forEach(this.keys::add);
            }
            LOGGER.debug("{} created in {}", (Object)this.getClass().getName(), (Object)this.destination);
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve Store component", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailKey store(Mail mc) throws MessagingException {
        boolean wasLocked = true;
        MailKey key = MailKey.forMail((Mail)mc);
        try {
            FileMailRepository fileMailRepository = this;
            synchronized (fileMailRepository) {
                wasLocked = this.accessControlLock.isLocked(key);
                if (!wasLocked) {
                    this.lock(key);
                }
            }
            this.internalStore(mc);
            fileMailRepository = key;
            return fileMailRepository;
        }
        catch (MessagingException e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw new MessagingException("Exception caught while storing mail " + key, e);
        }
        finally {
            if (!wasLocked) {
                this.unlock(key);
                FileMailRepository fileMailRepository = this;
                synchronized (fileMailRepository) {
                    this.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStore(Mail mc) throws MessagingException, IOException {
        String key = mc.getName();
        if (this.keys != null) {
            this.keys.add(key);
        }
        boolean saveStream = true;
        MimeMessage message = mc.getMessage();
        if (message instanceof MimeMessageWrapper) {
            MimeMessageWrapper wrapper = (MimeMessageWrapper)message;
            LOGGER.trace("Retrieving from: {}", (Object)wrapper.getSourceId());
            LOGGER.trace("Saving to:       {}/{}", (Object)this.destination, (Object)mc.getName());
            LOGGER.trace("Modified: {}", (Object)wrapper.isModified());
            String destinationBuffer = this.destination + "/" + mc.getName();
            if (destinationBuffer.equals(wrapper.getSourceId()) && !wrapper.isModified()) {
                saveStream = false;
            }
        }
        if (saveStream) {
            try (OutputStream out = null;){
                if (message instanceof MimeMessageWrapper) {
                    ((MimeMessageWrapper)message).loadMessage();
                    out = this.streamRepository.put(key);
                    ((MimeMessageWrapper)message).writeTo(out, out, null, true);
                } else {
                    out = this.streamRepository.put(key);
                    mc.getMessage().writeTo(out);
                }
            }
        }
        this.objectRepository.put(key, (Object)mc);
    }

    public Mail retrieve(MailKey key) throws MessagingException {
        try {
            Mail mc;
            try {
                mc = (Mail)this.objectRepository.get(key.asString());
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof Error) {
                    LOGGER.warn("Error when retrieving mail, not deleting: {}", (Object)re, (Object)re);
                } else {
                    LOGGER.warn("Exception retrieving mail: {}, so we're deleting it.", (Object)re, (Object)re);
                    this.remove(key);
                }
                return null;
            }
            MimeMessageStreamRepositorySource source = new MimeMessageStreamRepositorySource((StreamRepository)this.streamRepository, this.destination, key.asString());
            mc.setMessage((MimeMessage)new MimeMessageWrapper((MimeMessageSource)source));
            return mc;
        }
        catch (Exception me) {
            LOGGER.error("Exception retrieving mail", (Throwable)me);
            throw new MessagingException("Exception while retrieving mail: " + me.getMessage(), me);
        }
    }

    public void remove(Mail mail) throws MessagingException {
        this.remove(MailKey.forMail((Mail)mail));
    }

    public void remove(Collection<Mail> mails) throws MessagingException {
        mails.forEach(Throwing.consumer(this::remove).sneakyThrow());
    }

    public void remove(MailKey key) throws MessagingException {
        if (this.lock(key)) {
            try {
                this.internalRemove(key);
            }
            finally {
                this.unlock(key);
            }
        } else {
            throw new MessagingException("Cannot lock " + key + " to remove it");
        }
    }

    public long size() {
        return Iterators.size(this.list());
    }

    public void removeAll() {
        this.listStream().forEach(Throwing.consumer(this::remove).sneakyThrow());
    }

    private void internalRemove(MailKey key) {
        if (this.keys != null) {
            this.keys.remove(key.asString());
        }
        this.streamRepository.remove(key.asString());
        this.objectRepository.remove(key.asString());
    }

    public Iterator<MailKey> list() {
        return this.listStream().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<MailKey> listStream() {
        ArrayList<String> clone;
        if (this.keys != null) {
            Object object = this.lock;
            synchronized (object) {
                clone = new ArrayList<String>(this.keys);
            }
        } else {
            clone = this.objectRepository.list().collect(Collectors.toCollection(ArrayList::new));
        }
        if (this.fifo) {
            Collections.sort(clone);
        }
        return clone.stream().map(MailKey::new);
    }
}

