/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.DeletedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailQueueBrowser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMailQueueBrowser.class);
    private final BrowseStartDAO browseStartDao;
    private final DeletedMailsDAO deletedMailsDao;
    private final EnqueuedMailsDAO enqueuedMailsDao;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private final CassandraMailQueueViewConfiguration configuration;
    private final Clock clock;

    @Inject
    CassandraMailQueueBrowser(BrowseStartDAO browseStartDao, DeletedMailsDAO deletedMailsDao, EnqueuedMailsDAO enqueuedMailsDao, MimeMessageStore.Factory mimeMessageStoreFactory, CassandraMailQueueViewConfiguration configuration, Clock clock) {
        this.browseStartDao = browseStartDao;
        this.deletedMailsDao = deletedMailsDao;
        this.enqueuedMailsDao = enqueuedMailsDao;
        this.mimeMessageStore = mimeMessageStoreFactory.mimeMessageStore();
        this.configuration = configuration;
        this.clock = clock;
    }

    Flux<CassandraMailQueueItemView> browse(MailQueueName queueName) {
        return this.browseReferences(queueName).flatMapSequential(this::toMailFuture).map(CassandraMailQueueItemView::new);
    }

    Flux<CassandraMailQueueItemView> browseOlderThan(MailQueueName queueName, Instant olderThan) {
        return this.browseReferencesOlderThan(queueName, olderThan).flatMapSequential(this::toMailFuture).map(CassandraMailQueueItemView::new);
    }

    Flux<EnqueuedItemWithSlicingContext> browseReferencesOlderThan(MailQueueName queueName, Instant olderThan) {
        return this.browseStartDao.findBrowseStart(queueName).flatMapMany(this::allSlicesStartingAt).filter(slice -> slice.getStartSliceInstant().isBefore(olderThan)).flatMapSequential(slice -> this.browseSlice(queueName, (BucketedSlices.Slice)slice)).filter(item -> item.getEnqueuedItem().getEnqueuedTime().isBefore(olderThan));
    }

    Flux<EnqueuedItemWithSlicingContext> browseReferences(MailQueueName queueName) {
        return this.browseStartDao.findBrowseStart(queueName).flatMapMany(this::allSlicesStartingAt).flatMapSequential(slice -> this.browseSlice(queueName, (BucketedSlices.Slice)slice));
    }

    private Mono<Pair<EnqueuedItem, Mail>> toMailFuture(EnqueuedItemWithSlicingContext enqueuedItemWithSlicingContext) {
        EnqueuedItem enqueuedItem = enqueuedItemWithSlicingContext.getEnqueuedItem();
        return this.mimeMessageStore.read((Object)enqueuedItem.getPartsId()).map(mimeMessage -> Pair.of((Object)enqueuedItem, (Object)this.toMail(enqueuedItem, (MimeMessage)mimeMessage)));
    }

    private Mail toMail(EnqueuedItem enqueuedItem, MimeMessage mimeMessage) {
        Mail mail = enqueuedItem.getMail();
        try {
            mail.setMessage(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("error while setting mime message to mail {}", (Object)mail.getName(), (Object)e);
        }
        return mail;
    }

    private Flux<EnqueuedItemWithSlicingContext> browseSlice(MailQueueName queueName, BucketedSlices.Slice slice) {
        return this.allBucketIds().flatMap(bucketId -> this.browseBucket(queueName, slice, (BucketedSlices.BucketId)bucketId), 16).sort(Comparator.comparing(enqueuedMail -> enqueuedMail.getEnqueuedItem().getEnqueuedTime()));
    }

    private Flux<EnqueuedItemWithSlicingContext> browseBucket(MailQueueName queueName, BucketedSlices.Slice slice, BucketedSlices.BucketId bucketId) {
        return this.enqueuedMailsDao.selectEnqueuedMails(queueName, slice, bucketId).filterWhen(mailReference -> this.deletedMailsDao.isStillEnqueued(queueName, mailReference.getEnqueuedItem().getEnqueueId()), 16);
    }

    private Flux<BucketedSlices.Slice> allSlicesStartingAt(Instant browseStart) {
        return Flux.fromStream(BucketedSlices.Slice.of(browseStart).allSlicesTill(this.clock.instant(), this.configuration.getSliceWindow()));
    }

    private Flux<BucketedSlices.BucketId> allBucketIds() {
        return Flux.range((int)0, (int)this.configuration.getBucketCount()).map(BucketedSlices.BucketId::of);
    }

    public static class CassandraMailQueueItemView
    implements ManageableMailQueue.MailQueueItemView {
        private final EnqueuedItem enqueuedItem;
        private final Mail mail;

        public CassandraMailQueueItemView(Pair<EnqueuedItem, Mail> pair) {
            this((EnqueuedItem)pair.getLeft(), (Mail)pair.getRight());
        }

        public CassandraMailQueueItemView(EnqueuedItem enqueuedItem, Mail mail) {
            this.enqueuedItem = enqueuedItem;
            this.mail = mail;
        }

        public EnqueueId getEnqueuedId() {
            return this.enqueuedItem.getEnqueueId();
        }

        public MimeMessagePartsId getEnqueuedPartsId() {
            return this.enqueuedItem.getPartsId();
        }

        public Mail getMail() {
            return this.mail;
        }

        public Optional<ZonedDateTime> getNextDelivery() {
            return Optional.empty();
        }
    }

    static class CassandraMailQueueIterator
    implements ManageableMailQueue.MailQueueIterator {
        private final Iterator<CassandraMailQueueItemView> iterator;

        CassandraMailQueueIterator(Iterator<CassandraMailQueueItemView> iterator) {
            Preconditions.checkNotNull(iterator);
            this.iterator = iterator;
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public CassandraMailQueueItemView next() {
            return this.iterator.next();
        }
    }
}

