/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import javax.mail.MessagingException;
import org.apache.james.util.streams.Iterators;
import org.apache.mailet.AttributeName;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class RemoveMailAttribute
extends GenericMailet {
    private static final char ATTRIBUTE_SEPARATOR_CHAR = ',';
    protected static final String MAILET_NAME_PARAMETER = "name";
    private ImmutableList<AttributeName> attributesToRemove;

    public String getMailetInfo() {
        return "Remove Mail Attribute Mailet";
    }

    public void init() throws MailetException {
        String name = this.getInitParameter(MAILET_NAME_PARAMETER);
        if (Strings.isNullOrEmpty((String)name)) {
            throw new MailetException("Please configure at least one attribute to remove");
        }
        this.attributesToRemove = this.getAttributes(name);
    }

    private ImmutableList<AttributeName> getAttributes(String name) {
        return (ImmutableList)Iterators.toStream(Splitter.on((char)',').trimResults().split((CharSequence)name).iterator()).map(AttributeName::of).collect(Guavate.toImmutableList());
    }

    public void service(Mail mail) throws MessagingException {
        Preconditions.checkNotNull((Object)mail);
        this.attributesToRemove.forEach(arg_0 -> ((Mail)mail).removeAttribute(arg_0));
    }
}

