/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.validation.EventsourcingStorageStrategy;

public class BlobStoreConfigurationValidationStartUpCheck
implements StartUpCheck {
    private static final String BLOB_STORE_CONFIGURATION_VALIDATION = "blobStore-configuration-validation";
    private final BlobStoreConfiguration blobStoreConfiguration;
    private final EventsourcingStorageStrategy eventsourcingStorageStrategy;

    @Inject
    @VisibleForTesting
    BlobStoreConfigurationValidationStartUpCheck(BlobStoreConfiguration blobStoreConfiguration, EventsourcingStorageStrategy eventsourcingStorageStrategy) {
        this.blobStoreConfiguration = blobStoreConfiguration;
        this.eventsourcingStorageStrategy = eventsourcingStorageStrategy;
    }

    public StartUpCheck.CheckResult check() {
        try {
            this.eventsourcingStorageStrategy.registerStorageStrategy(this.blobStoreConfiguration.storageStrategy());
            return StartUpCheck.CheckResult.builder().checkName(BLOB_STORE_CONFIGURATION_VALIDATION).resultType(StartUpCheck.ResultType.GOOD).build();
        }
        catch (IllegalStateException e) {
            return StartUpCheck.CheckResult.builder().checkName(BLOB_STORE_CONFIGURATION_VALIDATION).resultType(StartUpCheck.ResultType.BAD).description(e.getMessage()).build();
        }
    }

    public String checkName() {
        return BLOB_STORE_CONFIGURATION_VALIDATION;
    }
}

