/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.api.DLPRules;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.DLPConfigurationDTO;
import org.apache.james.webadmin.dto.DLPConfigurationItemDTO;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"DLPRules"})
@ApiModel(description="DLP (stands for Data Leak Prevention) is supported by James. A DLP matcher will, on incoming emails, execute regular expressions on email sender, recipients or content, in order to report suspicious emails toan administrator. WebAdmin can be used to manage these DLP rules on a per sender-domain basis.")
@Path(value="/dlp/rules")
@Produces(value={"application/json"})
public class DLPConfigurationRoutes
implements Routes {
    public static final String BASE_PATH = "/dlp/rules";
    private static final String DOMAIN_NAME = ":senderDomain";
    private static final String SPECIFIC_DLP_RULE_DOMAIN = "/dlp/rules/:senderDomain";
    private static final String RULE_ID_NAME = ":ruleId";
    private static final String RULE_SPECIFIC_PATH = "/dlp/rules/:senderDomain/rules/:ruleId";
    private final JsonTransformer jsonTransformer;
    private final DLPConfigurationStore dlpConfigurationStore;
    private final JsonExtractor<DLPConfigurationDTO> jsonExtractor;
    private final DomainList domainList;

    @Inject
    public DLPConfigurationRoutes(DLPConfigurationStore dlpConfigurationStore, DomainList domainList, JsonTransformer jsonTransformer) {
        this.dlpConfigurationStore = dlpConfigurationStore;
        this.domainList = domainList;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(DLPConfigurationDTO.class, new Module[0]);
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        this.defineStore(service);
        this.defineList(service);
        this.defineClear(service);
        this.defineFetch(service);
    }

    @PUT
    @Path(value="/{senderDomain}")
    @ApiOperation(value="Store a DLP configuration for given senderDomain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="senderDomain", paramType="path"), @ApiImplicitParam(required=true, dataTypeClass=DLPConfigurationDTO.class, paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. DLP configuration is stored."), @ApiResponse(code=400, message="Invalid senderDomain or payload in request", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=404, message="The domain does not exist.", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.", response=ErrorResponder.ErrorDetail.class)})
    public void defineStore(Service service) {
        service.put(SPECIFIC_DLP_RULE_DOMAIN, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            DLPConfigurationDTO dto = (DLPConfigurationDTO)this.jsonExtractor.parse(request.body());
            DLPRules rules = this.constructRules(dto);
            this.dlpConfigurationStore.store(senderDomain, rules);
            return Responses.returnNoContent((Response)response);
        });
    }

    private DLPRules constructRules(DLPConfigurationDTO dto) {
        try {
            return dto.toDLPConfiguration();
        }
        catch (DLPRules.DuplicateRulesIdsException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("'id' duplicates are not allowed in DLP rules").haltError();
        }
    }

    @GET
    @Path(value="/{senderDomain}")
    @ApiOperation(value="Return a DLP configuration for a given senderDomain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="senderDomain", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK. DLP configuration is returned", response=DLPConfigurationDTO.class), @ApiResponse(code=400, message="Invalid senderDomain in request", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=404, message="The domain does not exist.", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.", response=ErrorResponder.ErrorDetail.class)})
    public void defineList(Service service) {
        service.get(SPECIFIC_DLP_RULE_DOMAIN, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            DLPRules dlpConfigurations = (DLPRules)Mono.from((Publisher)this.dlpConfigurationStore.list(senderDomain)).block();
            DLPConfigurationDTO dto = DLPConfigurationDTO.toDTO(dlpConfigurations);
            response.status(200);
            response.header("Content-Type", "application/json");
            return dto;
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @Path(value="/{senderDomain}")
    @ApiOperation(value="Clear a DLP configuration for a given senderDomain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="senderDomain", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. DLP configuration is cleared"), @ApiResponse(code=400, message="Invalid senderDomain in request", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=404, message="The domain does not exist.", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.", response=ErrorResponder.ErrorDetail.class)})
    public void defineClear(Service service) {
        service.delete(SPECIFIC_DLP_RULE_DOMAIN, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            this.dlpConfigurationStore.clear(senderDomain);
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @Path(value="/{senderDomain}/rules/{ruleId}")
    @ApiOperation(value="Return a DLP rule for a given senderDomain and a ruleId")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="senderDomain", paramType="path"), @ApiImplicitParam(required=true, dataType="string", name="ruleId", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK. DLP rule is returned", response=DLPConfigurationItemDTO.class), @ApiResponse(code=400, message="Invalid senderDomain in request", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=404, message="The domain and/or the rule does not exist.", response=ErrorResponder.ErrorDetail.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.", response=ErrorResponder.ErrorDetail.class)})
    public void defineFetch(Service service) {
        service.get(RULE_SPECIFIC_PATH, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            DLPConfigurationItem.Id ruleId = DLPConfigurationItem.Id.of((String)request.params(RULE_ID_NAME));
            DLPConfigurationItem dlpConfigurationItem = (DLPConfigurationItem)this.dlpConfigurationStore.fetch(senderDomain, ruleId).orElseThrow(() -> this.notFound("There is no rule '" + ruleId.asString() + "' for '" + senderDomain.asString() + "' managed by this James server"));
            DLPConfigurationItemDTO dto = DLPConfigurationItemDTO.toDTO(dlpConfigurationItem);
            response.status(200);
            response.header("Content-Type", "application/json");
            return dto;
        }, (ResponseTransformer)this.jsonTransformer);
    }

    private Domain parseDomain(Request request) {
        String domainName = request.params(DOMAIN_NAME);
        try {
            Domain domain = Domain.of((String)domainName);
            this.validateDomainInList(domain);
            return domain;
        }
        catch (DomainListException e) {
            throw this.serverError(String.format("Cannot recognize domain: %s in domain list", domainName), (Exception)((Object)e));
        }
    }

    private void validateDomainInList(Domain domain) throws DomainListException {
        if (!this.domainList.containsDomain(domain)) {
            throw this.notFound(String.format("'%s' is not managed by this James server", domain.name()));
        }
    }

    private HaltException serverError(String message, Exception e) {
        return ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(message).cause(e).haltError();
    }

    private HaltException notFound(String message) {
        return ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(message).haltError();
    }
}

