/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageFactory;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MessageStorer {
    public Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>> appendMessageToStore(Mailbox var1, Date var2, int var3, int var4, Content var5, Flags var6, PropertyBuilder var7, MailboxSession var8) throws MailboxException;

    public static class WithoutAttachment
    implements MessageStorer {
        private final MailboxSessionMapperFactory mapperFactory;
        private final MessageId.Factory messageIdFactory;
        private final MessageFactory messageFactory;

        public WithoutAttachment(MailboxSessionMapperFactory mapperFactory, MessageId.Factory messageIdFactory, MessageFactory messageFactory) {
            this.mapperFactory = mapperFactory;
            this.messageIdFactory = messageIdFactory;
            this.messageFactory = messageFactory;
        }

        @Override
        public Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>> appendMessageToStore(Mailbox mailbox, Date internalDate, int size, int bodyStartOctet, Content content, Flags flags, PropertyBuilder propertyBuilder, MailboxSession session) throws MailboxException {
            MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
            MessageId messageId = this.messageIdFactory.generate();
            return this.mapperFactory.getMessageMapper(session).execute(() -> {
                Object message = this.messageFactory.createMessage(messageId, mailbox, internalDate, size, bodyStartOctet, content, flags, propertyBuilder, (List<MessageAttachmentMetadata>)ImmutableList.of());
                MessageMetaData metadata = messageMapper.add(mailbox, (MailboxMessage)message);
                return Pair.of((Object)metadata, Optional.empty());
            });
        }
    }

    public static class WithAttachment
    implements MessageStorer {
        private static final Logger LOGGER = LoggerFactory.getLogger(WithAttachment.class);
        private static final int START = 0;
        private static final int UNLIMITED = -1;
        private final MailboxSessionMapperFactory mapperFactory;
        private final MessageId.Factory messageIdFactory;
        private final MessageFactory messageFactory;
        private final AttachmentMapperFactory attachmentMapperFactory;
        private final MessageParser messageParser;

        public WithAttachment(MailboxSessionMapperFactory mapperFactory, MessageId.Factory messageIdFactory, MessageFactory messageFactory, AttachmentMapperFactory attachmentMapperFactory, MessageParser messageParser) {
            this.mapperFactory = mapperFactory;
            this.messageIdFactory = messageIdFactory;
            this.messageFactory = messageFactory;
            this.attachmentMapperFactory = attachmentMapperFactory;
            this.messageParser = messageParser;
        }

        @Override
        public Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>> appendMessageToStore(Mailbox mailbox, Date internalDate, int size, int bodyStartOctet, Content content, Flags flags, PropertyBuilder propertyBuilder, MailboxSession session) throws MailboxException {
            MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
            MessageId messageId = this.messageIdFactory.generate();
            return this.mapperFactory.getMessageMapper(session).execute(() -> {
                List<MessageAttachmentMetadata> attachments = this.storeAttachments(messageId, content, session);
                Object message = this.messageFactory.createMessage(messageId, mailbox, internalDate, size, bodyStartOctet, content, flags, propertyBuilder, attachments);
                MessageMetaData metadata = messageMapper.add(mailbox, (MailboxMessage)message);
                return Pair.of((Object)metadata, Optional.of(attachments));
            });
        }

        private List<MessageAttachmentMetadata> storeAttachments(MessageId messageId, Content messageContent, MailboxSession session) throws MailboxException {
            List<ParsedAttachment> attachments = this.extractAttachments(messageContent);
            return this.attachmentMapperFactory.getAttachmentMapper(session).storeAttachmentsForMessage(attachments, messageId);
        }

        private List<ParsedAttachment> extractAttachments(Content contentIn) {
            List<ParsedAttachment> list;
            block8: {
                InputStream inputStream = contentIn.getInputStream();
                try {
                    list = this.messageParser.retrieveAttachments(inputStream);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error while parsing mail's attachments: {}", (Object)e.getMessage(), (Object)e);
                        return ImmutableList.of();
                    }
                }
                inputStream.close();
            }
            return list;
        }
    }
}

