/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTOModule;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.impl.EventSourcingFilteringManagement;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.api.projections.MessageFastViewProjectionHealthCheck;
import org.apache.james.jmap.api.vacation.NotificationRegistry;
import org.apache.james.jmap.api.vacation.VacationRepository;
import org.apache.james.jmap.cassandra.access.CassandraAccessModule;
import org.apache.james.jmap.cassandra.access.CassandraAccessTokenRepository;
import org.apache.james.jmap.cassandra.change.CassandraEmailChangeModule;
import org.apache.james.jmap.cassandra.change.CassandraMailboxChangeModule;
import org.apache.james.jmap.cassandra.filtering.FilteringRuleSetDefineDTOModules;
import org.apache.james.jmap.cassandra.projections.CassandraEmailQueryView;
import org.apache.james.jmap.cassandra.projections.CassandraEmailQueryViewModule;
import org.apache.james.jmap.cassandra.projections.CassandraMessageFastViewProjection;
import org.apache.james.jmap.cassandra.projections.CassandraMessageFastViewProjectionModule;
import org.apache.james.jmap.cassandra.vacation.CassandraNotificationRegistry;
import org.apache.james.jmap.cassandra.vacation.CassandraNotificationRegistryModule;
import org.apache.james.jmap.cassandra.vacation.CassandraVacationModule;
import org.apache.james.jmap.cassandra.vacation.CassandraVacationRepository;

public class CassandraJmapModule
extends AbstractModule {
    protected void configure() {
        this.bind(CassandraAccessTokenRepository.class).in(Scopes.SINGLETON);
        this.bind(AccessTokenRepository.class).to(CassandraAccessTokenRepository.class);
        this.bind(CassandraVacationRepository.class).in(Scopes.SINGLETON);
        this.bind(VacationRepository.class).to(CassandraVacationRepository.class);
        this.bind(CassandraNotificationRegistry.class).in(Scopes.SINGLETON);
        this.bind(NotificationRegistry.class).to(CassandraNotificationRegistry.class);
        this.bind(EventSourcingFilteringManagement.class).in(Scopes.SINGLETON);
        this.bind(FilteringManagement.class).to(EventSourcingFilteringManagement.class);
        this.bind(CassandraMessageFastViewProjection.class).in(Scopes.SINGLETON);
        this.bind(MessageFastViewProjection.class).to(CassandraMessageFastViewProjection.class);
        this.bind(MessageFastViewProjectionHealthCheck.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(MessageFastViewProjectionHealthCheck.class);
        this.bind(CassandraEmailQueryView.class).in(Scopes.SINGLETON);
        this.bind(EmailQueryView.class).to(CassandraEmailQueryView.class);
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraAccessModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraVacationModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraNotificationRegistryModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMessageFastViewProjectionModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraEmailQueryViewModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMailboxChangeModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraEmailChangeModule.MODULE);
        Multibinder eventDTOModuleBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<EventDTOModule<? extends Event, ? extends EventDTO>>(){});
        eventDTOModuleBinder.addBinding().toInstance((Object)FilteringRuleSetDefineDTOModules.FILTERING_RULE_SET_DEFINED);
    }
}

