/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.apache.james.jmap.api.filtering.impl.RuleSetDefined;

public class FilteringAggregate {
    private final FilteringAggregateId aggregateId;
    private final History history;
    private State state;

    public static FilteringAggregate load(FilteringAggregateId aggregateId, History eventsOfAggregate) {
        return new FilteringAggregate(aggregateId, eventsOfAggregate);
    }

    private FilteringAggregate(FilteringAggregateId aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.state = State.initial();
        history.getEventsJava().forEach(this::apply);
        this.history = history;
    }

    public List<? extends Event> defineRules(List<Rule> rules) {
        Preconditions.checkArgument((boolean)this.shouldNotContainDuplicates(rules));
        ImmutableList events = ImmutableList.of((Object)new RuleSetDefined(this.aggregateId, this.history.getNextEventId(), (ImmutableList<Rule>)ImmutableList.copyOf(rules)));
        events.forEach(this::apply);
        return events;
    }

    private boolean shouldNotContainDuplicates(List<Rule> rules) {
        long uniqueIdCount = rules.stream().map(Rule::getId).distinct().count();
        return uniqueIdCount == (long)rules.size();
    }

    public List<Rule> listRules() {
        return this.state.rules;
    }

    private void apply(Event event) {
        if (event instanceof RuleSetDefined) {
            this.state = this.state.set(((RuleSetDefined)event).getRules());
        }
    }

    private static class State {
        final ImmutableList<Rule> rules;

        static State initial() {
            return new State((ImmutableList<Rule>)ImmutableList.of());
        }

        private State(ImmutableList<Rule> rules) {
            this.rules = rules;
        }

        State set(ImmutableList<Rule> rules) {
            return new State(rules);
        }
    }
}

