/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Flags;
import org.apache.james.backends.es.v7.DocumentId;
import org.apache.james.backends.es.v7.ElasticSearchIndexer;
import org.apache.james.backends.es.v7.RoutingKey;
import org.apache.james.backends.es.v7.UpdatedRepresentation;
import org.apache.james.core.Username;
import org.apache.james.events.Group;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.elasticsearch.v7.json.MessageToElasticSearchJson;
import org.apache.james.mailbox.elasticsearch.v7.search.ElasticSearchSearcher;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.util.ReactorUtils;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ElasticSearchListeningMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final int FLAGS_UPDATE_PROCESSING_WINDOW_SIZE = 32;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchListeningMessageSearchIndex.class);
    private static final String ID_SEPARATOR = ":";
    private static final Group GROUP = new ElasticSearchListeningMessageSearchIndexGroup();
    private final ElasticSearchIndexer elasticSearchIndexer;
    private final ElasticSearchSearcher searcher;
    private final MessageToElasticSearchJson messageToElasticSearchJson;
    private final RoutingKey.Factory<MailboxId> routingKeyFactory;

    @Inject
    public ElasticSearchListeningMessageSearchIndex(MailboxSessionMapperFactory factory, @Named(value="mailbox") ElasticSearchIndexer indexer, ElasticSearchSearcher searcher, MessageToElasticSearchJson messageToElasticSearchJson, SessionProvider sessionProvider, RoutingKey.Factory<MailboxId> routingKeyFactory) {
        super(factory, sessionProvider);
        this.elasticSearchIndexer = indexer;
        this.messageToElasticSearchJson = messageToElasticSearchJson;
        this.searcher = searcher;
        this.routingKeyFactory = routingKeyFactory;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, new MailboxManager.SearchCapabilities[]{MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.FullText, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.AttachmentFileName, MailboxManager.SearchCapabilities.PartialEmailMatch});
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        Optional<Integer> noLimit = Optional.empty();
        return this.searcher.search((Collection<MailboxId>)ImmutableList.of((Object)mailbox.getMailboxId()), searchQuery, noLimit).map(MessageSearchIndex.SearchResult::getMessageUid);
    }

    public Flux<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        if (mailboxIds.isEmpty()) {
            return Flux.empty();
        }
        return this.searcher.search(mailboxIds, searchQuery, Optional.empty()).doOnNext(this::logIfNoMessageId).map(MessageSearchIndex.SearchResult::getMessageId).handle(ReactorUtils.publishIfPresent()).distinct().take(limit);
    }

    public Mono<Void> add(MailboxSession session, Mailbox mailbox, MailboxMessage message) {
        LOGGER.info("Indexing mailbox {}-{} of user {} on message {}", new Object[]{mailbox.getName(), mailbox.getMailboxId(), session.getUser().asString(), message.getUid()});
        RoutingKey from = this.routingKeyFactory.from((Object)mailbox.getMailboxId());
        DocumentId id = this.indexIdFor(mailbox.getMailboxId(), message.getUid());
        return Mono.fromCallable(() -> this.generateIndexedJson(mailbox, message, session)).flatMap(jsonContent -> this.elasticSearchIndexer.index(id, jsonContent, from)).then();
    }

    private String generateIndexedJson(Mailbox mailbox, MailboxMessage message, MailboxSession session) throws JsonProcessingException {
        try {
            return this.messageToElasticSearchJson.convertToJson(message, (List<Username>)ImmutableList.of((Object)session.getUser()));
        }
        catch (Exception e) {
            LOGGER.warn("Indexing mailbox {}-{} of user {} on message {} without attachments ", new Object[]{mailbox.getName(), mailbox.getMailboxId().serialize(), session.getUser().asString(), message.getUid(), e});
            return this.messageToElasticSearchJson.convertToJsonWithoutAttachment(message, (List<Username>)ImmutableList.of((Object)session.getUser()));
        }
    }

    public Mono<Void> delete(MailboxSession session, MailboxId mailboxId, Collection<MessageUid> expungedUids) {
        return this.elasticSearchIndexer.delete((List)expungedUids.stream().map(uid -> this.indexIdFor(mailboxId, (MessageUid)uid)).collect(Guavate.toImmutableList()), this.routingKeyFactory.from((Object)mailboxId)).then();
    }

    public Mono<Void> deleteAll(MailboxSession session, MailboxId mailboxId) {
        TermQueryBuilder queryBuilder = QueryBuilders.termQuery((String)"mailboxId", (String)mailboxId.serialize());
        return this.elasticSearchIndexer.deleteAllMatchingQuery((QueryBuilder)queryBuilder, this.routingKeyFactory.from((Object)mailboxId));
    }

    public Mono<Void> update(MailboxSession session, MailboxId mailboxId, List<UpdatedFlags> updatedFlagsList) {
        RoutingKey routingKey = this.routingKeyFactory.from((Object)mailboxId);
        return Flux.fromIterable(updatedFlagsList).map(Throwing.function(updatedFlags -> this.createUpdatedDocumentPartFromUpdatedFlags(mailboxId, (UpdatedFlags)updatedFlags)).sneakyThrow()).window(32).concatMap(flux -> flux.collect(Guavate.toImmutableList()).flatMap(updates -> this.elasticSearchIndexer.update((List)updates, routingKey))).then();
    }

    private UpdatedRepresentation createUpdatedDocumentPartFromUpdatedFlags(MailboxId mailboxId, UpdatedFlags updatedFlags) throws JsonProcessingException {
        return new UpdatedRepresentation(this.indexIdFor(mailboxId, updatedFlags.getUid()), this.messageToElasticSearchJson.getUpdatedJsonMessagePart(updatedFlags.getNewFlags(), updatedFlags.getModSeq()));
    }

    private DocumentId indexIdFor(MailboxId mailboxId, MessageUid uid) {
        return DocumentId.fromString((String)String.join((CharSequence)ID_SEPARATOR, mailboxId.serialize(), String.valueOf(uid.asLong())));
    }

    private void logIfNoMessageId(MessageSearchIndex.SearchResult searchResult) {
        if (!searchResult.getMessageId().isPresent()) {
            LOGGER.error("No messageUid for {} in mailbox {}", (Object)searchResult.getMessageUid(), (Object)searchResult.getMailboxId());
        }
    }

    public Mono<Flags> retrieveIndexedFlags(Mailbox mailbox, MessageUid uid) {
        RoutingKey routingKey = this.routingKeyFactory.from((Object)mailbox.getMailboxId());
        return this.elasticSearchIndexer.get(this.indexIdFor(mailbox.getMailboxId(), uid), routingKey).filter(GetResponse::isExists).map(GetResponse::getSourceAsMap).map(this::extractFlags);
    }

    private Flags extractFlags(Map<String, Object> source) {
        FlagsBuilder flagsBuilder = FlagsBuilder.builder().isAnswered(this.extractFlag(source, "isAnswered")).isDeleted(this.extractFlag(source, "isDeleted")).isDraft(this.extractFlag(source, "isDraft")).isFlagged(this.extractFlag(source, "isFlagged")).isRecent(this.extractFlag(source, "isRecent")).isSeen(!this.extractFlag(source, "isUnread"));
        for (String userFlag : this.extractUserFlags(source)) {
            flagsBuilder.add(new String[]{userFlag});
        }
        return flagsBuilder.build();
    }

    private boolean extractFlag(Map<String, Object> source, String flag) {
        return (Boolean)source.get(flag);
    }

    private List<String> extractUserFlags(Map<String, Object> source) {
        return (List)source.get("userFlags");
    }

    public static class ElasticSearchListeningMessageSearchIndexGroup
    extends Group {
    }
}

