/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.events.RegistrationKey;

public class RoutingKeyConverter {
    private static final String SEPARATOR = ":";
    private final Set<RegistrationKey.Factory> factories;

    @VisibleForTesting
    static RoutingKeyConverter forFactories(RegistrationKey.Factory ... factories) {
        return new RoutingKeyConverter((Set<RegistrationKey.Factory>)ImmutableSet.copyOf((Object[])factories));
    }

    @Inject
    public RoutingKeyConverter(Set<RegistrationKey.Factory> factories) {
        this.factories = factories;
    }

    RegistrationKey toRegistrationKey(String routingKey) {
        return this.toRegistrationKey(Splitter.on((String)SEPARATOR).splitToList((CharSequence)routingKey));
    }

    private RegistrationKey toRegistrationKey(List<String> parts) {
        Preconditions.checkArgument((parts.size() >= 2 ? 1 : 0) != 0, (Object)"Routing key needs to match the 'classFQDN:value' pattern");
        String registrationClass = parts.get(0);
        String value = Joiner.on((String)SEPARATOR).join(Iterables.skip(parts, (int)1));
        return this.factories.stream().filter(factory -> factory.forClass().getName().equals(registrationClass)).findAny().orElseThrow(() -> new IllegalArgumentException("No factory for " + registrationClass)).fromString(value);
    }

    static class RoutingKey {
        private final Optional<RegistrationKey> registrationKey;

        static RoutingKey empty() {
            return new RoutingKey(Optional.empty());
        }

        static RoutingKey of(RegistrationKey key) {
            return new RoutingKey(Optional.of(key));
        }

        private RoutingKey(Optional<RegistrationKey> registrationKey) {
            this.registrationKey = registrationKey;
        }

        String asString() {
            return this.registrationKey.map(key -> key.getClass().getName() + RoutingKeyConverter.SEPARATOR + key.asString()).orElse("");
        }
    }
}

