/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;

public class DeleCmdHandler
implements CommandHandler<POP3Session> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"DELE");
    private static final Response SYNTAX_ERROR = new POP3Response("-ERR", "Usage: DELE [mail number]").immutable();
    private static final Response DELETED = new POP3Response("+OK", "Message deleted").immutable();
    private final MetricFactory metricFactory;

    @Inject
    public DeleCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-dele", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addContext("action", (Object)"DELE").addContext(MDCConstants.withSession(session)).addContext(MDCConstants.forRequest(request)), () -> this.delete(session, request)));
    }

    private Response delete(POP3Session session, Request request) {
        if (session.getHandlerState() == 2) {
            int num = 0;
            try {
                num = Integer.parseInt(request.getArgument());
            }
            catch (Exception e) {
                return SYNTAX_ERROR;
            }
            try {
                String uid;
                MessageMetaData meta = MessageMetaDataUtils.getMetaData(session, num);
                if (meta == null) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    return new POP3Response("-ERR", responseBuffer.toString());
                }
                List deletedUidList = session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElseGet(() -> {
                    ArrayList uidList = new ArrayList();
                    session.setAttachment(POP3Session.DELETED_UID_LIST, uidList, ProtocolSession.State.Transaction);
                    return uidList;
                });
                if (deletedUidList.contains(uid = meta.getUid())) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                    return new POP3Response("-ERR", responseBuffer.toString());
                }
                deletedUidList.add(uid);
                return DELETED;
            }
            catch (IndexOutOfBoundsException iob) {
                StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                return new POP3Response("-ERR", responseBuffer.toString());
            }
        }
        return POP3Response.ERR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

