/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.core.Capability;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.ErrorCode$InvalidResultReference$;
import org.apache.james.jmap.core.ErrorCode$ServerFail$;
import org.apache.james.jmap.core.ErrorCode$UnknownMethod$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.MissingCapabilityException;
import org.apache.james.jmap.core.RequestObject;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.routes.InvalidResultReferenceException;
import org.apache.james.jmap.routes.JMAPApi$;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.UnsupportedCapabilitiesException;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SFluxLike;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005-v!B\t\u0013\u0011\u0003ib!B\u0010\u0013\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%\tA\u000b\u0005\u0007c\u0005\u0001\u000b\u0011B\u0016\u0007\t}\u0011\u0002A\r\u0005\tg\u0015\u0011\t\u0011)A\u0005i!AQ)\u0002B\u0001B\u0003%a\tC\u0003(\u000b\u0011\u0005Q\nC\u0004R\u000b\t\u0007I\u0011\u0002*\t\r\u001d,\u0001\u0015!\u0003T\u0011\u00159S\u0001\"\u0001i\u0011\u0015qX\u0001\"\u0001\u0000\u0011\u001d\t)$\u0002C\u0005\u0003oAaA`\u0003\u0005\n\u0005U\u0004bBAC\u000b\u0011%\u0011q\u0011\u0005\b\u0003\u001f+A\u0011BAI\u0003\u001dQU*\u0011)Ba&T!a\u0005\u000b\u0002\rI|W\u000f^3t\u0015\t)b#\u0001\u0003k[\u0006\u0004(BA\f\u0019\u0003\u0015Q\u0017-\\3t\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001A\u0011a$A\u0007\u0002%\t9!*T!Q\u0003BL7CA\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!H\u0001\u0007\u0019>;u)\u0012*\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u000e\u0002\u000bMdg\r\u000e6\n\u0005Aj#A\u0002'pO\u001e,'/A\u0004M\u001f\u001e;UI\u0015\u0011\u0014\u0005\u0015\t\u0013aB7fi\"|Gm\u001d\t\u0004kqzdB\u0001\u001c;!\t94%D\u00019\u0015\tID$\u0001\u0004=e>|GOP\u0005\u0003w\r\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\r\u0019V\r\u001e\u0006\u0003w\r\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u000b\u0002\r5,G\u000f[8e\u0013\t!\u0015I\u0001\u0004NKRDw\u000eZ\u0001\u0014I\u00164\u0017-\u001e7u\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\t\u0004kq:\u0005C\u0001%L\u001b\u0005I%B\u0001&\u0015\u0003\u0011\u0019wN]3\n\u00051K%AC\"ba\u0006\u0014\u0017\u000e\\5usR\u0019aj\u0014)\u0011\u0005y)\u0001\"B\u001a\t\u0001\u0004!\u0004\"B#\t\u0001\u00041\u0015!D7fi\"|Gm\u001d\"z\u001d\u0006lW-F\u0001T!\u0011)DKV \n\u0005Us$aA'baB\u0011q\u000b\u001a\b\u00031\nt!!W1\u000f\u0005i\u0003gBA.`\u001d\tafL\u0004\u00028;&\t1$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0003+YI!A\u0013\u000b\n\u0005\rL\u0015AC%om>\u001c\u0017\r^5p]&\u0011QM\u001a\u0002\u000b\u001b\u0016$\bn\u001c3OC6,'BA2J\u00039iW\r\u001e5pIN\u0014\u0015PT1nK\u0002\"2AT5s\u0011\u0015Q7\u00021\u0001l\u0003-Q\u0017M^1NKRDw\u000eZ:\u0011\u00071\fx(D\u0001n\u0015\tqw.\u0001\u0003vi&d'\"\u00019\u0002\t)\fg/Y\u0005\u0003{5DQa]\u0006A\u0002Q\fQc];qa>\u0014H/\u001a3DCB\f'-\u001b7ji&,7\u000fE\u0002mc\u001eC#a\u0003<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018AB5oU\u0016\u001cGOC\u0001|\u0003\u0015Q\u0017M^1y\u0013\ti\bP\u0001\u0004J]*,7\r^\u0001\baJ|7-Z:t)\u0019\t\t!a\u0007\u0002&A1\u00111AA\t\u0003+i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\naV\u0014G.[:iKJT1\u0001JA\u0006\u0015\rQ\u0015Q\u0002\u0006\u0003\u0003\u001f\tqA]3bGR|'/\u0003\u0003\u0002\u0014\u0005\u0015!!B*N_:|\u0007c\u0001%\u0002\u0018%\u0019\u0011\u0011D%\u0003\u001dI+7\u000f]8og\u0016|%M[3di\"9\u0011Q\u0004\u0007A\u0002\u0005}\u0011!\u0004:fcV,7\u000f^(cU\u0016\u001cG\u000fE\u0002I\u0003CI1!a\tJ\u00055\u0011V-];fgR|%M[3di\"9\u0011q\u0005\u0007A\u0002\u0005%\u0012AD7bS2\u0014w\u000e_*fgNLwN\u001c\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\f\u0002\u000f5\f\u0017\u000e\u001c2pq&!\u00111GA\u0017\u00059i\u0015-\u001b7c_b\u001cVm]:j_:\f1\u0005\u001d:pG\u0016\u001c8oU3rk\u0016tG/[1mYf\fe\u000eZ+qI\u0006$XmQ8oi\u0016DH\u000f\u0006\u0006\u0002:\u0005M\u0013QKA,\u0003C\u0002b!a\u0001\u0002\u0012\u0005m\u0002CBA\u001f\u0003\u000f\niE\u0004\u0003\u0002@\u0005\rcbA\u001c\u0002B%\tA%C\u0002\u0002F\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002J\u0005-#aA*fc*\u0019\u0011QI\u0012\u0011\u0007\u0001\u000by%C\u0002\u0002R\u0005\u0013Q#\u00138w_\u000e\fG/[8o/&$\bnQ8oi\u0016DH\u000fC\u0004\u0002\u001e5\u0001\r!a\b\t\u000f\u0005\u001dR\u00021\u0001\u0002*!9\u0011\u0011L\u0007A\u0002\u0005m\u0013!\u00059s_\u000e,7o]5oO\u000e{g\u000e^3yiB\u0019a$!\u0018\n\u0007\u0005}#CA\tQe>\u001cWm]:j]\u001e\u001cuN\u001c;fqRDq!a\u0019\u000e\u0001\u0004\t)'\u0001\u0007dCB\f'-\u001b7ji&,7\u000f\u0005\u00036y\u0005\u001d\u0004\u0003BA5\u0003_r1\u0001WA6\u0013\r\ti'S\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\u0005E\u00141\u000f\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\u0007\u00055\u0014\n\u0006\u0005\u0002x\u0005u\u0014qPAA!\u0019\t\u0019!!\u001f\u0002N%!\u00111PA\u0003\u0005\u0015\u0019f\t\\;y\u0011\u001d\t\u0019G\u0004a\u0001\u0003KBq!a\n\u000f\u0001\u0004\tI\u0003C\u0004\u0002\u0004:\u0001\r!!\u0014\u0002\u0015%tgo\\2bi&|g.\u0001\u000eqe>\u001cWm]:NKRDw\u000eZ,ji\"l\u0015\r^2i\u001d\u0006lW\r\u0006\u0005\u0002x\u0005%\u00151RAG\u0011\u001d\t\u0019g\u0004a\u0001\u0003KBq!a!\u0010\u0001\u0004\ti\u0005C\u0004\u0002(=\u0001\r!!\u000b\u0002)Y\fG.\u001b3bi\u0016\u001c\u0015\r]1cS2LG/[3t)\u0019\t\u0019*!*\u0002(BA\u0011QHAK\u00033\u000by*\u0003\u0003\u0002\u0018\u0006-#AB#ji\",'\u000fE\u0002I\u00037K1!!(J\u0005ii\u0015n]:j]\u001e\u001c\u0015\r]1cS2LG/_#yG\u0016\u0004H/[8o!\r\u0011\u0013\u0011U\u0005\u0004\u0003G\u001b#\u0001B+oSRDq!a\u0019\u0011\u0001\u0004\t)\u0007C\u0004\u0002*B\u0001\r!!\u001a\u0002)I,\u0017/^5sK\u0012\u001c\u0015\r]1cS2LG/[3t\u0001")
public class JMAPApi {
    private final scala.collection.immutable.Set<Capability> defaultCapabilities;
    private final Map<Invocation.MethodName, Method> methodsByName;

    public static Logger LOGGER() {
        return JMAPApi$.MODULE$.LOGGER();
    }

    private Map<Invocation.MethodName, Method> methodsByName() {
        return this.methodsByName;
    }

    public SMono<ResponseObject> process(RequestObject requestObject, MailboxSession mailboxSession) {
        ProcessingContext processingContext = new ProcessingContext((Map<ClientId, ServerId>)Predef$.MODULE$.Map().empty(), (Map<Invocation.MethodCallId, Invocation>)Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Set unsupportedCapabilities = (scala.collection.immutable.Set)requestObject.using().toSet().$minus$minus((IterableOnce)this.defaultCapabilities.map((Function1 & Serializable)x$1 -> new Refined((Object)x$1.identifier())));
        scala.collection.immutable.Set capabilities = requestObject.using().toSet();
        return unsupportedCapabilities.nonEmpty() ? SMono$.MODULE$.raiseError((Throwable)new UnsupportedCapabilitiesException((scala.collection.immutable.Set<Refined<String, string.Uri>>)unsupportedCapabilities)) : this.processSequentiallyAndUpdateContext(requestObject, mailboxSession, processingContext, (scala.collection.immutable.Set<Refined<String, string.Uri>>)capabilities).map((Function1 & Serializable)invocations -> new ResponseObject(ResponseObject$.MODULE$.SESSION_STATE(), (Seq<Invocation>)((Seq)invocations.map((Function1 & Serializable)x$2 -> x$2.invocation()))));
    }

    private SMono<Seq<InvocationWithContext>> processSequentiallyAndUpdateContext(RequestObject requestObject, MailboxSession mailboxSession, ProcessingContext processingContext, scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities) {
        return SFlux$.MODULE$.fromIterable(requestObject.methodCalls()).fold(package$.MODULE$.List().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(acc, elem) -> {
            SMono lastProcessingContext = (SMono)acc.headOption().map((Function1 & Serializable)last -> SMono$.MODULE$.fromPublisher((Publisher)Flux.from((Publisher)last.map((Function1 & Serializable)x$3 -> x$3.processingContext())).last())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)processingContext));
            SFlux invocation = lastProcessingContext.flatMapMany((Function1 & Serializable)context -> this.process(capabilities, mailboxSession, new InvocationWithContext((Invocation)elem, (ProcessingContext)context)));
            SFlux sFlux = invocation.cache(invocation.cache$default$1(), invocation.cache$default$2());
            return acc.$colon$colon((Object)sFlux);
        }).map((Function1 & Serializable)x$4 -> x$4.reverse()).flatMap((Function1 & Serializable)list -> {
            SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)list);
            Function1 & Serializable x$1 = (Function1 & Serializable)e -> e;
            int x$2 = qual$1.concatMap$default$2();
            return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
        });
    }

    private SFlux<InvocationWithContext> process(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession, InvocationWithContext invocation) {
        SFlux sFlux;
        Either<InvalidResultReferenceException, Invocation> either = invocation.processingContext().resolveBackReferences(invocation.invocation());
        if (either instanceof Left) {
            Left left = (Left)either;
            InvalidResultReferenceException e = (InvalidResultReferenceException)left.value();
            sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidResultReference$.MODULE$, new StringBuilder(33).append("Failed resolving back-reference: ").append(e.message()).toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Invocation resolvedInvocation = (Invocation)right.value();
            sFlux = this.processMethodWithMatchName(capabilities, new InvocationWithContext(resolvedInvocation, invocation.processingContext()), mailboxSession).map((Function1 & Serializable)x$5 -> x$5.recordInvocation());
        } else {
            throw new MatchError(either);
        }
        return SFlux$.MODULE$.fromPublisher((Publisher)sFlux);
    }

    private SFlux<InvocationWithContext> processMethodWithMatchName(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return ((SFluxLike)this.methodsByName().get((Object)invocation.invocation().methodName()).map((Function1 & Serializable)method -> (SFlux)this.validateCapabilities(capabilities, method.requiredCapabilities()).fold((Function1 & Serializable)e -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, e.description(), invocation.invocation().methodCallId()), invocation.processingContext())})), (Function1 & Serializable)x$6 -> SFlux$.MODULE$.fromPublisher(method.process(capabilities, invocation, mailboxSession)))).getOrElse((Function0 & Serializable)() -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, invocation.invocation().methodCallId()), invocation.processingContext())})))).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$ServerFail$.MODULE$, throwable.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())));
    }

    private Either<MissingCapabilityException, BoxedUnit> validateCapabilities(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities) {
        scala.collection.immutable.Set missingCapabilities = (scala.collection.immutable.Set)requiredCapabilities.$minus$minus(capabilities);
        return missingCapabilities.nonEmpty() ? package$.MODULE$.Left().apply((Object)new MissingCapabilityException(new StringBuilder(25).append("Missing capability(ies): ").append(missingCapabilities.mkString(", ")).toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public JMAPApi(scala.collection.immutable.Set<Method> methods, scala.collection.immutable.Set<Capability> defaultCapabilities) {
        this.defaultCapabilities = defaultCapabilities;
        this.methodsByName = ((IterableOnceOps)methods.map((Function1 & Serializable)method -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)method.methodName()), method))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Inject
    public JMAPApi(Set<Method> javaMethods, Set<Capability> supportedCapabilities) {
        this((scala.collection.immutable.Set<Method>)CollectionConverters$.MODULE$.SetHasAsScala(javaMethods).asScala().toSet(), (scala.collection.immutable.Set<Capability>)CollectionConverters$.MODULE$.SetHasAsScala(supportedCapabilities).asScala().toSet());
    }
}

