/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.mail.DelegatedNamespace;
import org.apache.james.jmap.mail.Mailbox;
import org.apache.james.jmap.mail.MailboxACL$;
import org.apache.james.jmap.mail.MailboxNamespace;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxValidation;
import org.apache.james.jmap.mail.MailboxValidation$;
import org.apache.james.jmap.mail.PersonalNamespace;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.Rfc4314Rights$;
import org.apache.james.jmap.mail.Right;
import org.apache.james.jmap.mail.Right$;
import org.apache.james.jmap.mail.Rights;
import org.apache.james.jmap.mail.Rights$;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.Subscriptions;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)A\u0006\u0001C\u0001[!)1\b\u0001C\u0005y!)\u0001\u000b\u0001C\u0005#\")q\u000b\u0001C\u00051\")\u0011\r\u0001C\u0005E\")\u0001\u000e\u0001C\u0005S\")Q\u000e\u0001C\u0005]\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\tY\u0003\u0001C\u0001\u0003\u0017\u0013a\"T1jY\n|\u0007PR1di>\u0014\u0018P\u0003\u0002\u0011#\u0005!Q.Y5m\u0015\t\u00112#\u0001\u0003k[\u0006\u0004(B\u0001\u000b\u0016\u0003\u0015Q\u0017-\\3t\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002'M,(m]2sSB$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u001a\u0012aB7bS2\u0014w\u000e_\u0005\u0003O\u0011\u00121cU;cg\u000e\u0014\u0018\u000e\u001d;j_:l\u0015M\\1hKJ\fa\"\\1jY\n|\u00070T1oC\u001e,'\u000f\u0005\u0002$U%\u00111\u0006\n\u0002\u000f\u001b\u0006LGNY8y\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q\u0019a\u0006M\u0019\u0011\u0005=\u0002Q\"A\b\t\u000b\u0005\u001a\u0001\u0019\u0001\u0012\t\u000b!\u001a\u0001\u0019A\u0015)\u0005\r\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0019IgN[3di*\t\u0001(A\u0003kCZ\f\u00070\u0003\u0002;k\t1\u0011J\u001c6fGR\fqaZ3u%>dW\rF\u0002>\u0007.\u00032\u0001\b A\u0013\tyTD\u0001\u0004PaRLwN\u001c\t\u0003G\u0005K!A\u0011\u0013\u0003\tI{G.\u001a\u0005\u0006\t\u0012\u0001\r!R\u0001\f[\u0006LGNY8y!\u0006$\b\u000e\u0005\u0002G\u00136\tqI\u0003\u0002II\u0005)Qn\u001c3fY&\u0011!j\u0012\u0002\f\u001b\u0006LGNY8y!\u0006$\b\u000eC\u0003M\t\u0001\u0007Q*\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\u0005\rr\u0015BA(%\u00059i\u0015-\u001b7c_b\u001cVm]:j_:\fAbZ3u'>\u0014Ho\u0014:eKJ$\"AU+\u0011\u0005=\u001a\u0016B\u0001+\u0010\u0005%\u0019vN\u001d;Pe\u0012,'\u000fC\u0003W\u000b\u0001\u0007Q(\u0001\u0003s_2,\u0017!C4fiJKw\r\u001b;t)\tIF\f\u0005\u000205&\u00111l\u0004\u0002\u0007%&<\u0007\u000e^:\t\u000bu3\u0001\u0019\u00010\u0002#I,7o\u001c7wK6\u000b\u0017\u000e\u001c2pq\u0006\u001bE\n\u0005\u0002G?&\u0011\u0001m\u0012\u0002\u000b\u001b\u0006LGNY8y\u0003\u000ec\u0015\u0001D4fi:\u000bW.Z:qC\u000e,GcA2gOB\u0011q\u0006Z\u0005\u0003K>\u0011\u0001#T1jY\n|\u0007PT1nKN\u0004\u0018mY3\t\u000b\u0011;\u0001\u0019A#\t\u000b1;\u0001\u0019A'\u0002\u001b\u001d,G\u000fU1sK:$\b+\u0019;i)\rQ7\u000e\u001c\t\u00049y*\u0005\"\u0002#\t\u0001\u0004)\u0005\"\u0002'\t\u0001\u0004i\u0015aC1dY\u0016sGO]=LKf$2a\\A\u0004!\r\u0001\u0018\u0011\u0001\b\u0003czt!A]?\u000f\u0005MdhB\u0001;|\u001d\t)(P\u0004\u0002ws6\tqO\u0003\u0002y3\u00051AH]8pizJ\u0011\u0001G\u0005\u0003-]I!\u0001F\u000b\n\u0005\u0015\u001a\u0012B\u0001%%\u0013\tyx)\u0001\u0006NC&d'm\u001c=B\u00072KA!a\u0001\u0002\u0006\tAQI\u001c;ss.+\u0017P\u0003\u0002\u0000\u000f\")A*\u0003a\u0001\u001b\u0006Yq-\u001a;NsJKw\r\u001b;t)!\ti!a\u0005\u0002\u0016\u0005]\u0001cA\u0018\u0002\u0010%\u0019\u0011\u0011C\b\u0003\u001b5\u000b\u0017\u000e\u001c2pqJKw\r\u001b;t\u0011\u0015!%\u00021\u0001F\u0011\u0015i&\u00021\u0001_\u0011\u0015a%\u00021\u0001N\u0003Q\u0011X\r\u001e:jKZ,\u0017j]*vEN\u001c'/\u001b2fIR1\u0011QDA\u0012\u0003O\u00012aLA\u0010\u0013\r\t\tc\u0004\u0002\r\u0013N\u001cVOY:de&\u0014W\r\u001a\u0005\u0007\u0003KY\u0001\u0019A#\u0002\tA\fG\u000f\u001b\u0005\u0007\u0003SY\u0001\u0019A'\u0002\u000fM,7o]5p]\u000611M]3bi\u0016$B\"a\f\u0002L\u0005U\u0013qKA1\u0003o\u0002b!!\r\u0002B\u0005\u0015SBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001\u0010\u0002:)!\u00111HA\u001f\u0003\u0011\u0019wN]3\u000b\u0005\u0005}\u0012a\u0002:fC\u000e$xN]\u0005\u0005\u0003\u0007\n\u0019DA\u0003T\u001b>tw\u000eE\u00020\u0003\u000fJ1!!\u0013\u0010\u0005\u001di\u0015-\u001b7c_bDq!!\u0014\r\u0001\u0004\ty%A\bnC&d'm\u001c=NKR\fG)\u0019;b!\r1\u0015\u0011K\u0005\u0004\u0003':%aD'bS2\u0014w\u000e_'fi\u0006$\u0015\r^1\t\u000b1c\u0001\u0019A'\t\u000f\u0005eC\u00021\u0001\u0002\\\u0005i1/\u001e2tGJL\u0007\u000f^5p]N\u00042aLA/\u0013\r\tyf\u0004\u0002\u000e'V\u00147o\u0019:jaRLwN\\:\t\u000f\u0005\rD\u00021\u0001\u0002f\u0005!\u0012\r\u001c7NC&d'm\u001c=fg6+G/\u00193bi\u0006\u0004b!a\u001a\u0002r\u0005=c\u0002BA5\u0003[r1A^A6\u0013\u0005q\u0012bAA8;\u00059\u0001/Y2lC\u001e,\u0017\u0002BA:\u0003k\u00121aU3r\u0015\r\ty'\b\u0005\b\u0003sb\u0001\u0019AA>\u0003-\tXo\u001c;b\u0019>\fG-\u001a:\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u00061\u0011/^8uCNT1!!\"\u0012\u0003\u0015)H/\u001b7t\u0013\u0011\tI)a \u0003\u0017E+x\u000e^1M_\u0006$WM\u001d\u000b\t\u0003_\ti)a&\u0002\u001a\"9\u0011qR\u0007A\u0002\u0005E\u0015AA5e!\r1\u00151S\u0005\u0004\u0003+;%!C'bS2\u0014w\u000e_%e\u0011\u0015aU\u00021\u0001N\u0011\u001d\tI(\u0004a\u0001\u0003w\u0002")
public class MailboxFactory {
    private final SubscriptionManager subscriptionManager;
    private final MailboxManager mailboxManager;

    private Option<Role> getRole(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(Role.from((String)mailboxPath.getName()).filter(x$1 -> mailboxPath.belongsTo(mailboxSession))));
    }

    private SortOrder getSortOrder(Option<Role> role2) {
        return (SortOrder)role2.map((Function1 & Serializable)role -> SortOrder$.MODULE$.getSortOrder((Role)role)).getOrElse((Function0 & Serializable)() -> SortOrder$.MODULE$.defaultSortOrder());
    }

    private Rights getRights(MailboxACL resolveMailboxACL) {
        return Rights$.MODULE$.fromACL(MailboxACL$.MODULE$.fromJava(resolveMailboxACL));
    }

    private MailboxNamespace getNamespace(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        Product product;
        boolean bl = mailboxPath.belongsTo(mailboxSession);
        if (bl) {
            product = new PersonalNamespace();
        } else if (!bl) {
            product = new DelegatedNamespace(mailboxPath.getUser());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return product;
    }

    private Option<MailboxPath> getParentPath(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
    }

    private MailboxACL.EntryKey aclEntryKey(MailboxSession mailboxSession) {
        return MailboxACL.EntryKey.createUserEntryKey((Username)mailboxSession.getUser());
    }

    private MailboxRights getMyRights(MailboxPath mailboxPath, MailboxACL resolveMailboxACL, MailboxSession mailboxSession) {
        MailboxRights mailboxRights;
        boolean bl = mailboxPath.belongsTo(mailboxSession);
        if (bl) {
            mailboxRights = MailboxRights$.MODULE$.FULL();
        } else if (!bl) {
            Seq<Right> rights = Rfc4314Rights$.MODULE$.fromJava(resolveMailboxACL.getEntries().getOrDefault(this.aclEntryKey(mailboxSession), MailboxACL.NO_RIGHTS)).toRights();
            mailboxRights = new MailboxRights(rights.contains((Object)Right$.MODULE$.Read()), rights.contains((Object)Right$.MODULE$.Insert()), rights.contains((Object)Right$.MODULE$.DeleteMessages()), rights.contains((Object)Right$.MODULE$.Seen()), rights.contains((Object)Right$.MODULE$.Write()), false, false, false, false);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return mailboxRights;
    }

    private boolean retrieveIsSubscribed(MailboxPath path, MailboxSession session) {
        return this.subscriptionManager.subscriptions(session).contains(path.getName());
    }

    public SMono<Mailbox> create(MailboxMetaData mailboxMetaData, MailboxSession mailboxSession, Subscriptions subscriptions, Seq<MailboxMetaData> allMailboxesMetadata, QuotaLoader quotaLoader) {
        SMono sMono;
        MailboxCounters.Sanitized sanitizedCounters = mailboxMetaData.getCounters().sanitize();
        Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(mailboxMetaData.getPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
        if (either instanceof Left) {
            Left left = (Left)either;
            Exception error = (Exception)left.value();
            sMono = SMono$.MODULE$.raiseError((Throwable)error);
        } else if (either instanceof scala.util.Right) {
            scala.util.Right right = (scala.util.Right)either;
            MailboxValidation mailboxValidation = (MailboxValidation)right.value();
            sMono = SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(mailboxMetaData.getPath())).map((Function1 & Serializable)quotas -> MailboxFactory.$anonfun$create$1(this, mailboxMetaData, mailboxSession, allMailboxesMetadata, subscriptions, mailboxValidation, ((Quotas)quotas).quotas()));
        } else {
            throw new MatchError(either);
        }
        return sMono;
    }

    public SMono<Mailbox> create(MailboxId id, MailboxSession mailboxSession, QuotaLoader quotaLoader) {
        SMono sMono;
        try {
            SMono sMono2;
            MessageManager messageManager = this.mailboxManager.getMailbox(id, mailboxSession);
            MailboxCounters.Sanitized sanitizedCounters = messageManager.getMailboxCounters(mailboxSession).sanitize();
            Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(messageManager.getMailboxPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
            if (either instanceof Left) {
                Left left = (Left)either;
                Exception error = (Exception)left.value();
                sMono2 = SMono$.MODULE$.raiseError((Throwable)error);
            } else if (either instanceof scala.util.Right) {
                scala.util.Right right = (scala.util.Right)either;
                MailboxValidation mailboxValidation = (MailboxValidation)right.value();
                sMono2 = SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(messageManager.getMailboxPath())).map((Function1 & Serializable)quotas -> MailboxFactory.$anonfun$create$4(this, messageManager, mailboxSession, id, mailboxValidation, ((Quotas)quotas).quotas()));
            } else {
                throw new MatchError(either);
            }
            sMono = sMono2;
        }
        catch (Exception error) {
            sMono = SMono$.MODULE$.raiseError((Throwable)error);
        }
        return sMono;
    }

    public static final /* synthetic */ Mailbox $anonfun$create$1(MailboxFactory $this, MailboxMetaData mailboxMetaData$1, MailboxSession mailboxSession$2, Seq allMailboxesMetadata$1, Subscriptions subscriptions$1, MailboxValidation mailboxValidation$1, Map quotas) {
        MailboxId id = mailboxMetaData$1.getId();
        Option<Role> role = $this.getRole(mailboxMetaData$1.getPath(), mailboxSession$2);
        SortOrder sortOrder = $this.getSortOrder(role);
        Rights rights = $this.getRights(mailboxMetaData$1.getResolvedAcls());
        MailboxNamespace namespace = $this.getNamespace(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option<MailboxPath> parentPath = $this.getParentPath(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option parentId = ((IterableOps)((IterableOps)allMailboxesMetadata$1.filter((Function1 & Serializable)otherMetadata -> BoxesRunTime.boxToBoolean((boolean)parentPath.contains((Object)otherMetadata.getPath())))).map((Function1 & Serializable)x$2 -> x$2.getId())).headOption();
        MailboxRights myRights = $this.getMyRights(mailboxMetaData$1.getPath(), mailboxMetaData$1.getResolvedAcls(), mailboxSession$2);
        boolean isSubscribed = subscriptions$1.isSubscribed(mailboxMetaData$1);
        MailboxId x$1 = id;
        String x$22 = mailboxValidation$1.mailboxName();
        Option x$3 = parentId;
        Option<Role> x$4 = role;
        SortOrder x$5 = sortOrder;
        UnreadEmails x$6 = mailboxValidation$1.unreadEmails();
        TotalEmails x$7 = mailboxValidation$1.totalEmails();
        UnreadThreads x$8 = mailboxValidation$1.unreadThreads();
        TotalThreads x$9 = mailboxValidation$1.totalThreads();
        MailboxRights x$10 = myRights;
        MailboxNamespace x$11 = namespace;
        Rights x$12 = rights;
        Map x$13 = quotas;
        boolean x$14 = isSubscribed;
        return new Mailbox(x$1, x$22, (Option<MailboxId>)x$3, x$4, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, (Map<QuotaId, Quota>)x$13);
    }

    public static final /* synthetic */ Mailbox $anonfun$create$4(MailboxFactory $this, MessageManager messageManager$1, MailboxSession mailboxSession$3, MailboxId id$1, MailboxValidation mailboxValidation$2, Map quotas) {
        MailboxACL resolvedACL = messageManager$1.getResolvedAcl(mailboxSession$3);
        Option<Role> role = $this.getRole(messageManager$1.getMailboxPath(), mailboxSession$3);
        SortOrder sortOrder = $this.getSortOrder(role);
        Rights rights = $this.getRights(resolvedACL);
        MailboxNamespace namespace = $this.getNamespace(messageManager$1.getMailboxPath(), mailboxSession$3);
        Option parentId = $this.getParentPath(messageManager$1.getMailboxPath(), mailboxSession$3).flatMap((Function1 & Serializable)parentPath -> (Option)Try$.MODULE$.apply((Function0 & Serializable)() -> new Some((Object)$this.mailboxManager.getMailbox(parentPath, mailboxSession$3))).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof MailboxNotFoundException ? None$.MODULE$ : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof MailboxNotFoundException;
                return bl;
            }
        }).get()).map((Function1 & Serializable)x$3 -> x$3.getId());
        MailboxRights myRights = $this.getMyRights(messageManager$1.getMailboxPath(), resolvedACL, mailboxSession$3);
        boolean isSubscribed = $this.retrieveIsSubscribed(messageManager$1.getMailboxPath(), mailboxSession$3);
        MailboxId x$1 = id$1;
        String x$2 = mailboxValidation$2.mailboxName();
        Option x$32 = parentId;
        Option<Role> x$4 = role;
        SortOrder x$5 = sortOrder;
        UnreadEmails x$6 = mailboxValidation$2.unreadEmails();
        TotalEmails x$7 = mailboxValidation$2.totalEmails();
        UnreadThreads x$8 = mailboxValidation$2.unreadThreads();
        TotalThreads x$9 = mailboxValidation$2.totalThreads();
        MailboxRights x$10 = myRights;
        MailboxNamespace x$11 = namespace;
        Rights x$12 = rights;
        Map x$13 = quotas;
        boolean x$14 = isSubscribed;
        return new Mailbox(x$1, x$2, (Option<MailboxId>)x$32, x$4, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, (Map<QuotaId, Quota>)x$13);
    }

    @Inject
    public MailboxFactory(SubscriptionManager subscriptionManager, MailboxManager mailboxManager) {
        this.subscriptionManager = subscriptionManager;
        this.mailboxManager = mailboxManager;
    }
}

