/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\u0007\u000f\u0001mA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003T\u0001\u0011\u0005C\u000bC\u0003T\u0001\u0011\u0005C\u000fC\u0003T\u0001\u0011\u0005c\u0010C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0005Q\u0001\u0016m]:UQJ|Wo\u001a5CY>\u00147\u000b^8sK*\u0011q\u0002E\u0001\u000eI\u0016$W\u000f\u001d7jG\u0006$\u0018n\u001c8\u000b\u0005E\u0011\u0012\u0001\u00022m_\nT!a\u0005\u000b\u0002\rM,'O^3s\u0015\t)b#A\u0003kC6,7O\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0004\u0001q!\u0003CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0015JS\"\u0001\u0014\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011\u0003F\u0005\u0003U\u0019\u0012\u0011B\u00117pEN#xN]3\u0002\u0019\tdwNY*u_J,G)Q(\u0011\u0005\u0015j\u0013B\u0001\u0018'\u00051\u0011En\u001c2Ti>\u0014X\rR!P\u0003E!WMZ1vYR\u0014UoY6fi:\u000bW.\u001a\t\u0003KEJ!A\r\u0014\u0003\u0015\t+8m[3u\u001d\u0006lW\r\u000b\u0003\u0003iqj\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0019IgN[3di*\t\u0011(A\u0003kCZ\f\u00070\u0003\u0002<m\t)a*Y7fI\u0006)a/\u00197vK\u0006\na(A\u0007eK\u001a\fW\u000f\u001c;Ck\u000e\\W\r^\u0001\u000eE2|'-\u00133GC\u000e$xN]=\u0011\u0005\u0005#eBA\u0013C\u0013\t\u0019e%\u0001\u0004CY>\u0014\u0017\nZ\u0005\u0003\u000b\u001a\u0013qAR1di>\u0014\u0018P\u0003\u0002DM\u00051A(\u001b8jiz\"B!S&M\u001dB\u0011!\nA\u0007\u0002\u001d!)1\u0006\u0002a\u0001Y!)q\u0006\u0002a\u0001a!\"A\n\u000e\u001f>\u0011\u0015yD\u00011\u0001AQ\t!\u0001\u000b\u0005\u00026#&\u0011!K\u000e\u0002\u0007\u0013:TWm\u0019;\u0002\tM\fg/\u001a\u000b\u0005+z\u00037\u000eE\u0002W3nk\u0011a\u0016\u0006\u00031b\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u00035^\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0005\u0015b\u0016BA/'\u0005\u0019\u0011En\u001c2JI\")q,\u0002a\u0001a\u0005Q!-^2lKRt\u0015-\\3\t\u000b\u0005,\u0001\u0019\u00012\u0002\t\u0011\fG/\u0019\t\u0004G\u001aDW\"\u00013\u000b\u0003\u0015\fQa]2bY\u0006L!a\u001a3\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\rL\u0017B\u00016e\u0005\u0011\u0011\u0015\u0010^3\t\u000b1,\u0001\u0019A7\u0002\u001bM$xN]1hKB{G.[2z!\tq\u0017O\u0004\u0002&_&\u0011\u0001OJ\u0001\n\u00052|'m\u0015;pe\u0016L!A]:\u0003\u001bM#xN]1hKB{G.[2z\u0015\t\u0001h\u0005\u0006\u0003VkZl\b\"B0\u0007\u0001\u0004\u0001\u0004\"B1\u0007\u0001\u00049\bC\u0001=|\u001b\u0005I(B\u0001>!\u0003\tIw.\u0003\u0002}s\nY\u0011J\u001c9viN#(/Z1n\u0011\u0015ag\u00011\u0001n)\u0019)v0!\u0001\u0002\u001a!)ql\u0002a\u0001a!1\u0011m\u0002a\u0001\u0003\u0007\u0001B!!\u0002\u0002\u00165\u0011\u0011q\u0001\u0006\u0004u\u0006%!\u0002BA\u0006\u0003\u001b\taaY8n[>t'\u0002BA\b\u0003#\taaZ8pO2,'BAA\n\u0003\r\u0019w.\\\u0005\u0005\u0003/\t9A\u0001\u0006CsR,7k\\;sG\u0016DQ\u0001\\\u0004A\u00025\f\u0011B]3bI\nKH/Z:\u0015\r\u0005}\u0011\u0011EA\u0012!\r1\u0016L\u0019\u0005\u0006?\"\u0001\r\u0001\r\u0005\u0007\u0003KA\u0001\u0019A.\u0002\r\tdwNY%e\u0003\u0011\u0011X-\u00193\u0015\u000b]\fY#!\f\t\u000b}K\u0001\u0019\u0001\u0019\t\r\u0005\u0015\u0012\u00021\u0001\\\u0003Q9W\r\u001e#fM\u0006,H\u000e\u001e\"vG.,GOT1nKR\t\u0001'\u0001\u0007eK2,G/\u001a\"vG.,G\u000f\u0006\u0003\u00028\u0005}\u0002\u0003\u0002,Z\u0003s\u00012!HA\u001e\u0013\r\tiD\b\u0002\u0005->LG\rC\u0003`\u0017\u0001\u0007\u0001'\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003\u000b\ni%a\u0014\u0011\tYK\u0016q\t\t\u0004;\u0005%\u0013bAA&=\t9!i\\8mK\u0006t\u0007\"B0\r\u0001\u0004\u0001\u0004BBA\u0013\u0019\u0001\u00071\f")
public class PassThroughBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public Publisher<BlobId> save(BucketName x$1, String x$2, BlobStore.StoragePolicy x$3) {
        return super.save(x$1, x$2, x$3);
    }

    public Publisher<byte[]> readBytes(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readBytes(x$1, x$2, x$3);
    }

    public InputStream read(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.read(x$1, x$2, x$3);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.fromPublisher(this.blobStoreDAO.delete(bucketName, blobId)).then(SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Inject
    public PassThroughBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

