/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.user;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.table.CassandraSubscriptionTable;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class CassandraSubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private final Session session;
    private CassandraUtils cassandraUtils;

    public CassandraSubscriptionMapper(Session session, CassandraUtils cassandraUtils) {
        this.session = session;
        this.cassandraUtils = cassandraUtils;
    }

    public synchronized void delete(Subscription subscription) {
        this.session.execute((Statement)QueryBuilder.delete().from("subscription").where(QueryBuilder.eq((String)"user", (Object)subscription.getUser().asString())).and(QueryBuilder.eq((String)"mailbox", (Object)subscription.getMailbox())));
    }

    public List<Subscription> findSubscriptionsForUser(Username user) {
        return this.cassandraUtils.convertToStream(this.session.execute((Statement)QueryBuilder.select((String[])new String[]{"mailbox"}).from("subscription").where(QueryBuilder.eq((String)"user", (Object)user.asString())))).map(row -> new Subscription(user, row.getString("mailbox"))).collect(Collectors.toList());
    }

    public synchronized void save(Subscription subscription) {
        this.session.execute((Statement)QueryBuilder.insertInto((String)"subscription").value("user", (Object)subscription.getUser().asString()).value("mailbox", (Object)subscription.getMailbox()));
    }

    public List<Subscription> list() {
        return this.cassandraUtils.convertToStream(this.session.execute((Statement)QueryBuilder.select((String[])CassandraSubscriptionTable.FIELDS).from("subscription"))).map(row -> new Subscription(Username.of((String)row.getString("user")), row.getString("mailbox"))).collect(Collectors.toList());
    }
}

