/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.GhostMailbox;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraIdAndPath;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxPathV2Table;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxPathV2DAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final CassandraUtils cassandraUtils;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectUser;
    private final PreparedStatement selectAll;
    private final ConsistencyLevel consistencyLevel;

    @Inject
    public CassandraMailboxPathV2DAO(Session session, CassandraUtils cassandraUtils, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.consistencyLevel = consistenciesConfiguration.getLightweightTransaction();
        this.cassandraUtils = cassandraUtils;
        this.insert = this.prepareInsert(session);
        this.delete = this.prepareDelete(session);
        this.select = this.prepareSelect(session);
        this.selectUser = this.prepareSelectUser(session);
        this.selectAll = this.prepareSelectAll(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailboxPathV2").where(QueryBuilder.eq((String)"namespace", (Object)QueryBuilder.bindMarker((String)"namespace"))).and(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName"))).ifExists());
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailboxPathV2").value("namespace", (Object)QueryBuilder.bindMarker((String)"namespace")).value("user", (Object)QueryBuilder.bindMarker((String)"user")).value("mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).ifNotExists());
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathV2Table.FIELDS).from("mailboxPathV2").where(QueryBuilder.eq((String)"namespace", (Object)QueryBuilder.bindMarker((String)"namespace"))).and(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName"))));
    }

    private PreparedStatement prepareSelectUser(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathV2Table.FIELDS).from("mailboxPathV2").where(QueryBuilder.eq((String)"namespace", (Object)QueryBuilder.bindMarker((String)"namespace"))).and(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathV2Table.FIELDS).from("mailboxPathV2"));
    }

    public Mono<CassandraIdAndPath> retrieveId(MailboxPath mailboxPath) {
        return this.cassandraAsyncExecutor.executeSingleRow(this.select.bind().setString("namespace", mailboxPath.getNamespace()).setString("user", this.sanitizeUser(mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()).setConsistencyLevel(this.consistencyLevel)).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logGhostMailboxSuccess)).switchIfEmpty(ReactorUtils.executeAndEmpty(() -> this.logGhostMailboxFailure(mailboxPath)));
    }

    public Flux<CassandraIdAndPath> listUserMailboxes(String namespace, Username user) {
        return this.cassandraAsyncExecutor.execute(this.selectUser.bind().setString("namespace", namespace).setString("user", this.sanitizeUser(user)).setConsistencyLevel(this.consistencyLevel)).flatMapMany(arg_0 -> ((CassandraUtils)this.cassandraUtils).convertToFlux(arg_0)).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logReadSuccess));
    }

    public Flux<CassandraIdAndPath> listAll() {
        return this.cassandraAsyncExecutor.execute((Statement)this.selectAll.bind()).flatMapMany(arg_0 -> ((CassandraUtils)this.cassandraUtils).convertToFlux(arg_0)).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logReadSuccess));
    }

    public void logGhostMailboxSuccess(CassandraIdAndPath value) {
        this.logReadSuccess(value);
    }

    public void logGhostMailboxFailure(MailboxPath mailboxPath) {
        GhostMailbox.logger().addField(GhostMailbox.MAILBOX_NAME, (Object)mailboxPath).addField(GhostMailbox.TYPE, (Object)"readMiss").log(logger -> logger.debug("Read mailbox missed"));
    }

    private void logReadSuccess(CassandraIdAndPath cassandraIdAndPath) {
        GhostMailbox.logger().addField(GhostMailbox.MAILBOX_NAME, (Object)cassandraIdAndPath.getMailboxPath()).addField(GhostMailbox.TYPE, (Object)"readSuccess").addField(GhostMailbox.MAILBOX_ID, (Object)cassandraIdAndPath.getCassandraId()).log(logger -> logger.debug("Read mailbox succeeded"));
    }

    private CassandraIdAndPath fromRowToCassandraIdAndPath(Row row) {
        return new CassandraIdAndPath(CassandraId.of(row.getUUID("mailboxId")), new MailboxPath(row.getString("namespace"), Username.of((String)row.getString("user")), row.getString("mailboxName")));
    }

    public Mono<Boolean> save(MailboxPath mailboxPath, CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.insert.bind().setString("namespace", mailboxPath.getNamespace()).setString("user", this.sanitizeUser(mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()).setUUID("mailboxId", mailboxId.asUuid()));
    }

    public Mono<Void> delete(MailboxPath mailboxPath) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setString("namespace", mailboxPath.getNamespace()).setString("user", this.sanitizeUser(mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()));
    }

    private String sanitizeUser(Username user) {
        if (user == null) {
            return "";
        }
        return user.asString();
    }
}

