/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentOwnerTable;
import org.apache.james.mailbox.model.AttachmentId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAttachmentOwnerDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement addStatement;
    private final PreparedStatement selectStatement;

    @Inject
    public CassandraAttachmentOwnerDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectStatement = this.prepareSelect(session);
        this.addStatement = this.prepareAdd(session);
    }

    private PreparedStatement prepareAdd(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"attachmentOwners").value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("owner", (Object)QueryBuilder.bindMarker((String)"owner")));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraAttachmentOwnerTable.FIELDS).from("attachmentOwners").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    public Mono<Void> addOwner(AttachmentId attachmentId, Username owner) {
        return this.executor.executeVoid((Statement)this.addStatement.bind().setUUID("id", attachmentId.asUUID()).setString("owner", owner.asString()));
    }

    public Flux<Username> retrieveOwners(AttachmentId attachmentId) {
        return this.executor.executeRows((Statement)this.selectStatement.bind().setUUID("id", attachmentId.asUUID())).map(this::toOwner);
    }

    private Username toOwner(Row row) {
        return Username.of((String)row.getString("owner"));
    }
}

