/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.backends.cassandra.migration.CassandraMigrationService;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.CassandraVersionRequest;
import org.apache.james.webadmin.dto.CassandraVersionResponse;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"Cassandra migration"})
@Path(value=":cassandra/version")
@Produces(value={"application/json"})
public class CassandraMigrationRoutes
implements Routes {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMigrationRoutes.class);
    public static final String VERSION_BASE = "/cassandra/version";
    private static final String VERSION_BASE_LATEST = "/cassandra/version/latest";
    private static final String VERSION_UPGRADE_BASE = "/cassandra/version/upgrade";
    private static final String VERSION_UPGRADE_TO_LATEST_BASE = "/cassandra/version/upgrade/latest";
    private final CassandraMigrationService cassandraMigrationService;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    public static String INVALID_VERSION_UPGRADE_REQUEST = "Invalid request for version upgrade";
    public static String MIGRATION_REQUEST_CAN_NOT_BE_DONE = "The migration requested can not be performed";
    public static String PARTIAL_MIGRATION_PROCESS = "An error lead to partial migration process";

    @Inject
    public CassandraMigrationRoutes(CassandraMigrationService cassandraMigrationService, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.cassandraMigrationService = cassandraMigrationService;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return VERSION_BASE;
    }

    public void define(Service service) {
        service.get(VERSION_BASE, (request, response) -> this.getCassandraCurrentVersion(), (ResponseTransformer)this.jsonTransformer);
        service.get(VERSION_BASE_LATEST, (request, response) -> this.getCassandraLatestVersion(), (ResponseTransformer)this.jsonTransformer);
        TaskFromRequest upgradeToVersionTaskFromRequest = this::upgradeToVersion;
        service.post(VERSION_UPGRADE_BASE, upgradeToVersionTaskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
        TaskFromRequest upgradeToLatestTaskFromRequest = request -> this.upgradeToLatest();
        service.post(VERSION_UPGRADE_TO_LATEST_BASE, upgradeToLatestTaskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    @POST
    @Path(value="upgrade/latest")
    @ApiOperation(value="Triggers a migration of Cassandra schema to the latest available")
    @ApiResponses(value={@ApiResponse(code=201, message="The taskId of the given scheduled task", response=TaskIdDto.class, responseHeaders={@ResponseHeader(name="Location", description="URL of the resource associated with the scheduled task")}), @ApiResponse(code=409, message="Migration can not be done")})
    public Task upgradeToLatest() {
        try {
            return this.cassandraMigrationService.upgradeToLastVersion();
        }
        catch (IllegalStateException e) {
            LOGGER.info(MIGRATION_REQUEST_CAN_NOT_BE_DONE, (Throwable)e);
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(MIGRATION_REQUEST_CAN_NOT_BE_DONE).cause((Exception)e).haltError();
        }
    }

    @POST
    @Path(value="upgrade")
    @ApiOperation(value="Triggers a migration of Cassandra schema to a specific version")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, paramType="body", dataType="Integer", example="3", value="The schema version to upgrade to.")})
    @ApiResponses(value={@ApiResponse(code=201, message="The taskId of the given scheduled task", response=TaskIdDto.class, responseHeaders={@ResponseHeader(name="Location", description="URL of the resource associated with the scheduled task")}), @ApiResponse(code=409, message="Migration can not be done")})
    public Task upgradeToVersion(Request request) {
        LOGGER.debug("Cassandra upgrade launched");
        CassandraVersionRequest cassandraVersionRequest = CassandraVersionRequest.parse(request.body());
        return this.cassandraMigrationService.upgradeToVersion(cassandraVersionRequest.getValue());
    }

    @GET
    @Path(value="latest")
    @ApiOperation(value="Getting the latest version available for Cassandra schema")
    @ApiResponses(value={@ApiResponse(code=200, message="The latest version of the schema", response=CassandraVersionResponse.class)})
    public CassandraVersionResponse getCassandraLatestVersion() {
        return CassandraVersionResponse.from(this.cassandraMigrationService.getLatestVersion());
    }

    @GET
    @ApiOperation(value="Getting the current version used by Cassandra schema")
    @ApiResponses(value={@ApiResponse(code=200, message="The current version of the schema", response=CassandraVersionResponse.class)})
    public CassandraVersionResponse getCassandraCurrentVersion() {
        return CassandraVersionResponse.from(this.cassandraMigrationService.getCurrentVersion());
    }
}

